<?php 
if($tipo_reporte == 'excel'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");

if($tipo_reporte != 'grid'){
    ?>
    <style type="text/css">
        .tabla {			
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        td {	
            text-align: center;
            font-family: arial;				
        }
        .impar {
            background-color: #D7E5F7;
        }
        .par {
            background-color: #B9D5F7;	
        }
        .fuente_titulo {
            font-family: <?php echo $tipo_fuente; ?>;
        }
        .borde{
            border: solid 1px black;
        }
    </style>

    <table align="center" cellpadding="0" border="0">
        <?php if ($tipo_reporte == 'pdf') {
            ?>
            <tr>
                <td style="width:100%;"><?php echo $header; ?></td>
            </tr>
            <tr>
                <td style="text-align:left"><b>Período: </b><?php echo formatear_fecha('d/m/Y', $fecha_ini); ?> al <?php echo formatear_fecha('d/m/Y', $fecha_fin); ?>.</td>
            </tr>
            <?php
        } else {
            ?>
            <tr>
                <td></td>
                <td colspan="3">
                    <center><b style="font-size:12px"> <?=$this->gsatelite->get_parametro('SYS_EMPRESA')?> </b></center>
                    <center><b>Reporte acumulado de facturas mensuales por producto</b></center>
                    <center><b>Facturas de <?=date('d/m/Y', strtotime($fecha_ini))?> al <?=date('d/m/Y', strtotime($fecha_fin))?></b></center>
                </td>
                <td>
                    <font style="float:right"><b><?=$this->gsatelite->get_parametro('SYS_DEPARTAMENTO')?></b></font><br>
                    <font style="float:right"><b><?=date('d/m/Y')?> </b></font><br>
                    <font style="float:right"><b><?=$this->tank_auth->get_username()?></b></font>
                </td>
            </tr>
            <?php
        }
        ?>        
    </table>
    <div class="clear"><br></div>
    <?php
}
?>  

<table class="tabla" align="center" cellpadding="0" border="0" style="margin-left:auto;margin-right:auto">
    <?php
    if (count($facturas) > 0) {
        $mostrar_tia = true;
        $mostrar_art = true;
        $total_prod = $tot_imp_art = $tot_sub_art = 0;
        $first_tia = $facturas[0]['tia_id'];
        $first_art = $facturas[0]['art_id'];
        foreach ($facturas as $key => $value) {
            if ($value['tia_id'] == $first_tia) {
                //tia 1 art 1
                if ($mostrar_tia) {
                    ?>
                    <tr>
                        <th colspan="5" style="text-align: left; border-bottom: solid 1px black;"><b>Categoría: <i><?php echo $value['tia_nombre'] ?></i></b></th>
                    </tr>
                    <?php
                    $mostrar_tia = false;
                }
                if ($value['art_id'] == $first_art) {
                    $tot_imp_art += number_format($value['impuestos'], 2, '.', '');
                    $tot_sub_art += number_format($value['subtotal'], 2, '.', '');
                    $total_fila = number_format($value['subtotal'], 2, '.', '') + number_format($value['impuestos'], 2, '.', '');
                    if ($mostrar_art) {
                        ?>
                        <tr>
                            <th colspan="5" style="text-align: left;"><b>Producto / Servicio: </b><?php echo $value['art_nombre'] ?></th>
                        </tr>
                        <tr>
                            <th class="borde"><b>Área</b></th>
                            <th class="borde"><b>Tipo de pago</b></th>
                            <th class="borde"><b>Venta Acumulada</b></th>
                            <th class="borde"><b>Impuestos Acumulados</b></th>
                            <th class="borde"><b>Total Acumulado</b></th>
                        </tr>
                        <?php
                        $mostrar_art = false;
                    }
                    ?>
                    <tr>
                        <td style="text-align: left;"><?php echo $value['arf_nombre']; ?></td>
                        <td style="text-align: left;"><?php echo $value['tipo_pago']; ?></td>
                        <td style="text-align: right;">$<?php echo number_format($value['subtotal'], 2); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($value['impuestos'], 2); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($total_fila, 2); ?></td>
                    </tr>
                    <?php
                    $total_prod += $total_fila;
                } else {
                    //tia 1 art 2
                    ?>
                    <tr>
                        <th style="text-align: right;" colspan="2"><b>Totales</b></th>
                        <th style="text-align: right; border-top: solid 1px black;">$<?php echo number_format($tot_sub_art, 2); ?></th>
                        <th style="text-align: right; border-top: solid 1px black;">$<?php echo number_format($tot_imp_art, 2); ?></th>
                        <th style="text-align: right; border-top: solid 1px black;"><b>$<?php echo number_format($total_prod, 2); ?></b></th>
                    </tr>
                    <?php
                    $total_prod = $tot_imp_art = $tot_sub_art = 0;
                    $mostrar_art = true;
                    $first_art = $value['art_id'];
                    $tot_imp_art += number_format($value['impuestos'], 2, '.', '');
                    $tot_sub_art += number_format($value['subtotal'], 2, '.', '');
                    $total_fila = number_format($value['subtotal'], 2, '.', '') + number_format($value['impuestos'], 2, '.', '');
                    if ($mostrar_art) {
                        ?>
                        <tr>
                            <th colspan="5" style="text-align: left;"><b>Producto / Servicio: </b><?php echo $value['art_nombre'] ?></th>
                        </tr>
                        <tr>
                            <th class="borde"><b>Área</b></th>
                            <th class="borde"><b>Tipo de pago</b></th>
                            <th class="borde"><b>Venta Acumulada</b></th>
                            <th class="borde"><b>Impuestos Acumulados</b></th>
                            <th class="borde"><b>Total Acumulado</b></th>
                        </tr>
                        <?php
                        $mostrar_art = false;
                    }
                    ?>
                    <tr>
                        <td style="text-align: left;"><?php echo $value['arf_nombre']; ?></td>
                        <td style="text-align: left;"><?php echo $value['tipo_pago']; ?></td>
                        <td style="text-align: right;">$<?php echo number_format($value['subtotal'], 2); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($value['impuestos'], 2); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($total_fila, 2); ?></td>
                    </tr>
                    <?php
                    $total_prod += $total_fila;
                }                
            } else {
                //tia 2 art 1
                ?>
                <tr>
                    <th style="text-align: right;" colspan="2"><b>Totales</b></th>
                    <th style="text-align: right; border-top: solid 1px black;">$<?php echo number_format($tot_sub_art, 2); ?></th>
                    <th style="text-align: right; border-top: solid 1px black;">$<?php echo number_format($tot_imp_art, 2); ?></th>
                    <th style="text-align: right; border-top: solid 1px black;"><b>$<?php echo number_format($total_prod, 2); ?></b></th>
                </tr>
                <?php
                $total_prod = $tot_imp_art = $tot_sub_art = 0;
                $mostrar_art = true;
                $mostrar_tia = true;
                $first_art = $value['art_id'];
                $first_tia = $value['tia_id'];
                if ($mostrar_tia) {
                    ?>
                    <tr>
                        <th colspan="5" style="text-align: left; border-bottom: solid 1px black;"><b>Categoría: <i><?php echo $value['tia_nombre'] ?></i></b></th>
                    </tr>
                    <?php
                    $mostrar_tia = false;
                }
                if ($value['art_id'] == $first_art) {
                    $tot_imp_art += number_format($value['impuestos'], 2, '.', '');
                    $tot_sub_art += number_format($value['subtotal'], 2, '.', '');
                    $total_fila = number_format($value['subtotal'], 2, '.', '') + number_format($value['impuestos'], 2, '.', '');
                    if ($mostrar_art) {
                        ?>
                        <tr>
                            <th colspan="5" style="text-align: left;"><b>Producto / Servicio: </b><?php echo $value['art_nombre'] ?></th>
                        </tr>
                        <tr>
                            <th class="borde"><b>Área</b></th>
                            <th class="borde"><b>Tipo de pago</b></th>
                            <th class="borde"><b>Venta Acumulada</b></th>
                            <th class="borde"><b>Impuestos Acumulados</b></th>
                            <th class="borde"><b>Total Acumulado</b></th>
                        </tr>
                        <?php
                        $mostrar_art = false;
                    }
                    ?>
                    <tr>
                        <td style="text-align: left;"><?php echo $value['arf_nombre']; ?></td>
                        <td style="text-align: left;"><?php echo $value['tipo_pago']; ?></td>
                        <td style="text-align: right;">$<?php echo number_format($value['subtotal'], 2); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($value['impuestos'], 2); ?></td>
                        <td style="text-align: right;">$<?php echo number_format($total_fila, 2); ?></td>
                    </tr>
                    <?php
                    $total_prod += $total_fila;
                }
            }
        }
        ?>
        <tr>
            <th style="text-align: right;" colspan="2"><b>Totales</b></th>
            <th style="text-align: right; border-top: solid 1px black;">$<?php echo number_format($tot_sub_art, 2); ?></th>
            <th style="text-align: right; border-top: solid 1px black;">$<?php echo number_format($tot_imp_art, 2); ?></th>
            <th style="text-align: right; border-top: solid 1px black;"><b>$<?php echo number_format($total_prod, 2); ?></b></th>
        </tr>
        <?php
    } else {
        ?>
        <tr>
            <td width="100%" style="text-align: center;"><b>No se encontraron registros</b></td>
        </tr>
        <?php
    }
    ?>
</table>
