<?php 
if($tipo_reporte == 'excel'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}

$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");

if($tipo_reporte != 'grid'){
    ?>
    <style type="text/css">
        .tabla
        {			
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        td
        {	
            text-align: center;
            font-family: arial;				
        }
        .impar
        {
            background-color: #D7E5F7;
        }
        .par
        {
            background-color: #B9D5F7;	
        }
        .fuente_titulo{
            font-family: <?php echo $tipo_fuente; ?>;
        }

        table#quedan {
            width: 90%;    
            margin: auto;
        }

        td#firma {
            background-color: black;   
            color: white;
        }
    </style>
    <table align="center" cellpadding="0" border="0">
        <tr>
            <td style="width:100%;"><table class="tabla" align="center" cellpadding="0" border="0" style="margin-left:auto;margin-right:auto">
                    <?php if($tipo_reporte == 'pdf'){ 
                        ?>
                        <tr>
                            <td><?php echo $header; ?></td>
                        </tr>
                        <tr>
                            <td style="text-align:left"><b>Período:</b><?php echo formatear_fecha('d/m/Y', $fecha_ini) . ' al ' . formatear_fecha('d/m/Y', $fecha_fin); ?><br/><br/></td>
                        </tr>
                        <?php                        
                    } else{ 
                        ?>
                        <tr>
                            <td align="center" width="80%">
                                <table>
                                    <tr>
                                        <td></td>
                                        <td colspan="3">
                                            <b style="font-size:12px"> <?=$this->gsatelite->get_parametro('SYS_EMPRESA')?> </b></center>
                                            <center><b>Reporte de facturación acumulado mensual por categoría.</b></center>
                                            <center><b>Facturas de <?=date('d/m/Y', strtotime($fecha_ini))?> al <?=date('d/m/Y', strtotime($fecha_fin))?></b></center>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td width="10%">
                                <table border="0" width="100%" style="">
                                    <tr>
                                        <td align="center" colspan="1">
                                            <font style="float:right"><b><?=$this->gsatelite->get_parametro('SYS_DEPARTAMENTO')?></b></font><br>
                                            <font style="float:right"><b><?=date('d/m/Y')?> </b></font><br>
                                            <font style="float:right"><b><?=$this->tank_auth->get_username()?></b></font>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        <?php 
                    }
                    ?>
                    <tr><td colspan="3"><table border="1"><tbody>
                                    <?php
                                    if(count($facturas) != 0){
                                        $area_temp = '-1';
                                        $tipoP_temp = '-1';
                                        $producto_temp = '-1';
                                        $tabla = '';
                                        $registros = 0;
                                        foreach ($facturas as $key) {
                                            $monto_inicio = 0;
                                            $registros++;
                                            //agrega el encabezado de la categoria
                                            if($area_temp != $key['tia_nombre']){
                                                $area_temp = $key['tia_nombre'];
                                                $tabla .= '
                                                <tr nobr="true" style="font-weight: bold;">
                                                <th colspan="5">Categoría: '.$key['tia_codigo'].' - '.$area_temp.'</th>
                                                </tr>
                                                <tr nobr="true" style="font-weight: bold;">
                                                <th>Área</th>
                                                <th>Acum. Mensual<br>Saldo inicial</th>
                                                <th>Tipo de pago</th>
                                                <th>Totales diarios</th>
                                                <th>Acum. Mensual<br>Total acumulado</th>
                                                </tr>
                                                ';
                                            }
                                            //iniciamos los arreglos
                                            $tipoP_arreglo = array();
                                            $monto_arreglo = array();
                                            $contador_tips_pago = -1;
                                            $monto_inicio = 0;
                                            $pago_temp = '-1';
                                            $prueba = "";
                                            foreach ($tipos_pago as $key2) {
                                                if($key['art_id'] == $key2['art_id']){
                                                    if($key['are_id'] == $key2['are_id']){
                                                    //comparamos que la fecha sea difernte a la fecha de inicio que sera el dia 1 de mes
                                                        if( formatear_fecha('d-m-Y', $key2['fac_fecha_fact']) != $fecha_ini){
                                                            if($pago_temp != $key2['detalles_pago']){ 
                                                                //verificamos que el detalle solo se repita 1 vez
                                                                $pago_temp = $key2['detalles_pago'];
                                                                $contador_tips_pago++;
                                                                //inicializamos la posicion de los arreglos para que no nos arroje error
                                                                if(@count($tipoP_arreglo[$contador_tips_pago]) == 0){
                                                                    $tipoP_arreglo[$contador_tips_pago] = "";
                                                                }
                                                                if(@count($monto_arreglo[$contador_tips_pago]) == 0){
                                                                    $monto_arreglo[$contador_tips_pago] = 0;
                                                                }
                                                                //guardamos el primer elemento del tipo de pago en el arreglo
                                                                $tipoP_arreglo[$contador_tips_pago] = $pago_temp;
                                                            }
                                                            //se iran sumando todos los elementos de ese tipo de pago
                                                            $monto_arreglo[$contador_tips_pago] += $key2['monto_total_producto'];
                                                        } else{
                                                            $monto_inicio += $key2['monto_total_producto'];
                                                        }
                                                    }
                                                }
                                            }
                                            $sumar_montos_tipoP = 0;
                                            $tabla2 = '<table width="100%" cellspacing="0" border="1">';
                                            for ($x=0; $x < count($tipoP_arreglo); $x++) { 
                                                $tabla2 .= '<tr>';
                                                $tabla2 .= '<td width="50%">'.$tipoP_arreglo[$x].'</td>';
                                                $tabla2 .= '<td width="50%">$'.number_format($monto_arreglo[$x],2).'</td>';
                                                $tabla2 .= '</tr>';
                                                $sumar_montos_tipoP += $monto_arreglo[$x];
                                            }
                                            $tabla2 .= "</table>";
                                            $area_nombre = $key['are_nombre'];
                                            if(trim($key['are_nombre']) == ""){
                                                $area_nombre = 'Sin área';
                                            }
                                            if( count($tipoP_arreglo) == 0 ){
                                                $tabla2 = "Sin registros";
                                            }

                                            $tabla .= '<tr nobr="true">';
                                            $tabla .= '<td>'.$area_nombre.'</td>';
                                            $tabla .= '<td>$'.number_format($monto_inicio,2).'</td>';
                                            $tabla .= '<td>'.trim($tabla2).'</td>';
                                            $tabla .= '<td>$'.number_format($sumar_montos_tipoP,2).'</td>';
                                            $tabla .= '<td>$'.number_format(($monto_inicio+$sumar_montos_tipoP),2).'</td>';
                                            $tabla .= '</tr>';
                                        }
                                        echo trim($tabla);
                                    } else{
                                            echo '<tr nobr="true">
                                                        <th>Área</th>
                                                        <th>Acum. Mensual<br>Saldo inicial</th>
                                                        <th>Tipo de pago</th>
                                                        <th>Totales diarios</th>
                                                        <th>Acum. Mensual<br>Total acumulado</th>
                                                    </tr>
                                            <tr>
                                                <td colspan="5" style="text-align:center">Sin registros</td>
                                            </tr>';
                                }
                            ?>
                            </tbody>
                        </table>
                    </td>
                </tr>
            </table>    
        </td>
    </tr>
</table>
<?php } else{?>

<table class="tabla" align="center" cellpadding="0" border="0" style="margin-left:auto;margin-right:auto">
    <thead>
        <tr>
            <th><table border="1" width="100%">
                    <tbody>
                    <?php
                        if(count($facturas) != 0){
                            $area_temp = '-1';
                            $tipoP_temp = '-1';
                            $producto_temp = '-1';
                            $tabla = '';
                            $registros = 0;
                            foreach ($facturas as $key) {
                                $monto_inicio = 0;
                                $registros++;
                                //agrega el encabezado de la categoria
                                if($area_temp != $key['tia_nombre']){
                                    $area_temp = $key['tia_nombre'];
                                    $tabla .= '
                                            <tr>
                                                <th colspan="5">Categoría: '.$key['tia_codigo'].' - '.$area_temp.'</th>
                                            </tr>
                                            <tr nobr="true">
                                                <th>Área</th>
                                                <th>Acum. Mensual<br>Saldo inicial</th>
                                                <th>Tipo de pago</th>
                                                <th>Totales diarios</th>
                                                <th>Acum. Mensual<br>Total acumulado</th>
                                            </tr>
                                    ';
                                }
                                //iniciamos los arreglos
                                $tipoP_arreglo = array();
                                $monto_arreglo = array();
                                $contador_tips_pago = -1;
                                $monto_inicio = 0;
                                $pago_temp = '-1';
                                $prueba = "";
                                foreach ($tipos_pago as $key2) {
                                    if($key['art_id'] == $key2['art_id']){

                                        if($key['are_id'] == $key2['are_id']){
                                            //comparamos que la fecha sea difernte a la fecha de inicio que sera el dia 1 de mes
                                            if( formatear_fecha('d-m-Y', $key2['fac_fecha_fact']) != $fecha_ini){
                                                if($pago_temp != $key2['detalles_pago']){ //verificamos que el detalle solo se repita 1 vez
                                                    $pago_temp = $key2['detalles_pago'];
                                                    $contador_tips_pago++;
                                                    //inicializamos la posicion de los arreglos para que no nos arroje error
                                                    if(@count($tipoP_arreglo[$contador_tips_pago]) == 0){
                                                        $tipoP_arreglo[$contador_tips_pago] = "";
                                                    }
                                                    if(@count($monto_arreglo[$contador_tips_pago]) == 0){
                                                        $monto_arreglo[$contador_tips_pago] = 0;
                                                    }
                                                    //guardamos el primer elemento del tipo de pago en el arreglo
                                                    $tipoP_arreglo[$contador_tips_pago] = $pago_temp;
                                                }
                                                //se iran sumando todos los elementos de ese tipo de pago
                                                $monto_arreglo[$contador_tips_pago] += $key2['monto_total_producto'];
                                            } else{
                                                $monto_inicio += $key2['monto_total_producto'];
                                            }

                                        }
                                    }
                                }

                                $sumar_montos_tipoP = 0;
                                $tabla2 = '<table width="100%" cellspacing="0">';
                                for ($x=0; $x < count($tipoP_arreglo); $x++) { 
                                    $tabla2 .= '<tr style="border: inset 0pt">';
                                    $tabla2 .= '<td style="border: inset 0pt" width="50%">'.$tipoP_arreglo[$x].'</td>';
                                    $tabla2 .= '<td style="border: inset 0pt" width="50%">$'.number_format($monto_arreglo[$x],2).'</td>';
                                    $tabla2 .= '</tr>';
                                    $sumar_montos_tipoP += $monto_arreglo[$x];
                                }
                                $tabla2 .= "</table>";

                                $area_nombre = $key['are_nombre'];
                                if(trim($key['are_nombre']) == ""){
                                    $area_nombre = 'Sin área';
                                }

                                if( count($tipoP_arreglo) == 0 ){
                                    $tabla2 = "Sin registros";
                                }

                                $tabla .= '<tr nobr="true">';
                                $tabla .= '<td>'.$area_nombre.'</td>';
                                $tabla .= '<td>$'.number_format($monto_inicio,2).'</td>';
                                $tabla .= '<td>'.trim($tabla2).'</td>';
                                $tabla .= '<td>$'.number_format($sumar_montos_tipoP,2).'</td>';
                                $tabla .= '<td>$'.number_format(($monto_inicio+$sumar_montos_tipoP),2).'</td>';
                                $tabla .= '</tr>';
                            }
                            echo $tabla;
                        } else{
                            echo '<tr nobr="true">
                                                <th>Área</th>
                                                <th>Acum. Mensual<br>Saldo inicial</th>
                                                <th>Tipo de pago</th>
                                                <th>Totales diarios</th>
                                                <th>Acum. Mensual<br>Total acumulado</th>
                                            </tr>
                                    <tr>
                                        <td colspan="5" style="text-align:center">Sin registros</td>
                                    </tr>';
                        }
                    ?>
                    </tbody>
                </table>
            </th>
        </tr>
    </thead>
</table>

<?php }?>