<?php
header("Content-type: application/vnd.ms-excel; name='Reporte_historial_cajas'");
header("Content-Disposition: filename=Reporte_historial_cajas.xls");
header("Pragma: no-cache");
header("Expires: 0");
?>
<div class="title">
    <table>
        <tr>
            <td colspan="11" style="font-weight:bold; text-align:center"><h4>Reporte historial de cajas</h4></td>
        </tr>
        <tr>
            <td colspan="11" style="text-align: center;"><h5><?php echo (isset($subtl)) ? $subtl : ''; ?></h5></td>
        </tr>
    </table>
</div>
<table border="1">
    <thead>
        <tr>
            <th>N°</th>
            <th>Caja</th>
            <th>Área</th>
            <th>Tipo Documento</th>
            <th>N° Documento</th>
            <th>Doc. Afecta</th>
            <th>Cliente</th>    
            <th>Fecha de Documento</th>
            <th>Tipo de Pago</th>
            <th>Total</th>
            <th>Estado</th>    
            <th>Anticipo</th> 
        </tr>
    </thead>
    <tbody>
        <?php 
        $total_por_caja = $total_anticipo = $total_general = $total_gnal_antc = 0;
        $i = 0;
        if (count($cajas) > 0) {
            $caj_id = $cajas[0]['caj_id'];
            $caj_nom = $cajas[0]['caj_nombre'];
            foreach ($cajas as $k => $ca) {
                $i++;
                if ($ca['caj_id'] == $caj_id) {
                    $total_por_caja += $ca['fac_total'];
                    $total_anticipo += $ca['anticipo'];
                    ?>
                    <tr nobr="true">
                        <td><?php echo $i;?></td>
                        <td><?php echo $ca['caj_nombre']; ?></td>
                        <td><?php echo (isset($ca['arf_nombre']))?$ca['arf_nombre']:''; ?></td>
                        <td><?php echo $ca['tif_abreviacion']; ?></td>
                        <td><?php echo $ca['fac_numero']; ?></td>
                        <td><?php echo $ca['fac_padre']; ?></td>
                        <td><?php echo $ca['cliente']; ?></td>
                        <td><?php echo $ca['fecha']; ?></td>
                        <td><?php echo $ca['tpg_nombre'] ?></td>
                        <td style="text-align: right;"><?php echo number_format($ca['fac_total'], 2); ?></td>
                        <td><?php echo $ca['estado_actual']; ?></td>    
                        <td style="text-align: right;"><?php echo number_format($ca['anticipo'], 2); ?></td>
                    </tr>
                    <?php
                } else {
                    ?>
                    <tr nobr="true">
                        <td colspan="9" style="text-align:right;"><b><?php echo 'Total de ' . $caj_nom; ?></b></td>
                        <td style="text-align:right;"><b><?php echo '$'.number_format($total_por_caja, 2);?></b></td>
                        <td style="text-align:right;" colspan="1"><b>Total de anticipo</b></td>
                        <td style="text-align:right;"><b><?php echo '$'.number_format($total_anticipo,2); ?></b></td>
                    </tr>
                    <?php
                    $total_general += $total_por_caja;
                    $total_gnal_antc += $total_anticipo; 
                    $total_anticipo = 0;
                    $total_por_caja = 0;
                    $caj_id = $ca['caj_id'];
                    $caj_nom = $ca['caj_nombre'];
                    $total_por_caja += $ca['fac_total'];
                    $total_anticipo += $ca['anticipo'];
                    ?>
                    <tr nobr="true">
                        <td><?php echo $i;?></td>
                        <td><?php echo $ca['caj_nombre']; ?></td>
                        <td><?php echo (isset($ca['arf_nombre']))?$ca['arf_nombre']:''; ?></td>
                        <td><?php echo $ca['tif_abreviacion']; ?></td>
                        <td><?php echo $ca['fac_numero']; ?></td>
                        <td><?php echo $ca['fac_padre']; ?></td>
                        <td><?php echo $ca['cliente']; ?></td>
                        <td><?php echo $ca['fecha']; ?></td>
                        <td><?php echo $ca['tpg_nombre'] ?></td>
                        <td style="text-align: right;"><?php echo number_format($ca['fac_total'], 2); ?></td>
                        <td><?php echo $ca['estado_actual']; ?></td>    
                        <td style="text-align: right;"><?php echo number_format($ca['anticipo'], 2); ?></td>
                    </tr>
                    <?php
                } ?>
                <?php
            }
            ?>
            <tr nobr="true">
                <td colspan="9" style="text-align:right;"><b><?php echo 'Total de ' . $caj_nom; ?></b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($total_por_caja, 2);?></b></td>
                <td style="text-align:right;" colspan="1"><b>Total de anticipo</b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($total_anticipo,2); ?></b></td>
            </tr>
            <?php
            $total_general += $total_por_caja;
            $total_gnal_antc += $total_anticipo; 
        } else {
            ?>
            <tr>
                <td colspan="12" style="text-align:center;">No se encontraron registros</td>
            </tr>
            <?php
        } ?>  
    </tbody>
    <tfoot>
        <tr>
            <td colspan="9" style="text-align:right;"><b>Totales Generales</b></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($total_general,2);?></b></td>
            <td></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($total_gnal_antc,2);;?></b></td>
        </tr>
    </tfoot>
</table>