<?php
if($tipo_reporte == 'excel'){
    header("Content-Type: application/vnd.ms-excel");
    header("Expires: 0");
    header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
    header("content-disposition: attachment;filename=" . $filename . ".xls");
}
$tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
if($tipo_reporte != 'grid'){
    ?>
    <style type="text/css">
        .tabla
        {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        th
        {
            font-weight: bold !important;
        }
        td
        {
            font-family: arial;
        }
        .fuente_titulo{
            font-family: <?php echo $tipo_fuente; ?>;
        }
    </style>
    <?php if ($tipo_reporte == 'excel') { ?>
        <table>
            <thead>
                <tr>
                    <th colspan="5">Productos mas vendidos</th>
                </tr>
                <tr>
                    <th colspan="5">Los <?=$top?> productos mas vendidos por unidad entre el <?=formatear_fecha('d-m-Y',$fecha_ini)?> y <?=formatear_fecha('d-m-Y',$fecha_fin)?> son:</th>
                </tr>
            </thead>
        </table>
        <?php
    }
    if ($tipo_reporte=='pdf') { ?>
        <table>
            <tr>
                <td>Los <?=$top?> productos mas vendidos entre el <?=formatear_fecha('d-m-Y',$fecha_ini)?> y <?=formatear_fecha('d-m-Y',$fecha_fin)?> son:</td>
            </tr>
            <tr>
                <td></td>
            </tr>
        </table>
        <?php
    } ?>

    <table border="1" width="100%">
        <thead>
            <tr>
                <th>Codigo</th>
                <th>Nombre del Producto</th>
                <th>Marca</th>
                <th>Categoría</th>
                <th>Sucursal</th>
                <th>Bodega</th>
                <th>Cantidad</th>
                <th>Valor Facturado Promedio</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if(count($detalles)>0){
                foreach ($detalles as $key) { ?>
                    <tr>
                        <td><?=$key['art_codigo']?></td>
                        <td><?=$key['art_nombre']?></td>
                        <td><?=$key['mrp_nombre']?></td>
                        <td><?=$key['tia_nombre']?></td>
                        <td><?=$key['suc_nombre']?></td>
                        <td><?=$key['bod_nombre']?></td>
                        <td style="text-align: right;"><?=number_format($key['cant'],2,'.',',')?></td>
                        <td style="text-align: right;">$<?=number_format(($key['facturado']*$key['cant']),2,'.',',')?></td>
                    </tr>
                    <?php 
                }
            } ?>
        </tbody>
    </table>

    <?php
} else{
    ?>
    <!--Datos de la grid-->
    <div >
        <h4>Los <?=$top?> productos mas vendidos entre el <?=formatear_fecha('d-m-Y',$fecha_ini)?> y <?=formatear_fecha('d-m-Y',$fecha_fin)?> son: </h4>
    </div>
    <table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
        <thead>
            <tr>
                <th>Codigo</th>
                <th>Nombre del Producto</th>
                <th>Marca</th>
                <th>Categoría</th>
                <th>Sucursal</th>
                <th>Bodega</th>
                <th>Cantidad</th>
                <th>Valor Facturado Promedio</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if(count($detalles)>0){
                foreach ($detalles as $key) { ?>
                    <tr>
                        <td><?=$key['art_codigo']?></td>
                        <td><?=$key['art_nombre']?></td>
                        <td><?=$key['mrp_nombre']?></td>
                        <td><?=$key['tia_nombre']?></td>
                        <td><?=$key['suc_nombre']?></td>
                        <td><?=$key['bod_nombre']?></td>
                        <td style="text-align: right;"><?=number_format($key['cant'],2,'.',',')?></td>
                        <td style="text-align: right;">$<?=number_format(($key['facturado']*$key['cant']),2,'.',',')?></td>
                    </tr>
                    <?php 
                }
            } ?>
        </tbody>
    </table>
<?php }?>
