<?php 
    if($tipo_reporte == 'excel'){
        header("Content-Type: application/vnd.ms-excel");
        header("Expires: 0");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("content-disposition: attachment;filename=" . $filename . ".xls");
    }
    $tipo_fuente = $this->gsatelite->get_parametro("SYS_FUENTE_TITULO");
    if($tipo_reporte != 'grid'){
?>
<style type="text/css">
    .tabla
    {           
        width: 100%;
        margin-left: auto;
        margin-right: auto;
    }
    th
    {
        font-weight: bold !important;                  
    }
    td
    {   
        font-family: arial;             
    }    
    .fuente_titulo{
        font-family: <?php echo $tipo_fuente; ?>;
    }    
</style> 
    <?php if ($tipo_reporte == 'excel') {
        ?>
        <table>
            <thead>
                <tr>
                    <th colspan="11">Listado detallado compras por proyecto</th>
                </tr>
            </thead>
        </table>
        <?php
    } 
    ?>
<table border="1" width="100%">
    <thead>
        <tr>
            <th width="4%">No.</th>
            <th>No. fact.</th>
            <th>Cod. producto</th>
            <th>Nombre de producto</th>
            <th>Cantidad</th>
            <th>Precio Unitario</th>
            <th>Sub-total</th>
            <th>Descuentos</th>
            <th>Impuestos</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
    <?php  
        if(count($proyectos)>0){
            $num_pro =1;
            $registro = array();
            $cantidad = 0;
            $precio = 0;
            $subtotales = 0;
            $descuentos = 0;
            $impuestos = 0;
            $totales = 0;
        foreach ($proyectos as $key) {
            //$fecha = formatear_fecha('d-m-Y',$key['orc_fecha_orden']);
            $cantidad += (float)$key['cantidad'];
            $precio += $key['precio'];
            $subtotales += $key['subtotal'];
            $descuentos += $key['descuento'];
            $impuestos += $key['impuesto'];
            $totales += $key['total'];
        ?>
            <tr>
                <td width="4%"><?php echo $num_pro++; ?></td>
                <td><?=$key['fac_numero']?></td>
                <td><?=$key['art_codigo']?></td>
                <td><?=$key['art_nombre']?></td>
                <td><?=(float)$key['cantidad']?></td>
                <td><?=number_format($key['precio'], 2)?></td>
                <td><?=number_format($key['subtotal'], 2)?></td>
                <td><?=number_format($key['descuento'], 2)?></td>
                <td><?=number_format($key['impuesto'], 2)?></td>
                <td><?=number_format($key['total'], 2)?></td>
            </tr>
        <?php } ?>
            <tr>
                <td colspan="4" style="text-align: right;">Totales</td>
                <td><?=$cantidad?></td>
                <td><?=number_format($precio,2)?></td>
                <td><?=number_format($subtotales,2)?></td>
                <td><?=number_format($descuentos,2)?></td>
                <td><?=number_format($impuestos,2)?></td>
                <td><?=number_format($totales,2)?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
<?php 
    } else{ 
        
?>
<!--Datos de la grid-->
<table border="1" style="font-size:12.5px;color:black;" class="responsive table table-bordered contenedor" id="datagried" width="100%" name="datagried">
    <thead>
        <tr>
            <th>No.</th>
            <th>No. fact.</th>
            <th>Cod. producto</th>
            <th>Nombre de producto</th>
            <th>Cantidad</th>
            <th>Precio Unitario</th>
            <th>Sub-total</th>
            <th>Descuentos</th>
            <th>Impuestos</th>
            <th>Total</th>
        </tr>
    </thead>
    <tbody>
        <?php 
        if(count($proyectos)>0){
            $num_pro =1;
            $registro = array();
            $cantidad = 0;
            $precio = 0;
            $subtotales = 0;
            $descuentos = 0;
            $impuestos = 0;
            $totales = 0;
        foreach ($proyectos as $key) {
            //$fecha = formatear_fecha('d-m-Y',$key['orc_fecha_orden']);
            $cantidad += (float)$key['cantidad'];
            $precio += $key['precio'];
            $subtotales += $key['subtotal'];
            $descuentos += $key['descuento'];
            $impuestos += $key['impuesto'];
            $totales += $key['total'];
        ?>
            <tr>
                <td><?php echo $num_pro++; ?></td>
                <td><?=$key['fac_numero']?></td>
                <td><?=$key['art_codigo']?></td>
                <td><?=$key['art_nombre']?></td>
                <td><?=(float)$key['cantidad']?></td>
                <td><?=number_format($key['precio'], 2)?></td>
                <td><?=number_format($key['subtotal'], 2)?></td>
                <td><?=number_format($key['descuento'], 2)?></td>
                <td><?=number_format($key['impuesto'], 2)?></td>
                <td><?=number_format($key['total'], 2)?></td>
            </tr>
        <?php } ?>
            <tfoot>
                <td></td>
                <td></td>
                <td></td>
                <td>Totales</td>
                <td><?=$cantidad?></td>
                <td><?=number_format($precio,2)?></td>
                <td><?=number_format($subtotales,2)?></td>
                <td><?=number_format($descuentos,2)?></td>
                <td><?=number_format($impuestos,2)?></td>
                <td><?=number_format($totales,2)?></td>
            </tfoot>
        <?php } ?>
    </tbody>
</table>
<?php }?>