<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <style type="text/css">
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="3" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> 
                        <br />
                        Reporte de Ventas por Vendedor y Tipo de Pago
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php
}
$tpg = count($tipo_pago);
$haycmc = $this->gsatelite->count("cmc_cargo_alumnoxcurso", array("cmc_estado"=>1,"cmc_id_fac IS NOT NULL"=>null));
$info = ($haycmc > 0) ? 6 : 4;
$p = ($tipo_reporte == 'pdf') ? true : false;
$m = 60 / ($tpg + ($info - 2));
if($tipo_reporte != ''){ ?>
    <table border="0" width="100%">
        <tr>    
            <td><?php echo $fecha_desde_text;?></td>
            <td><?php echo $fecha_hasta_text;?></td>
        </tr>
    </table>
    <?php
}
?>
<table border="1" class=" table responsive table-bordered" <?= ($p) ? 'style="font-size: 7pt;"' : ''; ?> >
    <thead>
        <?php if (count($registros) > 0) { ?>
            <tr nobr="true" style="font-weight: bold;">
                <th colspan="<?= ($tpg + $info) ?>">Vendedor: <?php echo $registros[0]['ven_codigo'] . ' - ' . $registros[0]['nombre_vendedor']; ?></th>
            </tr>
        <?php } ?>
        <tr nobr="true" style="text-align: center; font-weight: bold;">                        
            <th <?= ($p) ? 'width="8%"' : ''; ?> >Código Cliente</th>
            <th <?= ($p) ? 'width="32%"' : ''; ?> >Nombre Cliente</th>
            <?php foreach ($tipo_pago as $kt => $vt) { ?>
                <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo ucfirst(strtolower($vt['tpg_nombre'])) ?></th>
            <?php } ?>
            <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Total</th>
            <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Porcentaje (%)</th>                  
            <?php if ($haycmc > 0) { ?>
                <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Saldo Pendiente Factura</th>
                <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Cuotas Pagadas</th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_ven = $gran_total = 0;
        $totales_tipos = array();
        if (count($registros) > 0) {
            $totales_vendedor = array();
            $vendedor = $registros[0]['ven_id'];
            $nombre_vendedor = $registros[0]['ven_codigo'] . ' - ' . $registros[0]['nombre_vendedor'];
            foreach ($registros as $kv => $val) {
                $where_total_ven = array(
                    'fac_estado > ' => 0,
                    'fac_id_ven' => $vendedor,
                    'DATE(fac_fecha_fact) >= ' => formatear_fecha('Y-m-d', $fecha_ini),
                    'DATE(fac_fecha_fact) <= ' => formatear_fecha('Y-m-d', $fecha_fin)
                );
                $total_ven = $this->gsatelite->get_suma('fac_factura', 'fac_subtotal', $where_total_ven);
                if ($val['ven_id'] == $vendedor) {
                    $total_fila = 0;
                    $tipos = explode('##', $val['ventas']);
                    $valores = array();
                    foreach ($tipos as $k1 => $v1) {
                        $a_temp = explode('||', $v1);
                        $valores[$a_temp[0]] += (isset($a_temp[2])) ? floatval($a_temp[2]) : 0;
                    }
                    ?>
                    <tr nobr="true">
                        <td <?= ($p) ? 'width="8%"' : ''; ?> ><?php echo $val['cli_codigo'] ?></td>
                        <td <?= ($p) ? 'width="32%"' : ''; ?> ><?php echo $val['nombre_cliente'] ?></td>
                        <?php foreach ($tipo_pago as $kt => $vt) {
                            if (array_key_exists($vt['tpg_id'], $valores) ) {
                                $total_fila += $valores[$vt['tpg_id']];
                                $totales_tipos[$vt['tpg_id']] += isset($valores[$vt['tpg_id']]) ? $valores[$vt['tpg_id']] : 0;
                                $totales_vendedor[$vt['tpg_id']] += isset($valores[$vt['tpg_id']]) ? $valores[$vt['tpg_id']] : 0;
                                $monto = number_format($valores[$vt['tpg_id']], 2);
                            } else {
                                $monto = number_format(0, 2);
                            }
                            ?>
                            <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo $monto ?></td>
                            <?php
                        }
                        $gran_total += $total_fila;
                        ?>
                        <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo number_format($total_fila, 2) ?></td>
                        <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo number_format((($total_fila / $total_ven) * 100), 2) ?></td>
                        <?php if ($haycmc > 0): ?>
                            <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo number_format($val['fac_monto_pendiente'], 2) ?></td>
                            <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> class="text" ><?php echo $val['cuotas_pagadas'] ?></td>
                        <?php endif ?>
                    </tr>
                    <?php
                } else {
                    ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <td style="text-align: right;" colspan="2">Total Vendedor: <?php echo $nombre_vendedor ?></td>
                                <?php foreach ($tipo_pago as $kt => $vt) { ?>
                                    <td style="text-align: right;"><?php echo number_format($totales_vendedor[$vt['tpg_id']], 2) ?></td>
                                <?php } ?>
                                <td style="text-align: right;"><?php echo number_format($total_ven, 2) ?></td>
                                <td></td>
                                <?php if ($haycmc > 0): ?>
                                    <td></td>
                                    <td></td>
                                <?php endif ?>
                            </tr>
                        </tfoot>
                    </table>
                    <?php
                    $totales_vendedor = array();
                    $vendedor = $val['ven_id'];
                    $nombre_vendedor = $val['ven_codigo'] . ' - ' . $val['nombre_vendedor'];
                    $where_total_ven = array(
                        'fac_estado > ' => 0,
                        'fac_id_ven' => $vendedor,
                        'DATE(fac_fecha_fact) >= ' => formatear_fecha('Y-m-d', $fecha_ini),
                        'DATE(fac_fecha_fact) <= ' => formatear_fecha('Y-m-d', $fecha_fin)
                    );
                    $total_ven = $this->gsatelite->get_suma('fac_factura', 'fac_subtotal', $where_total_ven);
                    echo  ($p) ? '<br><br>' : '<br>';
                    ?><table border="1" class=" table responsive table-bordered" <?= ($p) ? 'style="font-size: 7pt;"' : ''; ?> >
                        <thead>
                            <tr nobr="true" style="font-weight: bold;">
                                <th colspan="<?= ($tpg + 4) ?>">Vendedor: <?php echo $nombre_vendedor; ?></th>
                            </tr>
                            <tr nobr="true" style="text-align: center; font-weight: bold;">                        
                                <th <?= ($p) ? 'width="8%"' : ''; ?> >Código Cliente</th>
                                <th <?= ($p) ? 'width="32%"' : ''; ?> >Nombre Cliente</th>
                                <?php foreach ($tipo_pago as $kt => $vt) { ?>
                                    <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo ucfirst(strtolower($vt['tpg_nombre'])) ?></th>
                                <?php } ?>
                                <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Total</th>
                                <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Porcentaje (%)</th>                  
                                <?php if ($haycmc > 0) { ?>
                                    <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Saldo Pendiente</th>
                                    <th <?= ($p) ? 'width="'.$m.'%"' : ''; ?> >Cuotas Pagadas</th>
                                <?php } ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $total_fila = 0;
                            $tipos = explode('##', $val['ventas']);
                            $valores = array();
                            foreach ($tipos as $k1 => $v1) {
                                $a_temp = explode('||', $v1);
                                $valores[$a_temp[0]] += $a_temp[2];
                            }
                            ?>
                            <tr nobr="true">
                                <td <?= ($p) ? 'width="8%"' : ''; ?> ><?php echo $val['cli_codigo'] ?></td>
                                <td <?= ($p) ? 'width="32%"' : ''; ?> ><?php echo $val['nombre_cliente'] ?></td>
                                <?php foreach ($tipo_pago as $kt => $vt) {
                                    if (array_key_exists($vt['tpg_id'], $valores) ) {
                                        $total_fila += $valores[$vt['tpg_id']];
                                        $totales_tipos[$vt['tpg_id']] += $valores[$vt['tpg_id']];
                                        $totales_vendedor[$vt['tpg_id']] += $valores[$vt['tpg_id']];
                                        $monto = number_format($valores[$vt['tpg_id']], 2);
                                    } else {
                                        $monto = number_format(0, 2);
                                    }
                                    ?>
                                    <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo $monto ?></td>
                                    <?php
                                }
                                $gran_total += $total_fila;
                                ?>
                                <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo number_format($total_fila, 2) ?></td>
                                <td style="text-align: right;" <?= ($p) ? 'width="'.$m.'%"' : ''; ?> ><?php echo number_format((($total_fila / $total_ven) * 100), 2) ?>
                                <?php if ($haycmc > 0): ?>
                                    <td style="text-align: right;" <?= ($p)? 'width="'.$m.'%"': '';?> ><?php echo number_format($val['fac_monto_pendiente'], 2); ?></td>
                                    <td style="text-align: right;" <?= ($p)? 'width="'.$m.'%"': '';?> ><?php echo $val['cuotas_pagadas'] ?></td>
                                <?php endif ?>
                            </tr>
                    <?php
                }
            }
        } else {
            ?>
            <tr>
                <td style="text-align: center; font-weight: bold;" colspan="<?= ($tpg + 4) ?>">No se encontraron registros</td>
            </tr>
            <?php
        }
        ?>
    </tbody>
    <?php if (count($registros) > 0) { ?>
        <tfoot>
            <tr>
                <td style="text-align: right;" colspan="2">Total Vendedor: <?php echo $nombre_vendedor ?></td>
                <?php
                foreach ($tipo_pago as $kt => $vt) { ?>
                    <td style="text-align: right;"><?php echo number_format($totales_vendedor[$vt['tpg_id']], 2) ?></td>
                <?php } ?>
                <td style="text-align: right;"><?php echo number_format($total_ven, 2) ?></td>
                <td></td>
                <td></td><td></td>
            </tr>
            <tr><td colspan="<?= ($tpg + $info) ?>"></td></tr>
            <tr style="border-top: solid black;">
                <th style="text-align: right; font-weight: bold;" colspan="2">Total General</th>
                <?php
                foreach ($tipo_pago as $kt => $vt) { ?>
                    <th style="text-align: right; font-weight: bold;"><?php echo number_format($totales_tipos[$vt['tpg_id']], 2) ?></th>
                <?php } ?>
                <th style="text-align: right; font-weight: bold;"><?php echo number_format($gran_total, 2) ?></th>
                <th></th>
                <?php if ($haycmc > 0): ?>
                    <th></th>
                    <th></th>
                <?php endif ?>
            </tr>    
        </tfoot>
    <?php } ?>
</table>
