<?php

/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>

<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de ventas por sucursal detallado
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if($tipo_reporte == 'pdf'):?>
<style type="text/css">
td { font-family: courier; font-size: 9px; }
</style>
<?php endif;?>

<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'):?>
<table border="0" width="100%">
  <tr>    
    <td><?php echo $fecha_desde_text;?></td>
    <td><?php echo $fecha_hasta_text;?></td>
    <td><?php echo $sucursal_text;?></td>
  </tr>
</table>
<?php endif;?>
<?php
    $total_subtotal = 0;
    $total_descuento = 0;    
    $total_iva = 0;
    $total_percepcion = 0;
    $total_retencion = 0;
    $total_total = 0;
?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered"  aria-describedby="table_2_info">
  <thead >
    <tr nobr="true" >                        
      <th width="7%">Código</th>
      <th width="7%">Fecha</th>
      <th width="7%">Pago</th>
      <th width="7%">Vence</th>
      <th width="16%">Cliente</th>
      <th width="9%">Vendedor</th>
      <th width="12%">Aplica en</th>
      <th width="7%">Subtotal</th>      
      <th width="7%">Descuento</th>      
      <th width="7%">Iva</th>      
      <!-- <th width="7%">Perc(+)</th>       -->
      <th width="7%">Ret(-)</th>     
      <th width="7%">Total</th>     
      <!-- <th width="10%">ESTADO</th>  -->     
    </tr>
  </thead>
  <tbody>
    <?php if(count($reporte) > 0){?>
      <?php foreach ($reporte as $key => $rep) { ?>
        <tr nobr="true">                          
            <td width="7%"><?php echo $rep['codigo']?></td>
            <td width="7%"><?php echo $rep['fecha'];?></td>
            <td width="7%"><?php echo $rep['tipo_pago'];?></td>
            <td width="7%"><?php echo $rep['fecha_vencimiento'];?></td>                        
            <td width="16%"><?php echo $rep['cliente'];?></td>                        
            <td width="9%"><?php echo $rep['vendedor'];?></td>                                                
            <td width="12%"><?php echo $rep['aplicaen']?></td>
            <td width="7%"><?php echo number_format($rep['sub_total'],2)?></td>    
            <td width="7%"><?php echo number_format($rep['descuento'],2)?></td>    
            <td width="7%"><?php echo number_format($rep['iva'],2)?></td>    
            <!-- <td width="7%"><?php //echo number_format($rep['percepcion'],2)?></td>     -->
            <td width="7%"><?php echo number_format($rep['retencion'],2)?></td>    
            <td width="7%"><?php echo number_format($rep['total'],2)?></td>
        </tr>
        <?php
          //Totalizando valores por columna
          $total_subtotal += $rep['sub_total'];
          $total_descuento += $rep['descuento'];
          $total_iva += $rep['iva'];

          $total_percepcion += $rep['percepcion'];
          $total_retencion += $rep['retencion'];
          $total_total += $rep['total'];
        ?>
      <?php }?>
        <tfoot>
          <tr>
            <td colspan="7" align="center"><strong>TOTAL</strong></td>
            <td width="7%"><strong><?php echo number_format($total_subtotal,2)?></strong></td>                    
            <td width="7%"><strong><?php echo number_format($total_descuento,2)?></strong></td>   
            <td width="7%"><strong><?php echo number_format($total_iva,2)?></strong></td>   
            <!-- <td width="7%"><strong><?php //echo number_format($total_percepcion,2)?></strong></td>    -->
            <td width="7%"><strong><?php echo number_format($total_retencion,2)?></strong></td>   
            <td width="7%"><strong><?php echo number_format($total_total,2)?></strong></td>   
          </tr>
        <tfoot>
        <?php //if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>
          <!-- <tr> -->
            <!-- <td colspan="5"></td> -->
            <!-- <td width="8%"></td>
            <td width="8%"></td>
            <td width="8%"></td>
            <td width="12%"></td> -->
            <!-- <td colspan="7" align="center"><strong>TOTAL</strong></td>
            <td width="7%"><strong><?php //echo number_format($total_subtotal,2)?></strong></td>                    
            <td width="7%"><strong><?php //echo number_format($total_descuento,2)?></strong></td>   
            <td width="7%"><strong><?php //echo number_format($total_iva,2)?></strong></td>   
            <td width="7%"><strong><?php //echo number_format($total_percepcion,2)?></strong></td>   
            <td width="7%"><strong><?php //echo number_format($total_retencion,2)?></strong></td>   
            <td width="7%"><strong><?php //echo number_format($total_total,2)?></strong></td>   
          </tr> -->
        <?php //}?>
    <?php }else{?>
      <?php if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>
        <tr nobr="true">
          <td colspan="13" align="center">No se encontraron registros</td>
        </tr>
      <?php }?>
    <?php }?>
  </tbody> 
</table>