<?php

/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>

<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de ventas por sucursal
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if($tipo_reporte == 'pdf'):?>
<style type="text/css">
td { font-family: courier; font-size: 9px; }
</style>
<?php endif;?>

<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'):?>
<table border="0" width="100%">
  <tr>    
    <td><?php echo $fecha_desde_text;?></td>
    <td><?php echo $fecha_hasta_text;?></td>
    <td><?php echo $sucursal_text;?></td>
  </tr>
</table>
<?php endif;?>
<?php
    $total_venta = 0;
    $total_nota_credito = 0;
    $total_descuento = 0;
    $total_venta_neta = 0;
    $total_iva = 0;
    $total_impuesto = 0;
    $total_retenciones = 0;
    $total_venta_con_impuesto = 0;
?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered"  aria-describedby="table_2_info">
  <thead >
    <tr nobr="true" >                        
      <th width="15%">Sucursal</th>
      <th width="10%">Subtotal Venta</th>
      <th width="10%">Nota de Crédito</th>
      <th width="10%">Descuentos</th>
      <th width="10%">Venta neta</th>
      <th width="10%">Iva</th>
      <th width="10%">Otros impuestos</th>
      <th width="10%">Retenciones</th> 
      <th width="15%">Venta con impuestos</th>      
    </tr>
  </thead>
  <tbody>
    <?php if(count($reporte) > 0){?>
      <?php foreach ($reporte as $key => $rep) { ?>
        <tr nobr="true">                          
            <td width="15%"><?php echo $rep['sucursal']?></td>
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['venta'],2);?></td>
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['nota_credito'],2)?></td>
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['descuento'],2)?></td>
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['venta_neta'],2)?></td>
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['iva'],2)?></td>         
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['impuesto'],2)?></td>
            <td width="10%" style="text-align: right;">$<?php echo number_format($rep['retencion'],2);?></td>
            <td width="15%" style="text-align: right;">$<?php echo number_format($rep['venta_con_impuesto'],2)?></td>    
        </tr>
        <?php
          //Totalizando valores por columna
          $total_venta += $rep['venta'];
          $total_nota_credito += $rep['nota_credito'];
          $total_descuento += $rep['descuento'];
          $total_venta_neta += $rep['venta_neta'];
          $total_iva += $rep['iva'];
          $total_impuesto += $rep['impuesto'];
          $total_retenciones += $rep['retencion'];
          $total_venta_con_impuesto += number_format($rep['venta_con_impuesto'],2,'.','');
        ?>
      <?php }?>
        <tr>
          <td width="15%" style="text-align: right;"><strong>TOTAL</strong></td>
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_venta,2);?></strong></td>
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_nota_credito,2)?></strong></td>
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_descuento,2)?></strong></td>
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_venta_neta,2)?></strong></td>
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_iva,2)?></strong></td>    
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_impuesto,2)?></strong></td>
          <td width="10%" style="text-align: right;"><strong>$<?php echo number_format($total_retenciones,2)?></strong></td>
          <td width="15%" style="text-align: right;"><strong>$<?php echo number_format($total_venta_con_impuesto,2)?></strong></td>   
        </tr>
    <?php }else{?>
      <?php if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>
        <tr nobr="true">
          <td colspan="7" align="center">No se encontraron registros</td>
        </tr>
      <?php }?>
    <?php }?>
  </tbody> 
</table>