<?php
/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>

<?php
if ($tipo_reporte == 'excel') {//Headers para exportar a excel
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>


<?php if ($tipo_reporte == 'excel') { //Datos del encabezado en excel?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="3" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> 
                        <br />
                        Reporte de procentaje de participacion de ventas por cliente
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>


<?php if($tipo_reporte == 'pdf'):?>
    <style type="text/css">td { font-family: courier; font-size: 10px; }</style>
<?php endif;?>


<?php if($tipo_reporte == ""):?>
    <style type="text/css"> .blanco { color: white !important;}</style>
<?php endif;?>


<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'): //Datos de los filtros para los reportes?>
    <table border="0" width="100%">
        <tr>    
            <td><?php echo $fecha_desde_text;?></td>
            <td><?php echo $fecha_hasta_text;?></td>
            <td><?php echo $cliente_text;?></td>
        </tr>
        <?php if (!$por_vend) { //Si no hay que filtrar por vendedor?>
        <tr>
            <td><b>Vendedor:</b> <?= $reporte[0]['nombre_vendedor'] ?></td>
        </tr>
        <?php } ?>
        
    </table>
<?php endif;?>


<?php 
if ($por_vend) {  
    $n_reg =  count($reporte);
    $total_tabla = array();
    $total_gnal = 0;
    
    if ($n_reg > 0) { 
        $vend = $reporte[0]['ven_id']; 
        $vend_nom = $reporte[0]['nombre_vendedor']; 
        ?>

        <table border="1px" class="responsive display table-bordered" >
            <thead >
                <!-- <tr nobr="true" class="blanco">
                <td colspan="3"><b>Vendedor: </b><?php echo $vend_nom; ?></td>
                </tr> -->
                <tr nobr="true" style="text-align: center; font-weight: bold;" class="blanco">                        
                    <th width="30%">Vendedor</th>
                    <th width="30%">Cliente</th>
                    <th width="20%">Venta Neta</th>
                    <th width="20%">Participación(%)</th>                  
                </tr>
            </thead>
            <tbody>
                <?php 
                foreach ($reporte as $key => $value) { 
                    if ($value['ven_id']==$vend) { 
                        ?>
                        <tr nobr="true">
                            <td width="30%"><?php echo $vend_nom?></td>
                            <td width="30%"><?php echo $value['nombre_cliente']?></td>
                            <td width="20%" style="text-align: right;">$<?php echo number_format($value['subtotal'],2);?></td>
                            <td width="20%" style="text-align: right;"><?php echo number_format(abs(($value['subtotal']/$total)*100),4);?>%</td>
                        </tr>  
                        <?php  
                    } else { 
                        $vend = $value['ven_id'];
                        $vend_nom = $value['nombre_vendedor'];
                        ?>
                        <!-- </tbody><?php //prueba ?>
                        </table><table border="1px" class="responsive display table-bordered" >
                        <thead> -->
                        <!-- <tr class="blanco">
                        <td colspan="3"><b>Vendedor: </b><?php echo $vend_nom; ?></td>                
                        </tr> -->
                        <!-- <tr nobr="true" style="text-align: center; font-weight: bold;" class="blanco">                        
                            <th width="30%">Vendedor</th>
                            <th width="30%">Cliente</th>
                            <th width="20%">Venta Neta</th>
                            <th width="20%">Participación(%)</th>            
                        </tr> -->
                    <!-- </thead><?php //prueba ?>
                    <tbody> -->
                        <tr nobr="true">
                            <td width="30%"><?php echo $vend_nom?></td>
                            <td width="30%"><?php echo $value['nombre_cliente']?></td>
                            <td width="20%" style="text-align: right;">$<?php echo number_format($value['subtotal'],2);?></td>
                            <td width="20%" style="text-align: right;"><?php echo number_format(($value['subtotal']/$total)*100,4);?>%</td>
                        </tr>
                        <?php 
                    }//else
                }//foreach  ?> 
                    </tbody>
                </table><table class="responsive display table-bordered" border="1">
                    <tr style="text-align: right;">
                        <td width="30%"></td>
                        <td width="30%" align="center"><strong>TOTAL GENERAL</strong></td>
                        <td width="20%"><strong>$<?php echo number_format($total,2)?></strong></td>                    
                        <td width="20%"><strong>100%</strong></td>               
                    </tr>
                </table>
                <?php 

            } else { //$por_vend & n_reg = 0?>
                <table border="1px" class="responsive display  table-bordered">
                    <thead>
                        <tr nobr="true" style="text-align: center; font-weight: bold;" class="blanco" >                           
                            <th width="40%">Cliente</th>
                            <th width="30%">Venta Neta</th>
                            <th width="30%">Participación(%)</th>                  
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td colspan="3" align="center" >No se encontraron registros</td>
                        </tr>
                    </tbody>
            <?php } ?>

        <?php } else { ?>    
            <table border="1px" id="tblListado" class=" responsive display table table-bordered"  aria-describedby="table_2_info">
                <thead >
                    <tr nobr="true" style="text-align: center; font-weight: bold;">                        
                        <th width="40%">Cliente</th>
                        <th width="30%">Venta Neta</th>
                        <th width="30%">Participación(%)</th>                  
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($reporte) > 0){?>
                        <?php foreach ($reporte as $key => $rep) { ?>
                            <tr nobr="true">                          
                                <td width="40%"><?php echo $rep['nombre_cliente']?></td>
                                <td width="30%" style="text-align: right;">$<?php echo number_format($rep['subtotal'],2);?></td>
                                <td width="30%" style="text-align: right;"><?php echo number_format(abs(($rep['subtotal']/$total)*100),4);?>%</td>
                            </tr>        
                        <?php }?>
                        <!--<?php //if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>-->
                        <tr style="text-align: right;">            
                            <td width="40%" align="center"><strong>TOTAL</strong></td>
                            <td width="30%"><strong>$<?php echo number_format($total,2)?></strong></td>                    
                            <td width="30%"><strong>100%</strong></td>               
                        </tr>
                        <!--<?php //}?>-->
                    <?php }else{?>  
                        <?php if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>    
                            <tr nobr="true">
                                <td colspan="3" align="center">No se encontraron registros</td>
                            </tr>
                        <?php }?>
                    <?php }?>
                </tbody> 
            </table>
        <?php } ?>
