<?php
$p = ($tipo_rep == 'pdf') ? true : false;
if ($tipo_rep == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de Notas de Remisión no facturadas
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php }
if($tipo_rep == 'pdf' || $tipo_rep == 'excel'){
    ?>
    <table border="0" width="100%">
        <tr>    
            <td colspan="2">Desde <?php echo formatear_fecha('d-m-Y', $fecha_ini); ?></td>
            <td colspan="2">Hasta <?php echo formatear_fecha('d-m-Y', $fecha_fin); ?></td>
        </tr>
    </table>
    <br><br><?php 
} 
?>
<table border="0" id="tblListado" class="dynamicTable responsive display table table-bordered" width="100%">
    <?php if (count($registros) > 0) {
        $cliente = $registros[0]['fac_id_cli'];
        $factura = $registros[0]['def_id_fac'];
        ?>
        <thead>
            <tr>
                <th colspan="4">Cliente: <span><?php echo $registros[0]['cli_nombre']; ?></span></th>
            </tr>
            <tr nobr="true">
                <th <?= ($p) ? 'width="55%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Artículo</b></th>
                <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Cantidad</b></th>
                <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Unidad Medida</b></th>
                <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Bodega</b></th>
            </tr>
        </thead>
        <tbody>
            <tr nobr="true">
                <td width="55%"><b>Documento:</b>
                    <span><?php echo $registros[0]['fac_serie'] . ' - ' . $registros[0]['fac_numero']; ?> (Fecha: <?php echo formatear_fecha('d-m-Y', $registros[0]['fac_fecha_fact']); ?>)</span>
                </td>
                <td colspan="3" width="45%"></td>
            </tr>
            <?php
            foreach ($registros as $key => $var) {
                if ($var['fac_id_cli'] == $cliente) {
                    if ($var['def_id_fac'] == $factura) {
                        ?>
                        <tr nobr="true">
                            <td <?= ($p) ? 'width="55%"' : ''; ?>><?php echo $var['art_codigo']  . ' - ' . $var['art_nombre']; ?></td>
                            <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo number_format($var['def_cantidad'], 2); ?></td>
                            <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo $var['uni_medida']; ?></td>
                            <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo $var['bodega']; ?></td>
                        </tr>                        
                        <?php
                    } else {
                        ?>
                        <tr nobr="true">
                            <td style="border-top: solid 1px black;" width="55%"><b>Documento:</b>
                                <span><?php echo $var['fac_serie'] . ' - ' . $var['fac_numero']; ?> (Fecha: <?php echo formatear_fecha('d-m-Y', $var['fac_fecha_fact']); ?>)</span>
                            </td>
                            <td colspan="3" style="border-top: solid 1px black;" width="45%"></td>
                        </tr>
                        <tr nobr="true">
                            <td <?= ($p) ? 'width="55%"' : ''; ?>><?php echo $var['art_codigo']  . ' - ' . $var['art_nombre']; ?></td>
                            <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo number_format($var['def_cantidad'], 2); ?></td>
                            <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo $var['uni_medida']; ?></td>
                            <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo $var['bodega']; ?></td>
                        </tr>
                        <?php
                        $factura = $var['def_id_fac'];
                    }                    
                } else {
                    ?>
                        </tbody>
                    </table>
                    <?php echo ($tipo_rep == 'pdf') ? '<div class="clear"><hr></div>' : '<br>'; ?>
                    <table border="0" id="tblListado" class="dynamicTable responsive display table table-bordered" width="100%">
                        <thead>
                            <tr>
                                <th colspan="4">Cliente: <span><?php echo $var['cli_nombre']; ?></span></th>
                            </tr>
                            <tr nobr="true">
                                <th <?= ($p) ? 'width="55%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Artículo</b></th>
                                <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Cantidad</b></th>
                                <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Unidad Medida</b></th>
                                <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Bodega</b></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr nobr="true">
                                <td width="55%"><b>Documento:</b>
                                    <span><?php echo $var['fac_serie'] . ' - ' . $var['fac_numero']; ?> (Fecha: <?php echo formatear_fecha('d-m-Y', $var['fac_fecha_fact']); ?>)</span>
                                </td>
                                <td colspan="3" width="45%"></td>
                            </tr>
                            <tr nobr="true">
                                <td <?= ($p) ? 'width="55%"' : ''; ?>><?php echo $var['art_codigo']  . ' - ' . $var['art_nombre']; ?></td>
                                <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo number_format($var['def_cantidad'], 2); ?></td>
                                <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo $var['uni_medida']; ?></td>
                                <td <?= ($p) ? 'width="15%"' : ''; ?>><?php echo $var['bodega']; ?></td>
                            </tr>
                        <?php
                    $factura = $var['def_id_fac'];
                    $cliente = $var['fac_id_cli'];
                }
            }
            ?>
        </tbody>
        <?php
    } else {
        ?>
        <tr><th colspan="4" style="text-align: center;"><b>No se encontraron registros</b></th></tr>
        <?php
    }
    ?>
</table>
