<?php
$p = ($tipo_rep == 'pdf') ? true : false;
if ($tipo_rep == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de Notas de Remisión
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php }
if($tipo_rep == 'pdf' || $tipo_rep == 'excel'){
    ?>
    <table border="0" width="100%">
        <tr>    
            <td colspan="2">Desde <?php echo formatear_fecha('d-m-Y', $fecha_ini); ?></td>
            <td colspan="2">Hasta <?php echo formatear_fecha('d-m-Y', $fecha_fin); ?></td>
        </tr>
    </table>
    <br><br><?php 
} 
?>
<table border="0" id="tblListado" class="dynamicTable responsive table table-bordered" width="100%">
    <?php if (count($registros) > 0) {
        $cliente = $registros[0]['fac_id_cli'];
        $factura = $registros[0]['def_id_fac'];
        ?>
        <thead>
            <tr>
                <th colspan="6">Cliente: <span><?php echo $registros[0]['cli_nombre']; ?></span></th>
            </tr>
            <tr nobr="true">
                <th <?= ($p) ? 'width="40%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Artículo</b></th>
                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Solicitado</b></th>
                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Despachado</b></th>
                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Pendiente</b></th>
                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Un. Medida</b></th>
                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Bodega</b></th>
            </tr>
        </thead>
        <tbody>
            <tr nobr="true">
                <td colspan="2" width="52%"><b>Documento Generador:</b>
                    <span><?php echo $registros[0]['factura_padre']; ?></span>
                </td>
                <td colspan="4" width="48%"><b><?= ($versions > 0) ? 'Remisión:' : ''; ?></b>
                    <span><?php echo ($versions > 0) ? $registros[0]['fac_serie'] . ' - ' . $registros[0]['fac_numero'] : ''; ?>
                    <?php echo ($versions > 0) ? '(Fecha: ' . formatear_fecha('d-m-Y', $registros[0]['fac_fecha_fact']) . ')' : ''; ?></span>
                </td>
            </tr>
            <?php
            foreach ($registros as $key => $var) {
                $despachado = ($versions > 0) ? $var['def_cantidad'] : $var['def_cantidad_sumada'];
                $pendientes = ($versions > 0) ? $var['def_cantidad_faltante'] : $var['faltante_calculado'];
                if ($var['fac_id_cli'] == $cliente) {
                    if ($var['def_id_fac'] == $factura) {
                        ?>
                        <tr nobr="true">
                            <td <?= ($p) ? 'width="40%"' : ''; ?>><?php echo $var['art_codigo']  . ' - ' . $var['art_nombre']; ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($var['solicitado'], 2); ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($despachado, 2); ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($pendientes, 2); ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?>><?php echo $var['uni_medida']; ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?>><?php echo $var['bodega']; ?></td>
                        </tr>                        
                        <?php
                    } else {
                        ?>
                        <tr nobr="true">
                            <td colspan="2" style="border-top: solid 1px black;" width="52%"><b>Documento Generador:</b>
                                <span><?php echo $var['factura_padre']; ?></span>
                            </td>
                            <td colspan="4" style="border-top: solid 1px black;" width="48%"><b><?= ($versions > 0) ? 'Remisión:' : ''; ?></b>
                                <span><?php echo ($versions > 0) ? $var['fac_serie'] . ' - ' . $var['fac_numero'] : ''; ?>
                                <?php echo ($versions > 0) ? '(Fecha: ' . formatear_fecha('d-m-Y', $var['fac_fecha_fact']) . ')' : ''; ?></span>
                            </td>
                        </tr>
                        <tr nobr="true">
                            <td <?= ($p) ? 'width="40%"' : ''; ?>><?php echo $var['art_codigo']  . ' - ' . $var['art_nombre']; ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($var['solicitado'], 2); ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($despachado, 2); ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($pendientes, 2); ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?>><?php echo $var['uni_medida']; ?></td>
                            <td <?= ($p) ? 'width="12%"' : ''; ?>><?php echo $var['bodega']; ?></td>
                        </tr>
                        <?php
                        $factura = $var['def_id_fac'];
                    }                    
                } else {
                    ?>
                        </tbody>
                    </table>
                    <?php echo ($tipo_rep == 'pdf') ? '<div class="clear"><hr></div>' : '<br>'; ?>
                    <table border="0" id="tblListado" class="dynamicTable responsive table table-bordered" width="100%">
                        <thead>
                            <tr>
                                <th colspan="6">Cliente: <span><?php echo $var['cli_nombre']; ?></span></th>
                            </tr>
                            <tr nobr="true">
                                <th <?= ($p) ? 'width="40%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Artículo</b></th>
                                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Solicitado</b></th>
                                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Despachado</b></th>
                                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Pendiente</b></th>
                                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Un. Medida</b></th>
                                <th <?= ($p) ? 'width="12%"' : ''; ?> style="border-bottom: solid 1px black;"><b>Bodega</b></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr nobr="true">
                                <td colspan="2" width="52%"><b>Documento Generador:</b>
                                    <span><?php echo $var['factura_padre']; ?></span>
                                </td>
                                <td colspan="4" width="48%"><b><?= ($versions > 0) ? 'Remisión:' : ''; ?></b>
                                    <span><?php echo ($versions > 0) ? $var['fac_serie'] . ' - ' . $var['fac_numero'] : ''; ?>
                                    <?php echo ($versions > 0) ? '(Fecha: ' . formatear_fecha('d-m-Y', $var['fac_fecha_fact']) . ')' : ''; ?></span>
                                </td>
                            </tr>
                            <tr nobr="true">
                                <td <?= ($p) ? 'width="40%"' : ''; ?>><?php echo $var['art_codigo']  . ' - ' . $var['art_nombre']; ?></td>
                                <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($var['solicitado'], 2); ?></td>
                                <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($despachado, 2); ?></td>
                                <td <?= ($p) ? 'width="12%"' : ''; ?> style="text-align: right;"><?php echo number_format($pendientes, 2); ?></td>
                                <td <?= ($p) ? 'width="12%"' : ''; ?>><?php echo $var['uni_medida']; ?></td>
                                <td <?= ($p) ? 'width="12%"' : ''; ?>><?php echo $var['bodega']; ?></td>
                            </tr>
                        <?php
                    $factura = $var['def_id_fac'];
                    $cliente = $var['fac_id_cli'];
                }
            }
            ?>
        </tbody>
        <?php
    } else {
        ?>
        <tr><th colspan="6" style="text-align: center;"><b>No se encontraron registros</b></th></tr>
        <?php
    }
    ?>
</table>
