<?php 
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}    
$total_facturado = 0;
$total_abonado	 = 0;
$por_cobrar	 	 = 0;
$total_pendiente = 0;
?>
<style>
    .encabezado {
      text-align:left;
      font-weight: bold;
    }
    th{
        border: solid 1px silver;
        background-color: #DCDCDC;
        font-weight: bold;
        text-align:center;
    }
</style>
<?php if($tipo_reporte == 'pdf') { ?>
    <table border="0" width="100%" style="font-size: 8px;">
    <tr>
    	<td width="50%"><?php echo $caja_text; ?></td>
        <td width="25%" style="text-align: right;"><?php echo $fecha_desde_text; ?></td>    
        <td width="25%" style="text-align: right;"><?php echo $fecha_hasta_text; ?></td>    
    </tr>
</table>
<?php } else if ($tipo_reporte == 'excel') { ?>
<meta charset="utf-8" />
<table border="0" width="100%"> 
	<tr>
		<td align="center" colspan="4" >
			<h4><?php echo $titulo."<br/>"; ?></h4>
		</td>
	</tr> 
	<tr>
		<td colspan="2"><?php echo $caja_text; ?></td>
		<td style="text-align: right;"><?php echo $fecha_desde_text; ?></td>    
		<td style="text-align: right;"><?php echo $fecha_hasta_text; ?></td>    
        
    </tr>
</table>
<?php } ?>

<table border="0" cellpadding="2" <?php echo ($tipo_reporte == 'pdf')? 'style="font-size: 8px;"':'style="font-size: 12px;"'; ?> id="tblListado" class="dynamicTable responsive table table-bordered" >
    <thead>
        <tr>
            <th width="40%">CAJA</th>
            <th width="20%">FACTURADO</th>                       
            <th width="20%">ABONADO</th>                                    
            <th width="20%">POR COBRAR</th>                          
        </tr>
    </thead>
    <tbody>
	<?php
	if(count($reporte) > 0){
    	foreach ($reporte as $key => $value) {
    		$row_facturado = number_format($value['fac_total_fac'],2,'.','');
    		$row_abonado = number_format($value['abf_monto'],2,'.','');
            $total_facturado += number_format($value['fac_total_fac'],2,'.','');
            $total_abonado += number_format($value['abf_monto'],2,'.','');
            $por_cobrar = $row_facturado - $row_abonado;
            $total_pendiente += $por_cobrar;
            ?>
            <tr nobr="true">                          
                <td width="40%"><?php echo $value['caj_nombre']; ?></td>
                <td width="20%" style="text-align: right;">$<?php echo number_format($value['fac_total_fac'], 2); ?></td>
                <td width="20%" style="text-align: right;">$<?php echo number_format($value['abf_monto'], 2); ?></td>
                <td width="20%" style="text-align: right;">$<?php echo number_format($por_cobrar,2); ?></td>
            </tr>
            <?php 
        } 
    } else {
	?>
        <tr nobr="true">
            <td colspan="4" style="text-align: center;"><b>NO SE ENCONTRARON REGISTROS</b></td>
        </tr>
	<?php } ?>  
	</tbody>
<?php if (count($reporte) > 0): ?>
	<tfoot>
		<tr>
		<?php if ($tipo_reporte != ''): ?>
			<td width="40%" style="text-align: right;font-weight: bold;border-top: solid 1px silver;">TOTALES</td>
			<td width="20%" style="text-align: right;font-weight: bold;border-top: solid 1px silver;"><?php echo '$' . number_format($total_facturado,2); ?></td>
			<td width="20%" style="text-align: right;font-weight: bold;border-top: solid 1px silver;"><?php echo '$' . number_format($total_abonado,2); ?></td>
			<td width="20%" style="text-align: right;font-weight: bold;border-top: solid 1px silver;"><?php echo '$' . number_format($total_pendiente,2); ?></td>	
		<?php else: ?>
			<td width="40%" style="text-align: right;font-weight: bold;">TOTALES</td>
			<td width="20%" style="text-align: right;font-weight: bold;"><?php echo '$' . number_format($total_facturado,2); ?></td>
			<td width="20%" style="text-align: right;font-weight: bold;"><?php echo '$' . number_format($total_abonado,2); ?></td>
			<td width="20%" style="text-align: right;font-weight: bold;"><?php echo '$' . number_format($total_pendiente,2); ?></td>		
		<?php endif ?>
		</tr>  
	</tfoot> 
<?php endif ?>
</table>
