<?php
$p = ($tipo_rep == 'pdf') ? true : false;
if ($tipo_rep == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de Comprobantes de Retencion pendientes de aplicar
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php }
if($tipo_rep == 'pdf' || $tipo_rep == 'excel'){
    if ($fecha_ini != "" || $fecha_fin != "") {
        ?>
        <table border="0" width="100%">
            <tr>    
                <td colspan="2" <?= ($p) ? 'width="20%"' : ''; ?>><?php echo ($fecha_ini != "") ? 'Desde: ' . formatear_fecha('d-m-Y', $fecha_ini) : ''; ?></td>
                <td colspan="2" <?= ($p) ? 'width="20%"' : ''; ?>><?php echo ($fecha_fin != "") ? 'Hasta: ' . formatear_fecha('d-m-Y', $fecha_fin) : ''; ?></td>
            </tr>
        </table>
        <br><br>
        <?php
    } 
} 
?>
<table border="0" id="tblListado" cellpadding="1" class="dynamicTable responsive display table table-bordered" width="100%">
    <thead>
        <tr nobr="true">
            <th <?= ($p) ? 'width="17%"' : ''; ?> style="border-bottom: solid 1px black; text-align: center;"><b>Factura</b></th>
            <th <?= ($p) ? 'width="40%"' : ''; ?> style="border-bottom: solid 1px black; text-align: center;"><b>Cliente</b></th>
            <th <?= ($p) ? 'width="13%"' : ''; ?> style="border-bottom: solid 1px black; text-align: center;"><b>Fecha</b></th>
            <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black; text-align: center;"><b>Retención</b></th>
            <th <?= ($p) ? 'width="15%"' : ''; ?> style="border-bottom: solid 1px black; text-align: center;"><b>Total Factura</b></th>
        </tr>
    </thead>
    <tbody>
        <?php if (count($registros) > 0) {
            foreach ($registros as $key => $var) {
                ?>
                <tr nobr="true">
                    <td <?= ($p)?'width="17%"':'';?>><?= $var['serie']  . ' - ' . $var['fac_numero']; ?></td>
                    <td <?= ($p)?'width="40%"':'';?>><?= $var['cliente']; ?></td>
                    <td <?= ($p)?'width="13%"':'';?>><?=($tipo_rep == "")?'<span style="display:none;">'.formatear_fecha('YmdHis',$var['fac_fecha_fact']).'</span>':'';?><?= formatear_fecha('d-m-Y', $var['fac_fecha_fact']); ?></td>
                    <td <?= ($p) ? 'width="15%"' : ''; ?> style="text-align: right;"><?= number_format($var['fac_total_retencion'], 2); ?></td>
                    <td <?= ($p) ? 'width="15%"' : ''; ?> style="text-align: right;"><?= number_format($var['fac_total'], 2); ?></td>
                </tr>
                <?php
            }
        } else {
            if ($tipo_rep != "") {
                ?>
                <tr><th colspan="5" style="text-align: center;"><b>No se encontraron registros</b></th></tr>
                <?php
            }
        } ?>
    </tbody>
</table>
<?php if ($tipo_rep == "") { ?>
    <script type="text/javascript">
        $(document).ready(function(){
            $('#tblListado').dataTable({
               "bAutoWidth": false,
               "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]]
           });
        });
    </script>
<?php } ?>