<?php
/**
 * @author Elman Ortiz
 * @copyright 2018
 */
?>
<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte diario de articulo detallado
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if($tipo_reporte == 'pdf'):?>
    <style type="text/css">
        td { font-family: courier; font-size: 9px; }
    </style>
<?php endif;?>

<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'):?>
    <table border="0" width="100%">
      <tr>    
        <td><?php echo $fecha_desde_text;?></td>
        <td><?php echo $fecha_hasta_text;?></td>
        <td><?php echo $sucursal_text;?></td>
    </tr>
</table>
<?php endif;?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered"  aria-describedby="table_2_info">
    <thead >
        <tr nobr="true" >                        
            <th width="10%">Código</th>
            <th width="10%">Fecha</th>
            <th width="10%">Pago</th>
            <th width="10%">Cod. articulo</th>
            <th width="10%">Nombre</th>
            <th width="10%">Cantidad</th>
            <th width="10%">Subtotal</th>      
            <th width="10%">Descuento</th>      
            <th width="10%">Iva</th>            
            <th width="10%">Total</th>     
            <!-- <th width="10%">ESTADO</th>  -->     
        </tr>
    </thead>
    <tbody>
        <?php if(count($reporte) > 0){?>
            <?php 
            foreach ($reporte as $key => $rep) { ?>
                <tr nobr="true">                          
                    <td width="10%"><?php echo $rep['codigo']?></td>
                    <td width="10%"><?php echo $rep['fecha'];?></td>
                    <td width="10%"><?php echo $rep['tipo_pago'];?></td>
                    <td width="10%"><?php echo $rep['cod_articulo'];?></td>                        
                    <td width="10%"><?php echo $rep['nom_articulo'];?></td>                                                                                  
                    <td width="10%"><?php echo number_format($rep['cant_articulo'],2)?></td>    
                    <td width="10%"><?php echo number_format($rep['subtotal'],2)?></td>    
                    <td width="10%"><?php echo number_format($rep['descuento'],2)?></td>    
                    <td width="10%"><?php echo number_format($rep['iva'],2)?></td>                
                    <td width="10%"><?php echo number_format($rep['total'],2)?></td>    
                </tr>
                <?php
                //Totalizando valores por columna
                /*$total_subtotal += $rep['sub_total'];
                $total_descuento += $rep['descuento'];
                $total_iva += $rep['iva'];
                $total_percepcion += $rep['percepcion'];
                $total_retencion += $rep['retencion'];
                $total_total += $rep['total'];*/
            } 
            if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){ 
                ?>
                <!-- <tr> -->
                <!-- <td colspan="5"></td> -->
                <!-- <td width="8%"></td>
                <td width="8%"></td>
                <td width="8%"></td>
                <td width="12%"></td> -->
                <!-- <td colspan="5" align="center"><strong>TOTAL</strong></td>
                <td width="8%"><strong><?php echo number_format($total_subtotal,2)?></strong></td>                    
                <td width="8%"><strong><?php echo number_format($total_descuento,2)?></strong></td>   
                <td width="8%"><strong><?php echo number_format($total_iva,2)?></strong></td>   
                <td width="8%"><strong><?php echo number_format($total_percepcion,2)?></strong></td>   
                <td width="8%"><strong><?php echo number_format($total_retencion,2)?></strong></td>   
                <td width="8%"><strong><?php echo number_format($total_total,2)?></strong></td>    -->
                <!-- </tr> -->
                <?php 
            }
        }else{
            if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){
                ?>
                <tr nobr="true">
                    <td colspan="10" align="center">No se encontraron registros</td>
                </tr>
            <?php }?>
        <?php }?>
    </tbody> 
</table>