<style type="text/css">
    .tabla{
        font-weight: normal !important;
        font-family: 'Arial';
    }
    .tabla th{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .tabla td{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .tabla{
        border:1px solid black;
    }
    .num {
        mso-number-format:General;
    }
    .text{
        mso-number-format:"\@";
    }
</style>
<?php if(isset($excel)){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if (count($detalle) < 3) {
    $pixels = '15';
} else if (count($detalle)>3 && count($detalle)<5) {
    $pixels = '10';
} else {
    $pixels = '8';
}

if($excel!=1){
    echo $header;
}


$fecha_ini = new DateTime($inicio);
$fecha_fin = new DateTime($fin);
$intervalo = $fecha_ini->diff($fecha_fin);
$dias = $intervalo->format('%a')+1;
$diasFacturados = $dias;
$restantes = ($ndias-$dias);
?>
<table class="responsive table table-bordered" style="margin-bottom:0.1%">
    <tr>
        <th width="15%" style="font-weight:bold;">Días trabajados:</th>
        <th width="35%" style="text-align:left;"><?=$dias?></th>
        <th width="15%" style="font-weight:bold;">Días restantes:</th>
        <th width="35%" style="text-align:left;"><?php echo $restantes; ?></th>
    </tr>
</table>
<br><br>
<table class="responsive table table-bordered" id="cajas" border="1" cellpadding="2">
    <tr>
        <th style="font-weight:bold;" width="5%">N°</th>
        <th style="font-weight:bold;" width="<?php echo $pixels; ?>%">Día</th>
        <th style="font-weight:bold;" width="<?php echo $pixels; ?>%">Fecha</th>
        <?php
        $arr_cajas = array();
        foreach ($detalle as $det) {
            ?>
            <th style="font-weight:bold;"><?php echo $det['caj_nombre']; ?></th>
            <?php
            $arr_cajas[]= $det['caj_id'];
        }
        ?>
        <th style="font-weight:bold;">General</th>    
    </tr>            
    <?php
    if (!empty($registros)) {
        $arr_totales = array();
        $total_general = 0;
        $i=0;
        foreach ($registros as $reg) {
            $general = 0;
            $i++; ?>
            <tr>
                <td><?php echo $i;?></td>
                <td style="text-align:left;">
                    <?php 
                    $dias = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sábado");
                    echo $dias[date('w', strtotime($reg['fecha']))];
                    $fecha = formatear_fecha('Y-m-d', $reg['fecha']);
                    ?>
                </td>
                <td style="text-align:left;"><?php echo $reg['fecha']; ?></td>
                <?php 
                foreach ($arr_cajas as $arr) {
                    $total = $this->facturacion_model->proyeccion_cajas($arr, $fecha, $fecha, 'caj_id'); 
                    $tlt_caja = (count($total)>0)?$total[0]['total_caja']:0;
                    ?>
                    <td style="text-align:right"><?php echo number_format($tlt_caja, 2, '.',','); //echo $det['total_caja']; ?></td> 
                    <?php
                    if(count($total)>0){
                        $general += $total[0]['total_caja'];
                        if(!array_key_exists($arr, $arr_totales)){
                            $arr_totales[$arr] = $total[0]['total_caja'];
                        }else{
                            $arr_totales[$arr] += $total[0]['total_caja'];
                        }
                    }
                } 
                ?> 
                <td style="text-align:right"><?php echo number_format($general, 2, '.',','); ?></td>
            </tr>
            <?php     
            $total_general += $general;
        }
        $colspan = count($arr_totales) + 3;
        ?>
        <tr>
            <td colspan="3" style="font-weight:bold; text-align:right;">Totales</td>
            <?php
            foreach ($arr_totales as $tls) {
                ?>
                <td style="font-weight:bold;text-align:right;"><?php echo number_format($tls, 2, '.', ','); ?></td>
                <?php
            } ?>
            <td style="font-weight:bold;text-align:right;"><?php echo number_format($total_general, 2, '.', ','); ?></td>
        </tr>
        <tr>
            <td colspan="3" style="font-weight:bold; text-align:right;">Proyección mensual</td> 
            <?php
            $total_meta = 0;
            foreach ($arr_totales as $tot => $valor) {
                /*$meta_caja = $this->gsatelite->get_campo('caj_caja', 'caj_estimado_facturacion', array('caj_id'=>$tot));
                $meta = ($meta_caja>0)? $meta_caja : 0;*/
                $periodo = date('Y-m',strtotime($fin));
                $meta_caja2 = $this->facturacion_model->get_estimado_fac(array('caj_id'=>$tot),$periodo);                
                if($meta_caja2['mtc_meta_venta']!=''){
                    $meta = $meta_caja2['mtc_meta_venta'];
                }else if($meta_caja2['caj_estimado_facturacion'] != ''){
                    $meta = $meta_caja2['caj_estimado_facturacion'];
                }else{
                    $meta = 0;
                }
                $proyeccion = (((float)$valor/(int)$diasFacturados)*(int)$ndias);
                ?>
                <td style="font-weight:bold;text-align:right;"><?php echo number_format($proyeccion, 2, '.', ','); ?></td>
                <?php
                $total_meta += $meta; 
            }
            $proyeccion_gral = (((float)$total_general/(int)$diasFacturados)*(int)$ndias);
            $diferencia = 0;
            $venta = 0;
            if($total_meta>0){
                $diferencia = str_replace('-', '',(float)$total_meta - (float)$total_general);
                if($total_meta>$total_general){
                    $venta = (float)$diferencia / (float)$restantes;
                }
            }
            ?>
            <td style="font-weight:bold;text-align:right;" ><?php echo number_format($proyeccion_gral, 2, '.', ','); ?></td>
        </tr>
        <tr>
            <td colspan="<?=$colspan?>" style="font-weight:bold; text-align:right;">Meta mensual</td> 
            <td style="font-weight:bold;text-align:right;"><?php echo number_format($total_meta, 2, '.', ','); ?></td>
        </tr>
        <tr>
            <td colspan="<?=$colspan?>" style="font-weight:bold; text-align:right;">Diferencia</td> 
            <td style="font-weight:bold;text-align:right;"><?php echo number_format($diferencia, 2, '.', ','); ?></td>
        </tr>
        <tr>
            <td colspan="<?=$colspan?>" style="font-weight:bold; text-align:right;">Venta diaria necesaria</td> 
            <td style="font-weight:bold;text-align:right;"><?php echo number_format($venta, 2, '.', ','); ?></td>
        </tr>
        <?php
    }else{
        ?>
        <tr>
            <td colspan="10" style="text-align:center;">No se encontraron registros</td>
        </tr>
        <?php    
    } ?>         
</table>