<?php
$pdf = ($reporte == 'pdf') ? true : false;
if($reporte == 'excel'){
	header("Content-Type: application/vnd.ms-excel");
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("content-disposition: attachment;filename=" . $filename . ".xls");
	?>
	<meta charset="utf-8" />
	<div class="head">
		<table>
			<tr>
				<td align="center" colspan="6" >
					<h4>
						<?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?>
						<br />
						<span>Reporte de Facturas y Entregas de Inventarios</span>
					</h4>
				</td>
			</tr>
		</table>
	</div>
	<div>
		<table>
			<tr>
				<td></td>
				<td style="border: 1px solid black; width: 20%; text-align: center;">
					<strong>PERIODO: </strong>
				</td>
				<td style="border: 1px solid black; width: 20%; text-align: center;" colspan="2">
					<?php echo $txt_fecha_inicio." - ".$txt_fecha_fin;?>
				</td>
			</tr>
		</table>
	</div>
	<br>
	<?php
} ?>
<table border="1" id="detalles" class="responsive table table-bordered table-condensed" style="font-size: <?= ($pdf) ? 7 : 11; ?>px; <?= ($pdf) ? 'width="90%"' : ''; ?>">
	<thead>
		<tr nobr="true">
			<th style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="3%"' : ''; ?>><p><strong>  N° </strong></p></th>	
			<th style="text-align: center; vertical-align: middle;" <?=($pdf)?'width="18%"':'';?>><p><strong>  Cliente </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="14%"':'';?>><p><strong>  Factura </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="8%"':'';?>><p><strong>  Fecha </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?=($pdf)?'width="23%"':'';?>><p><strong>  Producto </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?=($pdf)?'width="7%"':'';?>><p><strong>  Cantidad </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?=($pdf)?'width="9%"':'';?>><p><strong>  Movimiento  Inventario </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?=($pdf)?'width="9%"':'';?>><p><strong>  Fecha  Movimiento </strong></p></th>
			<th style="text-align: center; vertical-align: middle;" <?=($pdf)?'width="9%"':'';?>><p><strong>  Cantidad  Despachada </strong></p></th>
		</tr>
	</thead>
	<tbody>
		<?php
		$numero = 1;
		if(count($registros) > 0) {
			foreach ($registros as $key => $v) {
				?>
				<tr>
					<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="3%"' : ''; ?>><?php echo $numero++; ?></td>
                    <td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="18%"': '';?>><?php echo $v['cli_nombre']." ".$v['cli_apellido']; ?></td>
					<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="14%"': '';?>><?php echo $v['fac_numero']." - ".$v['tif_nombre']; ?></td>
					<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="8%"': '';?>><?php echo formatear_fecha('Y-m-d', $v['fac_fecha_fact']); ?></td>
    				<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="23%"': '';?>><?php echo $v['nom']; ?></td>
					<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="7%"': '';?>><?php echo $v['nombre']; ?></td>
    				<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="9%"': '';?>><?php echo number_format($v['cvafax'], 4); ?></td>
    				<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="9%"': '';?>><?php echo $v['fecha_fac']; ?></td>
    				<td style="text-align: center; vertical-align: middle;" <?= ($pdf) ? 'width="9%"': '';?>><?php echo number_format($v['cvadesp'], 4); ?></td>
                </tr>
				<?php
			}
		} else {
			if($reporte != ''){
				?>
				<tr>
					<td colspan="17" style="text-align: center;"><b>No se encontraron Registros</b></td>
				</tr>
				<?php
			}			
		}
		?>
	</tbody>
</table>

