<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte de Vendedores
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<style type="text/css">
    .totales{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
      
    }
    .titulo{
        vertical-align: middle;
        text-align: center;
        font-weight:bold;
       
    }
</style>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla td{
            vertical-align: middle;
            text-align: left;
        }
        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
            font-weight:bold;
            font-size:10;
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte != '') { ?>
    <table border="1" class="tabla" cellpadding="1">
<?php } else { ?>
    <table class="responsive table table-bordered dataTable" id="tbl_facturas" name="tbl_facturas" border="0" style="margin-left: 4px; width: 99%; font-size:12px;" cellpadding="1">
<?php } ?>
    <thead>
        <tr>
            <th width="40%">Nombre</th>
            <th width="20%">Venta Neta<?= ($tipo_reporte != '') ? '<br>' : ' '; ?>(Menos Retenciones)</th>
            <th width="20%">Meta</th>
            <th width="10%">Avance</th>
            <th width="10%">Faltante</th>
        </tr>
    </thead>
<tbody id="tbl_contenedor">
<?php
    if (count($vendedores) > 0){
        //declaracion de varaibles
        foreach ($vendedores as $key => $value) { 
            $mes        = intval($value['periodo']);
            $faltante   = ($value['faltante'] > 0) ? number_format( $value['faltante'] , 2).'%' : '-';
            $avance     = ($value['avance'] > 0) ? number_format( $value['avance'] , 2).'%' : '-';
            $meta_ven   = ($value['mtv_meta_venta'] > 0) ? '$' . number_format($value['mtv_meta_venta'], 2) : '-';
        ?>
        <tr>
            <td width="40%"><?php echo $value['ven_codigo'].' - '.$value['ven_nombre'].' '.$value['ven_apellidos']; ?></td>
            <td width="20%" style="text-align: right;"><?php echo '$' . number_format($value['venta_neta'], 2); ?></td>
            <td width="20%" style="text-align: right;"><?php echo $meta_ven; ?></td>
            <td width="10%" style="text-align: right;"><?php echo $avance; ?></td>
            <td width="10%" style="text-align: right;"><?php echo $faltante; ?></td>
        </tr>            
<?php }
    } else {
        echo '<tr><td colspan="5" style="text-align: center;">No se encontraron registros</td></tr>';
    }
?>
</tbody> 
</table>