<?php 
$fecha_ini_inverse = date("Y-m-d", strtotime($fecha_ini)); 
$fecha_fin_inverse = date("Y-m-d", strtotime($fecha_fin));
$p = ($format == 'pdf') ? true : false;
if ($format == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("Content-Disposition: attachment;filename=Reportes_ventas_credito_contado(".date('d-m-Y_His').").xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
for ($i=0; $i < sizeof($tipospago); $i++) {
    $tipospago[$i]["data"] = array();
    $tipospago[$i]["total_descripcion"] = "Total Ventas " . $tipospago[$i]["tpg_nombre"] . " ($)";
}
foreach ($cajas_todo as $ca){
    for ($i=0; $i < sizeof($tipospago); $i++) {
        if (($ca['fac_id_tpg']) == ($tipospago[$i]['tpg_id'] )){
            $tipospago[$i]["data"][] = $ca;
        }
    }
}
$tpfacturas = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'));
$tpfacturasSort = new ArrayObject($tpfacturas);
$tpfacturasSort->asort();
?>
<style type="text/css">
    td{
        padding: 4px;
    }
</style>
<table class="responsive display table table-bordered" border="1" <?=($p)?'style="font-size: 7pt;"':'';?>>
    <?php if ($format == 'excel') { ?>
        <tr >
            <td colspan="12" style="text-align: center; font-weight: bold;">
                <span>Reporte Ventas credito y Contado del <?= formatear_fecha('d-m-Y', $fecha_ini_inverse) ?> al <?= formatear_fecha('d-m-Y', $fecha_fin_inverse) ?></span><br>
                <span>Sucursal: <?php echo $cajas_todo[0]['suc_nombre'] ?></span><br><span>Caja: <?php echo $cajas_todo[0]['caj_nombre'] ?></span>
            </td>
        </tr>
    <?php } ?>
    <tr style="font-weight: bold; text-align: center;">
        <th>Tipo factura</th>
        <th>Serie</th>
        <th>Comprobante</th>
        <th <?=($p)?'width="7%"':'';?>>Fecha de factura</th>
        <th <?=($p)?'width="7%"':'';?>>Caja</th>
        <th <?=($p)?'width="12%"':'';?>>Cliente</th>
        <th <?=($p)?'width="6%"':'';?>>Estado</th>
        <th>Usuario</th>
        <th>SubTotal</th>
        <th>Descuentos</th>
        <th>Impuestos</th>
        <th>Retenciones</th>
        <th>Total</th>
    </tr>
    <?php
    // TOTALES GENERALES
    $corr  = 1;
    $suma_subtotal = 0;
    $suma_descuentos = 0;
    $suma_impuestos = 0;
    $suma_totales = 0;
    $suma_retenciones = 0;
    $suma_tipopago = 0;
    if (!empty($tipospago)) {
        foreach ($tipospago as $cajas){
            // TOTALES POR TIPO DE PAGO
            $tpg_suma_subtotal = 0;
            $tpg_suma_descuentos = 0;
            $tpg_suma_impuestos = 0;
            $tpg_suma_totales = 0;
            $tpg_suma_retenciones = 0;
            $tpg_suma_tipopago = 0;
            ?>
            <tr >
                <td colspan="12" style="background-color: #fff; text-align: center; font-weight: bold;" onclick="despletpg(<?php echo $cajas['tpg_id']; ?>)"><?php echo $cajas['tpg_nombre'] ?></td>
            </tr>
            <?php 
            foreach ($cajas['data'] as $ca){
                foreach ($tpfacturasSort as $tpf){
                    if ($tpf == $ca['fac_id_tpg']){
                        if($ca['fac_estado'] == 0) {
                            $esto = 'Anulada';
                        }elseif ($ca['fac_estado'] == 1) {
                            $esto = 'Pendiente'; 
                        } elseif ($ca['fac_estado'] == 2) {
                            $esto = 'Pagada';
                        }
                        ?>
                        <tr nobr="true" name="tpg<?php echo $cajas['tpg_id'] ?>">
                            <td><?php echo $ca['tif_nombre']; ?></td>
                            <td><?php echo $ca['sef_nombre']; ?></td>
                            <td><?php echo $ca['fac_numero']; ?></td>
                            <td <?=($p)?'width="7%"':'';?>><?php echo $ca['fecha']; ?></td>
                            <td <?=($p)?'width="7%"':'';?>><?php echo $ca['caj_nombre']; ?></td>
                            <td <?=($p)?'width="12%"':'';?>><?php echo $ca['cli_codigo'] . ' - ' . $ca['cli_nombre']; ?></td>
                            <td <?=($p)?'width="6%"':'';?>><?php echo $esto; ?></td>
                            <td><?php echo $ca['usuario']; ?></td>
                            <td style="text-align: right;">$<?php echo number_format($ca['fac_subtotal'], 2);  ?></td>
                            <td style="text-align: right;">$<?php echo number_format($ca['fac_descuento'],2); ?></td>
                            <td style="text-align: right;">$<?php echo number_format($ca['fac_impuesto'], 2); ?></td>
                            <td style="text-align: right;">$<?php echo number_format($ca['fac_total_retencion'], 2); ?></td>
                            <td style="text-align: right;">$<?php echo number_format(($ca['fac_total'] - $ca['fac_total_retencion']), 2); ?></td>
                        </tr>
                        <?php
                        $tpg_suma_subtotal += $ca['fac_subtotal'];
                        $tpg_suma_descuentos += $ca['fac_descuento'];
                        $tpg_suma_impuestos += $ca['fac_impuesto'];
                        $tpg_suma_retenciones += $ca['fac_total_retencion'];
                        $tpg_suma_tipopago += ($ca['fac_total'] - $ca['fac_total_retencion']);
                        $suma_subtotal += $ca['fac_subtotal'];
                        $suma_descuentos += $ca['fac_descuento'];
                        $suma_impuestos += $ca['fac_impuesto'];
                        $suma_retenciones += $ca['fac_total_retencion'];
                        $suma_tipopago += ($ca['fac_total'] - $ca['fac_total_retencion']);;
                        $corr++;
                    } /*endif*/
                } /*endforeach*/
            } ?>
            <tr>
                <td colspan="8" style="text-align:center;"><b><?php echo $cajas['total_descripcion'] ?></b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($tpg_suma_subtotal,2); ?></b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($tpg_suma_descuentos,2); ?></b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($tpg_suma_impuestos,2); ?></b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($tpg_suma_retenciones,2); ?></b></td>
                <td style="text-align:right;"><b><?php echo '$'.number_format($tpg_suma_tipopago,2); ?></b></td>
            </tr>
            <?php 
        } ?>
        <tr>
            <td colspan="8" style="text-align:right;"><b>TOTAL GENERAL</b></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($suma_subtotal,2); ?></b></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($suma_descuentos,2); ?></b></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($suma_impuestos,2); ?></b></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($suma_retenciones,2); ?></b></td>
            <td style="text-align:right;"><b><?php echo '$'.number_format($suma_tipopago,2); ?></b></td>
        </tr>
        <?php   
    }else{ ?>
        <tr>
            <td colspan="13" style="text-align:center;">No se encontraron registros</td>
        </tr>
        <?php
    } ?>
</table>
