<style type="text/css">
    .ui-datepicker {
        z-index: 999 !important;
    }
</style>
<form method="post" action="" autocomplete="off" id="form_report" target="_blank">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4><span>Filtros </span></h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Desde:<b style="color:red">*</b></label>
                                    <div class="span7 controls labels-info">
                                        <input type="text" id="txtFechaIni" name="txtFechaIni"  class="datePicker" placeholder="dd-mm-yyyy" onchange="$('#txtFechaIni_error').text('');" value="<?= date('d-m-Y') ?>"/>
                                        <div id="txtFechaIni_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="form-label span3">Hasta:<b style="color:red">*</b></label>
                                    <div class="span7 controls labels-info">
                                        <input type="text" id="txtFechaFin" name="txtFechaFin"  class="datePicker" placeholder="dd-mm-yyyy" onchange="$('#txtFechaFin_error').text('');" value="<?= date('d-m-Y') ?>"/>
                                        <div id="txtFechaFin_error" style="color:red;padding-top:1%;"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <label class="form-label span3">Artículos:</label>
                                <div class="span7 controls" id="div_slcproducto_servicio">
                                    <input type="hidden" id="slcproducto_servicio" class="selectHidden" name="slcproducto_servicio" />
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">

                                </div>
                            </div>                            
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <div class="span7 controls">
                                        <?php if ($permisos['permite_ver']): ?>
                                            <button type="button" id="btnConsultar" class="btn btn-success"><span class="icomoon-icon-search-3">Consultar</span></button>
                                        <?php else: ?>
                                            <h4>No tienes permiso de ver este reporte</h4>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid" style="text-align: right;">
                                    <input type="hidden" id="permite_exportar" value="<?= $permisos['permite_agregar'] ?>">
                                    <button type="submit" class="btn btn-info botonExcel" name="tipo_reporte" title="Exportar a excel" id="imprimir_factura" style="display: none;" value="excel">
                                        <span class="icomoon-icon-file-excel white">Exportar a EXCEL</span>
                                    </button>
                                    <button type="submit" class="btn btn-info botonPDF" name="tipo_reporte" title="Exportar a PDF" id="imprimir_factura_pdf" style="display: none;" value="pdf" >
                                        <span class="icomoon-icon-file-pdf white">Exportar PDF</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Listado</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content noPad content"  id="dv_contenedor_reg" style="overflow: auto; height: 100%;">
                    <div id="datagried" >                       
                    </div>
                    <br>
                </div>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript">
    $(document).ready(function () {
        $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });
        $(".datePicker").mask("99-99-9999");

        $("#form_report").validate({
            ignore:"",
            rules: {
                txtFechaIni:{ required:true},
                txtFechaFin:{ required:true}
            }, 
            ignore: ".select2-container",
            errorPlacement: function (error, element) {
                var nombre=$(element).attr("id");
                $('#'+nombre+'_error').text('Campo requerido');
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

        $("#txtFechaIni,#txtFechaFin").change(function(event) {  validar_fecha_inicio_fin('txtFechaIni','txtFechaFin','La fecha de desde debe ser menor a la fecha hasta'); });

        $("#btnConsultar").click(function(event){
            event.preventDefault();
            $("#imprimir_factura, #imprimir_factura_pdf").hide();
            var productos = $("#slcproducto_servicio").val();
            var fecha_ini = $("#txtFechaIni").val();
            var fecha_fin = $("#txtFechaFin").val();
            if (fecha_ini == "" || fecha_fin == "" ){
                crear_alerta('error','Alerta','Fechas son obligatorias.');
                return false;
            }
            $("#dv_contenedor_reg").hide('slide',{ direction:'right' }, 400,function(){
                $.ajax({
                    type:'POST',
                    url: urlj + 'facturacion/reportes/componentes_factura/1',
                    dataType: 'json',
                    data:{
                        slcproducto_servicio:productos,
                        txtFechaIni:fecha_ini,
                        txtFechaFin:fecha_fin,
                        tipo_reporte: ''
                    },
                    beforeSend:function(){
                        wait.start();
                    },
                    success:function(result){
                        $("#datagried").html(result.html);
                        if (result.filas > 0 && parseInt($("#permite_exportar").val()) > 0) {
                            $("#imprimir_factura").show();
                            $("#imprimir_factura_pdf").show();
                        }
                        $("#dv_contenedor_reg").show("slide", { direction: 'left' }, 500);
                        wait.close();
                    }
                });
            });
        });

        $("#slcproducto_servicio").select2({
            placeholder:'Buscar productos',
            minimumInputLength: 3,
            multiple:true,
            ajax: {
                url:urlj+'modulo_compras/procesos/consultar_articulos',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function (articulo) {
                    return {
                        articulo: articulo
                    };
                },
                results: function (data) {
                    var myResults = [];
                    $.each(data, function (index, item) {
                        myResults.push({
                            'id': item.art_id,
                            'text': (item.art_codigo+' - '+item.art_nombre)
                        });
                    });
                    return {
                        results: myResults
                    };
                } 
            }
        });  

        function verifica_fecha(fecha_ini, fecha_fin) {
            var fecha_i = fecha_ini.split("-").reverse().join("-");
            var fecha_f = fecha_fin.split("-").reverse().join("-");
            if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
                $("#txtFechaFin").addClass('error');
                $("#txtFechaFin_error").text("Verifique las fechas del período");
                return false;
            } else {
                $("#txtFechaFin").removeClass('error');
                $("#txtFechaFin_error").text('');
                return true;        
            }
        }        

    });
</script>
