<div class="row-fluid">
    <div class="span12">
        <div class="box hover">
            <div class="title">
                <h4><span>Filtros </span></h4>
                <a href="#" class="minimize" style="display:none;">Minimize</a>
            </div>
            <div class="content">
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Desde:<b style="color:red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <input type="text" id="fecha_ini" name="fecha_ini" class="datePicker" placeholder="dd-mm-yyyy" value="<?= date('d-m-Y') ?>"/>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Hasta:<b style="color:red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <input type="text" id="fecha_fin" name="fecha_fin" class="datePicker" placeholder="dd-mm-yyyy" value="<?= date('d-m-Y') ?>"/>
                                    <?php // ($this->input->post('txtFechaIni')) ? $this->input->post('txtFechaIni') : date('d-m-Y'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Tipo factura:</label>
                                <div class="span7 controls labels-info">
                                    <select name="tipo_fac" id="tipo_fac" class="nostyle" placeholder="Seleccione">
                                        <option value=""></option>
                                        <?php
                                        $parametros = json_decode($this->gsatelite->get_parametro('SYS_TIPO_FACTURAS'), true);
                                        $not_cred = (isset($parametros['NOTA CREDITO'])) ? $parametros['NOTA CREDITO'] : 0;
                                        $not_remi = (isset($parametros['NOTA REMISION'])) ? $parametros['NOTA REMISION'] : 0;
                                        $excluidas = implode(',', array($not_remi));
                                        $where = array('tif_estado' => 1, 'tif_aplica_venta' => 1, "tif_id NOT IN ($excluidas)" => NULL);
                                        $facturas = $this->gsatelite->get_tabla('tif_tipo_factura', $where);
                                        foreach ($facturas as $key => $val) {
                                            ?>
                                            <option value="<?php echo $val['tif_id'] ?>"><?php echo $val['tif_nombre'] ?></option>
                                            <?php
                                        }
                                        ?>
                                    </select><br><br>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Estado:<b style="color:red">*</b></label>
                                <div class="span7 controls labels-info">
                                    <select id="slcEstado" name="slcEstado" class="nostyle" placeholder="Seleccione" >
                                        <option value=""></option>
                                        <option value="1">Facturas generadas y no transmitidas</option><?php //SIN CODIGO DE FACT.SAT ?>
                                        <option value="2">Facturas validadas </option>
                                        <option value="3">Facturas transmitidas y no procesadas</option><?php //CON ERROR ?>
                                        <option value="4">Facturas enviadas por correo</option><?php //OK PERO SIN CORREO ?>
                                        <option value="5">Facturas no enviadas por correo</option><?php //OK PERO SIN CORREO ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row row-fluid">
                    <div class="span12">
                        <div class="span6">
                            <div class="row-fluid">
                                <div class="span7 controls">
                                    <button type="button" id="btnConsultar" class="btn btn-success icomoon-icon-search-2">Consultar</button>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <div class="span10 controls" id="procesar" style="display:none;text-align:right;">
                                    <button class="btn btn-success" title="Procesar Facturas" id="send_ids">
                                        <span class="icomoon-icon-cogs">Procesar Documentos Seleccionados</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<form method="POST" id="factura_grid" name="factura_grid" action="<?= base_url('facturacion/facturar/procesar_dtes_masivo')?>">
    <input type="hidden" name="num_reg" id="num_reg" value="">
    <input type="hidden" name="tipo_pr" id="tipo_pr" value="">
    <div class="box gradient">
        <div class="title">
            <h4><span>Facturas</span></h4>
        </div>
        <div class="content noPad clearfix" id="datos">
            <table class="responsive table table-bordered" id="facturas">
                <thead>
                    <tr>
                        <th style="font-size: 8px;"><input type="checkbox" class="form-check-input" id="apply_todo"> (Todo)</th>
                        <th>Tipo factura</th>
                        <th>Num. Interno</th>
                        <th>Num. de Control</th>
                        <th>Num. Referencia</th>
                        <th>Cliente</th>
                        <th>Fecha</th>
                        <th>Total <?php echo $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ''); ?></th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="contenedor">
                </tbody>
            </table>
        </div>
    </div>
</form>

<script type="text/javascript">
    $(document).ready(function(){ 
        $("select").select2();

        $('#facturas').dataTable();

        $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            maxDate: 0,
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
        });
        $(".datePicker").mask("99-99-9999");
        
        $('.datePicker').live('change', function(e){
            if ($("#fecha_ini").val() != "" &&  $("#fecha_fin").val() != "") {
                fecha_valida($("#fecha_ini").val(), $("#fecha_fin").val());
            }
        });

        $("#btnConsultar").live('click', function(e){
            e.preventDefault();
            $('#procesar').hide();
            var tf = $("#tipo_fac").val();
            var f1 = $("#fecha_ini").val();
            var f2 = $("#fecha_fin").val();
            var st = $("#slcEstado").val();
            if (f1 != "" && f2 != "" && fecha_valida(f1, f2) && st > 0) {
                $.ajax({
                    type: 'POST',
                    dataType: 'json',
                    url: urlj + 'facturacion/facturar/proceso_masivo_dte',
                    data: {
                        'tipo_fac': tf,
                        'slcEstado': st,
                        'fecha_ini': f1,
                        'fecha_fin': f2
                    },
                    beforeSend: function () {
                        wait.start("Obteniendo Documentos");
                    },
                    success: function (data) {
                        $("#facturas").dataTable().fnDestroy();
                        $("#contenedor").html(data.tabla);
                        $('#facturas').dataTable();
                        if (data.filas > 0) {
                            // crear_alerta("info", "Mostrando hasta 100 documentos");
                            $('#num_reg').val(data.filas);
                            $('#tipo_pr').val(data.tipo_proceso);
                            if (data.tipo_proceso == 3) {
                                $("#send_ids span").text("Actualizar Información Documentos Seleccionados");
                            } else {
                                $("#send_ids span").text("Procesar Documentos Seleccionados");
                            }
                            $('#procesar').show();
                        }
                        if (data.tipo_proceso == 2 || data.tipo_proceso == 4 || data.tipo_proceso == 5) {
                            $('#apply_todo').attr('disabled', true); 
                            $('#procesar').hide();
                        } else {
                            $('#apply_todo').removeAttr('disabled');
                        }
                        wait.close();
                    },
                    error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    }
                });
            } else {
                crear_alerta('error', 'Verifique campos requeridos', '');
                return false;
            }
        });

        $("#apply_todo").change(function () {
            $("#facturas").dataTable().fnDestroy();
            $("input:checkbox").prop('checked', $(this).prop("checked"));
            $('#facturas').dataTable();
        });

        $('body').on('click', '#send_ids', function(e) {
            e.preventDefault();
            var chkd = 0;
            $(".checkear").each(function(){
                if ($(this).is(':checked')) {
                    chkd++;
                }
            });
            if (chkd > 0) {
                $("#facturas").dataTable().fnDestroy();
                wait.start()
                $("#factura_grid").submit();
            } else {
                crear_alerta('error', 'No ha seleccionado ningún documento', '');
            }
        });        

    });

    function fecha_valida(fecha_ini, fecha_fin) {
        var start = fecha_ini.split("-").reverse().join("-");
        var final = fecha_fin.split("-").reverse().join("-");
        if (Date.parse(start) > Date.parse(final)) {
            crear_alerta('error', 'Verifique las fechas del período', '');
            return false;
        } else {
            return true;
        }    
    }
</script>
<!-- <script src="<?php echo base_url() . 'js/facturacion/crear_factura.js'; ?>"></script> -->