<?php
// Imprimir los datos que provienen del controlador
/* =====================================================================================================================*/
/*                                   configuraciones                                                                    */
/*======================================================================================================================*/
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');

$letra                 = (isset($size_letra)) ? $size_letra : 5; // Tamanhio de letra para todo el ticket, parametro de la frf
$letra_prod            = 6.5;           // Tamanhio de la letra del nombre del producto
$width_pag             = 190;                                                            // Ancho de la tabla
$numero_tiquete        = str_pad($datos_factura[0]['fac_numero'], 8, '0', STR_PAD_LEFT); // Numero de tiquete
$margen_izquierdo      = 10 + $width_conf;
$margen_superior       = 0 + $height_conf;
$border                = 0;
// Parametro
$rol = $this->gsatelite->get_parametro('SYS_ID_ROL_CAJA');
// Obtener los datos de cajero que registro la factura
$this->db->join('caj_caja', 'caj_id = uxc_id_caj', 'inner');
$info_uxc = $this->gsatelite->get_tabla('uxc_usuarioxcaja', array('uxc_id' => $datos_factura[0]['fac_id_uxc']));

$where = array(
    'rol_id'        => $rol,
    'id'            => (isset($info_uxc[0]['uxc_id_usu'])) ? $info_uxc[0]['uxc_id_usu'] : 0,
    'sef_id_tif'    => $datos_factura[0]['fac_id_tif']
);
/*======================================================================================================================*/
// Agrupador
$groupby = 'uxc_id';
$orderby = 'uxc_id';
$dt_caja               = $this->facturacion_model->get_datos_usuarioxcaja($where, $groupby, $orderby);
// Consultar los datos de Cambio para el ticket
$this->db->join('abc_abono_cliente', 'abc_id = abf_id_abc');
$dt_cambio_efectivo    = $this->gsatelite->get_tabla('abf_abono_factura', array('abf_id_fac' => $datos_factura[0]['fac_id'], 'abc_estado' => 1));
// Obtener la direccion de la sucursal asociado al empleado
$emp_sucursal          = $this->gsatelite->get_tabla('suc_sucursal', array('suc_id' => $datos_factura[0]['fac_id_suc']));
// Obtener el departamento de la sucursal asociado al empleado
if (isset($emp_sucursal[0]['suc_id_mun'])) {
    $this->db->join('dep_departamento', 'dep_id = mun_id_dep');
    $emp_dep               = $this->gsatelite->get_tabla('mun_municipio', array('mun_id' => $emp_sucursal[0]['suc_id_mun']));
}
/*======================================================================================================================*/
/*                                   Parametros                                                                         */
/*======================================================================================================================*/
$nombre_empresa        = $this->gsatelite->get_parametro('SYS_EMPRESA');
// Se obtiene la direccion de la sucursal asociada al empleado sino coloca una por defecto
$direccion_empresa     = (count($emp_sucursal) > 0) ? $emp_sucursal[0]['suc_direccion'] : $this->gsatelite->get_parametro('SYS_DIR');
// Se obtiene el departamento de la sucursal asociada al empleado sino coloca una por defecto
$dep_empresa           = (isset($emp_dep) && count($emp_dep) > 0) ? $emp_dep[0]['dep_nombre'] : $this->gsatelite->get_parametro('SYS_DEPARTAMENTO');
$nrc_empresa           = $this->gsatelite->get_parametro('SYS_REGISTRO');
$nit_empresa           = $this->gsatelite->get_parametro('SYS_NIT');
$giro_empresa          = $this->gsatelite->get_parametro('SYS_GIRO_EMPRESA');
$empresa               = $this->gsatelite->get_parametro('SYS_CONFIGURACION_CORTE_CAJA', null, null, array('EMPRESA'));
/* =====================================================================================================================*/
/*                                   Fin de configuraciones                                                             */
/*======================================================================================================================*/

$registro_factura = $this->gsatelite->get_tabla('fac_factura', array('fac_id' => $datos_factura[0]['fac_id']));
$registro_factura = $registro_factura[0];
?>
<table border="<?php echo $border; ?>">
    <tr><!-- Inicio de factura !--><!-- Encabezado de factura !-->
        <td width="<?php echo $margen_izquierdo; ?>px" height="<?php echo $margen_superior; ?>px"></td>
        <td width="<?php echo ($width_pag - $margen_izquierdo); ?>px">
            <table border="<?php echo $border; ?>" style="font-size:<?= $letra ?>px;width: <?= $width_pag ?>px;text-align: center;">
                <!-- Cabecera del Ticket -->
                <tr>
                    <td colspan="2">
                        <?= (isset($empresa)) ? $empresa : '' ?>
                    </td>
                </tr>
                <tr>
                    <!-- Nombre de la empresa -->
                    <td colspan="2" style="font-size: 12px;">
                        <?= $nombre_empresa ?>
                    </td>
                </tr>
                <tr>
                    <!-- Direccion de la empresa -->
                    <td colspan="2">
                        Dir.: <?= $direccion_empresa ?>
                    </td>
                </tr>
                <tr>
                    <!-- Departamento de la surcusal -->
                    <td colspan="2">
                        Depto. de <?= $dep_empresa ?>
                    </td>
                </tr>
                <tr>
                    <!-- Giro de la Empresa -->
                    <td colspan="2">
                        Giro: <?= $giro_empresa ?>
                    </td>
                </tr>
                <tr style="text-align: justify; ">
                    <!-- NRC de la Empresa -->
                    <td width="60%">
                        NRC: <?= $nrc_empresa ?>
                    </td>
                    <!-- I.V.A. D.L. -->
                    <td width="40%">I.V.A. D.L.# 296</td>
                </tr>
                <tr style="text-align: justify;">
                    <!-- NIT de la Empresa -->
                    <td width="60%">
                        NIT: <?= $nit_empresa ?>
                    </td>
                    <!-- La Caja -->
                    <td width="40%" align="left">Caja # <?= (isset($info_uxc[0]['caj_nombre'])) ? trim($info_uxc[0]['caj_nombre']) : ''; ?></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                </tr>
                <!-- Cuerpo con los detalles del ticket -->
                <!-- Numero de Ticket -->
                <tr style="text-align: center;">
                    <td colspan="2">
                        <?php echo ($registro_factura['fac_id_origen_devolucion'] > 0) ? 'Tiq. Devolución' : 'Tiquete' ?> # <?= $numero_tiquete ?>
                    </td>
                </tr>
                <!-- Separador -->
                <tr>
                    <td colspan="2">--------------------------------------------------------</td>
                </tr>
                <!-- Cabecera de los detalles -->
                <tr style="text-align: left;">
                    <td colspan="2">
                        <table border="0">
                            <tr>
                                <td width="25%">Código</td>
                                <td width="75%">Descripción</td>
                            </tr>
                            <tr>
                                <td width="25%">Medida</td>
                                <td width="22%">Cantidad</td>
                                <td width="26%">P/Unit.</td>
                                <td width="26%">Subtotal</td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <!-- Separador -->
                <tr>
                    <td colspan="2">--------------------------------------------------------</td>
                </tr>
                <!-- Detalles -->
                <tr>
                    <td colspan="2">
                        <?php
                        /*================================================================*/
                        // Variables para el detalle del Ticket
                        $cantidad = count($datos_factura);
                        $ventaG = 0;
                        $ventaE = 0;
                        $venta_no_sujeta = 0;
                        $suma_total_factura = 0;
                        $descuento_valor    = $datos_factura[0]['fac_descuento'];
                        $contadorProductos  = 0;

                        if (strpos($SUBSIDIO, ',')) {
                            $subsidio = explode(',', $SUBSIDIO);
                        } else {
                            $subsidio = $SUBSIDIO;
                        }


                        $total_sub = 0;
                        /*================================================================*/
                        ?>
                        <table border="0">
                            <!-- Impresion de los detalles de los productos con sus precios -->
                            <?php

                            if (count($cantidad) > 0) {
                                foreach ($datos_factura as $fila) {
                                    $cantidad           = $fila['def_cantidad'];
                                    $contadorProductos += $cantidad;

                                    if (is_array($subsidio)) {
                                        $this->db->where_in('rxf_id_ret', $subsidio);
                                    } else {
                                        $this->db->where('rxf_id_ret', $subsidio);
                                    }

                                    $array_ret = $this->gsatelite->get_tabla('rxf_retencionxdetalle_factura', array('rxf_id_def' => $fila['def_id']));

                                    $valor = array_column($array_ret, 'rxf_monto');
                                    $total_sub += array_sum($valor);

                                    //$precioU = $cantidad * ($fila['def_precio'] + $fila['def_precio']*($fila['def_porcentaje_impuesto']/100));
                                    $precioU = ($fila['def_precio'] + $fila['def_precio'] * ($fila['def_porcentaje_impuesto'] / 100));

                                    $ventaG_temp = 0;
                                    $ventaE_temp = 0;

                                    if ($fila['def_porcentaje_impuesto'] > 0) {
                                        // $ventaG_temp = $fila['def_subtotal'] + $fila['def_impuesto'];
                                        $ventaG_temp = ($fila['def_precio'] + $fila['def_precio'] * ($fila['def_porcentaje_impuesto'] / 100)) * (float)$cantidad;
                                        // $ventaG += $ventaG_temp;
                                        $ventaG += number_format($ventaG_temp, 6, '.', '');
                                    } else {
                                        // $ventaE_temp = $fila['def_subtotal'];
                                        $ventaE_temp = ($fila['def_precio']) * (float)$cantidad;
                                        // $ventaE += $ventaE_temp;
                                        $ventaE += number_format($ventaE_temp, 6, '.', '');
                                    }
                            ?>
                                    <tr>
                                        <!-- Codigo de producto -->
                                        <td width="25%"><?= substr($fila['art_codigo'], -6, 6) ?></td>
                                        <td width="75%"><?= (mb_substr($fila['art_nombre'], 0, 20, 'UTF-8')) ?></td>
                                    </tr>
                                    <tr>
                                        <td width="25%">[<?php echo $fila['mep_nombre']; ?>]</td>
                                        <td width="22%"><?= number_format((float)$cantidad, 2) ?></td>
                                        <td width="26%"><?= $simbolo . number_format($precioU, 6) ?></td>
                                        <td width="26%">
                                            <?= ($ventaE_temp > 0) ? ($simbolo . number_format($ventaE_temp, 2)) : ''; ?>
                                            <?= ($ventaG_temp > 0) ? ($simbolo . number_format($ventaG_temp, 2)) : ''; ?>
                                        </td>
                                    </tr>
                            <?php
                                }
                            }
                            ?>
                        </table>
                    </td>
                </tr>
                <!-- Separador -->
                <tr>
                    <td colspan="2">--------------------------------------------------------</td>
                </tr>
                <tr>
                    <!-- Abreviaciones -->
                    <td colspan="2">
                        <table border="0">
                            <tr>
                                <td width="19%">Ventas:</td>
                                <td width="31%">Gravadas=G;</td>
                                <td width="27%">Exentas=E;</td>
                                <td width="23%">NoSuj=N;</td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <!-- Totales del Ticket -->
                <tr>
                    <td width="100%" colspan="2">
                        <table style="text-align: right;" border="0">
                            <tr>
                                <td>Total Articulos =</td>
                                <td><?= number_format($contadorProductos, 2) ?></td>
                            </tr>
                            <tr>
                                <td>SubTotal Exectas <?= $simbolo ?></td>
                                <td><?= number_format($ventaE, 2) ?></td>
                            </tr>
                            <tr>
                                <td>SubTotal Gravadas <?= $simbolo ?></td>
                                <td><?= number_format($ventaG, 2) ?></td>
                            </tr>
                            <tr>
                                <td>SubTotal No Sujetas <?= $simbolo ?></td>
                                <td><?= number_format($venta_no_sujeta, 2) ?></td>
                            </tr>
                            <?php if ($total_sub > 0) { ?>
                                <tr>
                                    <td>Subsidio <?= $simbolo ?></td>
                                    <td><?php echo number_format($total_sub, 2); ?></td>
                                </tr>
                            <?php } ?>
                            <tr>
                                <td>Total <?= $simbolo ?></td>
                                <td><?php
                                    $total_factura = ($datos_factura[0]['fac_total'] > 0 || $registro_factura['fac_id_origen_devolucion'] > 0) ? (number_format($datos_factura[0]['fac_total'] - $datos_factura[0]['fac_total_retencion'], 2)) : '';
                                    echo $total_factura;
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Recibe <?= $simbolo ?></td>
                                <td>
                                    <?php
                                    $cambio_efectivo = (isset($dt_cambio_efectivo[0]['abf_monto_entregado'])) ? number_format($dt_cambio_efectivo[0]['abf_monto_entregado'], 2) : '0.00';
                                    echo $cambio_efectivo;
                                    ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Cambio <?= $simbolo ?></td>
                                <td><?php
                                    $cambio_factura = number_format(($cambio_efectivo - $total_factura), 2);
                                    $cambio_factura_ab = (isset($dt_cambio_efectivo[0]['abf_monto_cambio'])) ? number_format($dt_cambio_efectivo[0]['abf_monto_cambio'], 2) : '0.00';
                                    if ($cambio_efectivo > 0) {
                                        echo ($cambio_factura != $cambio_factura_ab) ? $cambio_factura : $cambio_factura_ab;
                                    } else {
                                        echo (0 != $cambio_factura_ab) ? '0.00' : $cambio_factura_ab;
                                    }
                                    // echo $cambio_factura;
                                    ?>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <!-- Separador -->
                <tr>
                    <td colspan="2">--------------------------------------------------------</td>
                </tr>
                <tr>
                    <td colspan="2" width="100%">
                        <table border="0" style="text-align: left;">
                            <tr>
                                <td style="text-align: center;">
                                    <table>
                                        <tr>
                                            <td>
                                                Atendid@ por:
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <?= (isset($dt_caja[0]['emp_nombre'])) ? $dt_caja[0]['emp_nombre'] . ' ' . $dt_caja[0]['emp_apellido'] : '' ?>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <!-- Usuario asignado al cajero -->
                            <tr>
                                <td style="text-align: center;">

                                </td>
                            </tr>
                            <!-- Fecha de Facturacion del Ticket -->
                            <tr>
                                <td>
                                    Fecha: <?= formatear_fecha('d/m/Y', $datos_factura[0]['fac_fecha_fact']) ?>
                                </td>
                            </tr>
                            <!-- Hora de Emision del Ticket -->
                            <tr>
                                <td>
                                    Hora: <?= date("h:i A", strtotime($datos_factura[0]['fac_fecha_fact'])) ?>
                                </td>
                            </tr>
                            <!-- datos del cliente -->
                            <?php if ($registro_factura['fac_id_origen_devolucion'] > 0) { ?>
                                <tr>
                                    <td>
                                        Cliente: F:_______________________
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        Nombre: <?php if ($datos_factura[0]['fac_nombre_factura'] != '') {
                                                    echo $datos_factura[0]['fac_nombre_factura'];
                                                } else {
                                                    echo $datos_factura[0]['cliente'];
                                                } ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        NIT/DUI:
                                        <?php
                                        if ($datos_factura[0]['fac_dui_cliente_factura'] != '') {
                                            echo trim($datos_factura[0]['fac_dui_cliente_factura']);
                                        } else {
                                            echo (trim($datos_factura[0]['NIT']) != "") ? trim($datos_factura[0]['NIT']) : ((trim($datos_factura[0]['DUI']) != "") ? trim($datos_factura[0]['DUI']) : '________________________');
                                        }
                                        ?>
                                    </td>
                                </tr>
                            <?php  } ?>
                            <!-- Resolucion # -->
                            <tr>
                                <td>
                                    Resolución No: <?= (isset($dt_caja[0]['sef_resolucion'])) ? $dt_caja[0]['sef_resolucion'] : ''; ?>
                                </td>
                            </tr>
                            <!-- Fecha de Resolucion -->
                            <tr>
                                <td>
                                    Fecha Resolución: <?= (isset($dt_caja[0]['sef_fecha_resolucion'])) ? formatear_fecha('d-m-Y', $dt_caja[0]['sef_fecha_resolucion']) : '' ?>
                                </td>
                            </tr>
                            <!-- Rango -->
                            <tr>
                                <td>
                                    Rango Autorizado: del <?= (isset($dt_caja[0]['cxj_inicio'])) ? $dt_caja[0]['cxj_inicio'] : ''; ?> al <?= (isset($dt_caja[0]['cxj_fin'])) ? $dt_caja[0]['cxj_fin'] : ''; ?>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                            </tr>
                            <tr style="text-align: center;">
                                <td>
                                    GRACIAS POR SU COMPRA
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>