<?php
if (count($detalles) > 0) :
    $i = 1;
    foreach ($detalles as $det) :
        //  H:i:00
        $fecha_actual       = strtotime(date("d-m-Y", time()));
        $fecha_vencimiento  = strtotime($det['cmd_fecha_vencimiento']);

        // Procesar informacion
        $cliente       = $det['cli_nombre'] . ' ' . $det['cli_apellido'];
        $fecha_emision = (trim($det['cmd_fecha']) != "") ? formatear_fecha('d-m-Y', $det['cmd_fecha']) : '';
        $fecha_ven     = (trim($det['cmd_fecha_vencimiento']) != "") ? formatear_fecha('d-m-Y', $det['cmd_fecha_vencimiento']) : '';

        // Estados de los comprobantes
        $estado_comprobante = '';
        switch ($det['cmd_estado_comprobante']) {
            case 1:
                $estado_comprobante = 'Vigente';
                break;
            case 2:
                $estado_comprobante = 'Anulado';
                break;
            case $fecha_actual > $fecha_vencimiento &&  $det['cmd_estado_comprobante'] != 4 && $det['cmd_estado_comprobante'] == 3:
                $estado_comprobante = 'Vencido';
                break;
            case 4:
                $estado_comprobante = 'Canjeado';
                break;
        }
?>
        <tr>
            <td>
                <input type="checkbox" class="comprobante_check" name="chkComp[]" value="<?php echo $det['cmd_id']; ?>">
                <?php echo $i; ?>
            </td>
            <td><?php echo $cliente; ?></td>
            <td><?php echo $fecha_emision; ?></td>
            <td><?php echo $fecha_ven; ?></td>
            <td><?php echo $det['cmd_monto']; ?></td>
            <td><?php echo $estado_comprobante; ?>
            </td>
            <td>
                <div class="tools">
                    <div class="btn-group">
                        <button class="btn" type="button"><span class="icon16 icomoon-icon-cog-2"></span></button>
                        <button class="btn dropdown-toggle" data-toggle="dropdown"><span class="caret"></span></button>
                        <ul class="dropdown-menu">
                            <?php
                            if ($permisos['permite_editar'] == 1 && ($det['cmd_estado_comprobante'] != 2 && $det['cmd_estado_comprobante'] != 3 && $det['cmd_estado_comprobante'] != 4)) {
                            ?>
                                <li>
                                    <a href="<?php echo base_url(); ?>facturacion/facturar/editar_comprobante/<?php echo $det['cmd_id']; ?>"><span class="icon16 icomoon-icon-pencil-5"></span>
                                        Editar Comprobante</a>
                                </li>
                            <?php
                            }
                            ?>
                            <?php if ($det['cmd_estado_comprobante'] != 2 && $det['cmd_estado_comprobante'] != 3 && $det['cmd_estado_comprobante'] != 4) { ?>
                                <li>
                                    <a href="#modalAnular" data-id="<?php echo $det['cmd_id']; ?>" class="eliminar">
                                        <span aria-hidden="true" class="icomoon-icon-blocked"></span>
                                        Anular Comprobante
                                    </a>
                                </li>
                            <?php } ?>
                            <li>
                                <a href="#modal_duplicar" class="ver_en_modal_ajax_ duplicar" data-id="<?php echo $det['cmd_id']; ?>"><span class="icon16 icomoon-icon-copy-2"></span>
                                    Duplicar Comprobante</a>
                            </li>
                            <li>
                                <a target="_blank" href="<?php echo base_url(); ?>facturacion/facturar/imprimir_comprobante/<?php echo $det['cmd_id']; ?>"><span class="icon16 icomoon-icon-printer"></span>
                                    Imprimir</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </td>
        </tr>
<?php
        $i++;
    endforeach;
endif;
?>