<?php
$p = ($tipo_rep == "pdf") ? true : false;
$smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', '');
$esDte = $this->gsatelite->get_parametro_emp('SYS_TIPO_DE_FACTURACION');
if ($tipo_rep == "exc") {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=reporte_facturas.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="0">
            <tr>
                <td align="center" colspan="5" >
                    <h4><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de facturas
                    </h4>
                </td>
                <td><br /><?php echo date('d-m-Y H:i:s a'); ?></td>
                
            </tr>
        </table>
    </div>
    <?php
} ?>
<table border="1" class="responsive dynamicTable display table table-bordered dataTable" id="tabla_facturas" style="font-size:<?=($p)?7:11;?>px;">
    <thead>
        <tr>
            <th <?=($p && $esDte == 1)?'width="5%"':'';?>>Número <?= ($esDte == 1)?'Interno':''; ?></th>
            <?php if ($esDte == 1) { ?>
                <th <?=($p)?'width="9%"':'';?>>Código Generación</th>
                <th <?=($p)?'width="9%"':'';?>>Sello Recepción</th>
            <?php } ?>
            <th <?=($p && $esDte == 1)?'width="7%"':'';?>>Fecha Factura</th>
            <th <?=($p && $esDte == 1)?'width="7%"':'';?>>Fecha Contable</th>
            <th <?=($p && $esDte == 1)?'width="10%"':'';?>>Cliente</th>
            <th <?=($p && $esDte == 1)?'width="6%"':'';?>>Estado</th>
            <th <?=($p && $esDte == 1)?'width="6%"':'';?>>Total</th>
            <?php if ($esDte == 1) { ?>
                <th <?=($p)?'width="7%"':'';?>>Referencia Externa</th>
                <th <?=($p)?'width="7%"':'';?>>Estado DTE</th>
                <th <?=($p)?'width="20%"':'';?>>Información Extra</th>
            <?php } ?>
            <th <?=($p && $esDte == 1)?'width="7%"':'';?>>Vendedor</th>
            <?php if ($tipo_rep == "") {
                ?>
                <th>Detalles</th>
                <th>Imprimir</th>
                <?php 
            } ?>
        </tr>
    </thead>
    <tbody>
        <?php
        $total_facturas = 0;
        if (count($facturas) > 0) {
            foreach ($facturas as $fila) {
                // Estados de una factura
                $estado = '';
                if ($fila['fac_estado'] == 0) {
                    $estado = 'Anulada';
                } elseif ($fila['fac_estado'] == 1) {
                    $estado = 'Pendiente';
                } elseif ($fila['fac_estado'] == 2) {
                    $estado = 'Pagada';
                }
                if ($fila['fac_sello_recepcion'] != "") {
                    $sello = "Validada por Ministerio de Hacienda";
                } elseif ($fila['fac_numero_electronico_interno'] != "") {
                    $sello = "Esperando validar Minist. Hacienda";
                } else {
                    $sello = "Aun no transmitida para validación";
                }
                $id_factura = $fila["fac_id"];
                $total_facturas += $fila['fac_total'];
                $cliente  = $fila['cli_codigo'] . ' - ';
                $cliente .= ($fila["cli_personeria"] == 1) ? $fila["cli_nombre"] . " " . $fila["cli_apellido"] : $fila["cli_apellido"];
                $ext_inf = $this->gsatelite->get_tabla("ief_informacion_extra_factura", array("ief_id_fac" => $fila['fac_id'], "ief_impresion_factura" => 1));
                ?>
                <tr nobr="true">
                    <td <?=($p && $esDte == 1)?'width="5%"':'';?> ><?= $fila['fac_numero'] ?></td>
                    <?php if ($esDte == 1) {?>
                        <td <?=($p)?'width="9%"':'';?>><?= $fila['fac_codigo_generacion'] ?></td>
                        <td <?=($p)?'width="9%"':'';?>><?= $fila['fac_sello_recepcion'] ?></td>
                        <?php 
                    } ?>
                    <td <?=($p && $esDte == 1)?'width="7%"':'';?>><?php if ($tipo_rep == ""): ?>
                        <span style="display:none;"><?=formatear_fecha('Ymd',$fila['fac_fecha_fact'])?>
                        </span><?php endif ?><?=formatear_fecha('d-m-Y',$fila['fac_fecha_fact'])?>
                    </td>
                    <td <?=($p && $esDte == 1)?'width="7%"':'';?>><?php if ($tipo_rep == ""): ?>
                        <span style="display:none;"><?=formatear_fecha('Ymd',$fila['fac_fecha_cont'])?></span>
                        </span><?php endif ?><?=formatear_fecha('d-m-Y',$fila['fac_fecha_cont'])?>
                    </td>
                    <td <?=($p && $esDte == 1)?'width="10%"':'';?>><?= $cliente ?></td>
                    <td <?=($p && $esDte == 1)?'width="6%"':'';?>><?= $estado ?></td>
                    <td <?=($p && $esDte == 1)?'width="6%"':'';?> style="text-align:right;"><?= $smb . number_format($fila['fac_total'], 2) ?></td>
                    <?php if ($esDte == 1) {
                        $ext_inf = $this->gsatelite->get_tabla("ief_informacion_extra_factura", array("ief_id_fac" => $fila['fac_id'], "ief_impresion_factura" => 1));
                        ?>
                        <td <?=($p)?'width="7%"':'';?>><?= $fila['fac_referencia_externa'] ?></td>
                        <td <?=($p)?'width="7%"':'';?>><?= $sello ?></td>
                        <td <?=($p)?'width="20%"':'';?> style="padding: 0;"><?php if (count($ext_inf) > 0) { ?><table style="font-size:<?=($p)?7:10;?>px;" border="0">
                                    <?php
                                    foreach ($ext_inf as $k => $f) {
                                        if (trim($f['ief_valor_campo']) != "") {
                                            switch ($f['ief_tipo_dato']) {
                                                case '2':
                                                $valor_campo = intval($f['ief_valor_campo']);
                                                break;
                                                case '3':
                                                $valor_campo = floatval($f['ief_valor_campo']);
                                                break;
                                                case '4':
                                                $valor_campo = $smb . number_format($f['ief_valor_campo'], 2);
                                                break;
                                                case '5':
                                                $valor_campo = formatear_fecha('d/m/Y', $f['ief_valor_campo']);
                                                break;
                                                default:
                                                $valor_campo = $f['ief_valor_campo'];
                                                break;
                                            } ?>
                                            <tr><td style="padding:0.5;" width="45%"><?=$f['ief_etiqueta_impresion']?>:</td><td style="padding:0.3;" width="55%"><?=$valor_campo?></td></tr>
                                            <?php
                                        }
                                    } ?>
                                </table>
                                <?php 
                            } ?>
                        </td>
                        <?php 
                    } ?>
                    <td <?=($p && $esDte == 1)?'width="7%"':'';?>><?= $fila["ven_codigo"] . " - " . $fila["ven_nombre"] . " " . $fila["ven_apellidos"] ?></td>
                    <?php if ($tipo_rep == "") { ?>
                        <td>
                            <a href="#divform2" class="linker2" onclick="javascript:clicker2(<?= $fila["fac_id"] ?>);" name="<?= $fila["fac_id"] ?>">
                                <span class="icon16 icon16 icomoon-icon-pencil-5">  Ver</span>
                            </a>
                        </td>
                        <td>
                            <a target="_blank" href="<?= base_url("facturacion/facturar/imprimir_factura/$id_factura") ?>">
                                <span class="icomoon-icon-printer-2"></span>
                            </a>
                            <?php
                            if (isset($fila['def_usu_autoriza_descuento']) && $fila['def_usu_autoriza_descuento'] != null) {
                                echo '<a target="_blank" href="' . base_url("facturacion/reportes/reporte_descuentos/$id_factura") . '">
                                <span class="icomoon-icon-book-2"></span>
                                </a>';
                            } ?>
                        </td>
                    <?php } ?>
                </tr>
                <?php 
            }
        } else {
            if ($tipo_rep != "") {
                ?>
                <tr>
                    <td style="text-align: center;" colspan="<?= ($esDte == 1) ? 12 : 7;?>">No se encontraron registros</td>
                </tr>
                <?php
            }
        }
        ?>
    </tbody>
    <?php if (count($facturas) > 0) { ?>
    <tfoot>
        <tr>
            <td style="text-align:right;" colspan="<?=($esDte == 1) ? 7 : 5;?>"><b>Total</b></td>
            <td><b>$<span id="lblFooterTotal"><?php echo number_format($total_facturas, 2); ?></span></b></td>
            <td colspan="<?=($tipo_rep == "") ? (($esDte == 1) ? 6 : 3) : (($esDte == 1) ? 4 : 1);?>" ></td>
        </tr>
    </tfoot>
    <?php  } ?>
</table>