<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                       Reporte de ingresos y bajas de personal
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    ?>    
    <table border="0" style="text-align: left;">
        <tr>
            <td <?= ($tipo_reporte == 'pdf') ? 'style="width: 13%;"':'';?>><b>Tipo:</b></td>
            <td <?= ($tipo_reporte == 'pdf') ? 'style="width: 23%;"':'';?>><?php echo $tipo_nombre; ?></td>       
            <td <?= ($tipo_reporte == 'pdf') ? 'style="width: 12%;"':'';?>><b>Desde:</b></td>
            <td <?= ($tipo_reporte == 'pdf') ? 'style="width: 20%;"':'';?>><?php echo formatear_fecha('d-m-Y',$fecha_inicio); ?></td>             
            <td <?= ($tipo_reporte == 'pdf') ? 'style="width: 12%;"':'';?>><b>Hasta:</b></td>
            <td <?= ($tipo_reporte == 'pdf') ? 'style="width: 20%;"':'';?>><?php echo formatear_fecha('d-m-Y',$fecha_fin); ?></td>            
        </tr>
        <tr><td colspan="6"></td></tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>Código empleado</th>
                <th>Empleada/o</th>
                <th>Empresa</th>
                <th>Plaza / Cargo Funcional</th>
                <th>Área</th>
                <th>Fecha ingreso</th>
                <th>Fecha retiro</th>
                <th>Categoría</th>
                <th>Motivo</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i      = 1;
        $total  = 0;
        foreach ($reporte as $row):
            $total          = $total + $row['emp_salario'];
            $tipo           = ($row['emp_estado'] ==1 )?"Ingreso":"Retiro";
            $motivo         = ($tipo_filtro == 1)?"":$row['rte_motivo_retiro'];
            $fecha_retiro   = ($tipo_filtro == 1)?"":formatear_fecha('d-m-Y',$row['rte_fecha_retiro']);
            $plaza          = ($row['plz_nombre'] =="")?"":$row['plz_nombre'];
            ?>
            <tr class="dato" nobr="true">
                <td><?php echo $row['emp_codigo']; ?></td>
                <td><?php echo $row['emp_nombre'] . " ". $row['emp_apellido'] ; ?></td>
                <td><?php echo $row['emr_nombre']; ?></td>
                <td><?php echo $plaza; ?></td>
                <td><?php echo $row['are_nombre']; ?></td>
                <td>
                    <?php if ($tipo_reporte == ''): ?>
                        <span style="display: none; visibility: hidden;"><?= formatear_fecha('Ymd',$row['emp_fecha_contrato']); ?></span>
                    <?php endif ?>
                    <?= formatear_fecha('d-m-Y',$row['emp_fecha_contrato']); ?>
                </td>
                <td>
                    <?php if ($tipo_reporte == '' && $fecha_retiro != ''): ?>
                        <span style="display: none; visibility: hidden;"><?= formatear_fecha('Ymd',$row['rte_fecha_retiro']); ?></span>
                    <?php endif ?>
                    <?php echo $fecha_retiro; ?>
                </td>
                <td><?php echo $tipo;?></td>           
                <td><?php echo $motivo; ?></td>
            </tr>
            <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody> 
    </table>
<?php } ?>

