<?php
// Impresion de EXCEL
if($tipo_reporte == 'excel'){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if($tipo_reporte != '') { 
    ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
        }
        .tabla th{
            vertical-align: middle;
            text-align: center;
        }
        .tabla td{
            vertical-align: middle;
        }
    </style>
    <?php 
} 

if($tipo_reporte == 'excel') {
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="6" >
                    <h4><?php echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />Reporte de Familiares por Personal</h4>
                </td>
            </tr>
        </table>
    </div>
    <br>
    <?php 
}
if($tipo_reporte != '') { 
    ?>
    <table class="tabla" cellpadding="1" border="1" <?php echo ($tipo_reporte == 'pdf') ? 'style="font-size:7pt;"' : ''; ?> >
        <thead>
            <tr style="background-color: #C0C0C0;">
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="6.5%"' : ''; ?>><b>Código Empleada/o</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><b>Nombre</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><b>Apellido</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><b>Sucursal</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="8.5%"' : ''; ?>><b>Departamento</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><b>Dirección</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="8.5%"' : ''; ?>><b>Nombre del Familiar</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><b>Parentesco</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><b>Fecha de Nacimiento</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="5%"' : ''; ?>><b>Edad</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><b>Depende del Empleada/o</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><b>Reside con Empleada/o</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><b>Beneficiario</b></th>
                <th <?php echo ($tipo_reporte == 'pdf') ? 'width="6.5%"' : ''; ?>><b>% Beneficio</b></th>
            </tr>
        </thead>
        <tbody id="consulta_table">
            <?php 
} 


if (count($empleados) > 0) { 
    foreach ($empleados as $key => $value) { 
        ?>
        <tr>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="6.5%"' : ''; ?>><?php echo $value['emp_codigo']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><?php echo $value['emp_nombre']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><?php echo $value['emp_apellido']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><?php echo $value['suc_nombre']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="8.5%"' : ''; ?>><?php echo $value['are_nombre']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><?php echo $value['padre']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="8.5%"' : ''; ?>><?php echo $value['fam_nombre'] . ' ' . $value['fam_apellido']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><?php echo $value['pat_nombre']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><?php echo formatear_fecha('d-m-Y', $value['fam_fecha_nacimiento']); ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="5%"' : ''; ?>><?php echo $value['edad']; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><?php echo ($value['fam_dependiente'] > 0) ? 'Sí' : 'No'; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7%"' : ''; ?>><?php echo ($value['fam_reside_empleado'] > 0) ? 'Sí' : 'No'; ?></td>
            <td <?php echo ($tipo_reporte == 'pdf') ? 'width="7.5%"' : ''; ?>><?php echo ($value['fam_beneficiario'] > 0) ? 'Sí' : 'No'; ?></td>
            <td style="text-align: right;" <?php echo ($tipo_reporte == 'pdf') ? 'width="6.5%"' : ''; ?>>
                <?php echo ($value['fam_beneficiario'] > 0) ? number_format($value['fam_porcentaje_beneficio'], 2) . ' %' :''; ?>
            </td>
        </tr>
        <?php    
    } 
}

if($tipo_reporte != '') { 
    ?>
        </tbody> 
    </table>
    <?php 
} 
?>