<?php 
if(isset($excel)){
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}?>
<style type="text/css">
    .tabla{
        font-weight: normal !important;
        border:1px solid black;
    }

    .tabla th{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }

    .tabla td{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }

</style>
<?php if(isset($excel) && $excel==1) {?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td colspan="2">
                    <h4> Reporte de Empleadas/os por Estado</h4>
                </td>
            </tr>
            <br><br>
            <tr>
                <td><h4>Estado: </h4></td>
                <td>
                    <?php
                    if($estado != '') {
                        echo ($estado==1)?'Activo':'Inactivo';
                    } else {
                        echo 'No seleccionado';
                    }
                    ?>
                </td>
            </tr>
            <tr>
                <td><h4>Tipo de Contrato:</h4></td>
                <td>
                    <?php
                    if($contrato != '') {
                        foreach ($tipo_contratos as $key => $value) {
                            if ($contrato == $value['tic_id']) {
                                echo $value['tic_nombre'];
                            } 
                        }
                    } else {
                        echo 'No Seleccionado';
                    }
                    ?>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<br><br>
<table class="tabla" cellpadding="2">
    <thead>
        <tr style="background-color: #C0C0C0;">
            <th style="font-weight:bold;font-size:9px">Código Empleada/o</th>
            <th style="font-weight:bold;font-size:9px">Empleada/o</th>
            <th style="font-weight:bold;font-size:9px">Área</th>
            <th style="font-weight:bold;font-size:9px">Plaza / Cargo Funcional</th>
            <th style="font-weight:bold;font-size:9px">Tipo de Contrato</th>
            <th style="font-weight:bold;font-size:9px">Fecha de Ingreso</th>
            <th style="font-weight:bold;font-size:9px">Estado</th>

        </tr>
    </thead>
    <tbody id="consulta_table">
        <?php if (count($empleados)>0) { ?>
            <?php foreach ($empleados as $key => $value) { ?>
                <tr nobr="true">
                    <td><?php echo $value['emp_codigo']; ?></td>
                    <td><?php echo $value['emp_nombre'].' '.$value['emp_apellido']; ?></td>
                    <td><?php echo $value['are_nombre']; ?></td>
                    <td><?php echo $value['plz_nombre']; ?></td>
                    <td><?php echo $value['tic_nombre']; ?></td>
                    <td><?php echo formatear_fecha('d-m-Y', $value['emp_fecha_contrato']); ?></td>
                    <td><?php echo ($value['emp_estado']==1)?'Activo':'Inactivo'; ?></td>
                </tr>
            <?php    } ?>
        <?php } else {  ?>
            <tr><td colspan="8" style="text-align:center;">No se encontrarón registros</td></tr>
        <?php } ?>
    </tbody> 
</table>
    

