<?php
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=Reporte_empleados.xls"); 
header("Pragma: no-cache");
header("Expires: 0");
$docs_especificos = false;
$param = json_decode(trim($this->gsatelite->get_parametro('SYS_TIPO_DOC_EMP')));
if (is_object($param)) {
    $tde_ids = (count((Array)$param) > 0) ? (Array)$param : array(0);
             $this->db->where_in('tde_id', $tde_ids);
    $tipos = $this->gsatelite->get_tabla('tde_tipo_documento');
    if (count($tipos) > 0) {
        $docs_especificos = true;
    }
}
?>
<meta charset="utf-8" />
<style type="text/css">
    .tabla{
        font-weight: normal !important;
         border:1px solid black;
    }

    .tabla th{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
        background-color: #D7E5F7;
        font-size:9px;
        font-weight: bold;
    }

    .tabla td{
        border:1px solid black;
        vertical-align: middle;
        text-align: center;
    }
    .text{
            mso-number-format:"\@";/*force text*/
        }
</style>
<?php if($columnas) {
    if($html!=''){
        echo $html;
    }
    ?>
    <table border="0" style="font-size:8px;" id="tabla_filtros">
        <tr>
            <td>Sucursal: <?php echo $nombre_sucursal;?></td>    
        </tr>
    </table>
    <table border="1" style="font-size:12px;" class="responsive dynamicTable display table table-bordered dataTable" id="tabla_consulta">
        <thead>
            <tr>
                <?php
                echo (in_array('emp_id', $columnas_reporte))? "<th>ID</th>":"";
                echo (in_array('emp_codigo', $columnas_reporte))? "<th>Código</th>":"";
                echo (in_array('emp_codigo_referencia', $columnas_reporte))? "<th>Código Referencia</th>":"";
                echo (in_array('emp_nombre', $columnas_reporte))? "<th>Nombre</th>":"";
                echo (in_array('emp_apellido', $columnas_reporte))? "<th>Apellido</th>":"";
                echo (in_array('esc_nombre', $columnas_reporte))? "<th>Estado&nbsp;Civil</th>":"";
                echo (in_array('gen_nombre', $columnas_reporte))? "<th>Género</th>":"";
                echo (in_array('emp_direccion', $columnas_reporte))? "<th>Dirección</th>":"";
                echo (in_array('cxp_correo', $columnas_reporte))? "<th>Correo Electrónico</th>":"";
                echo (in_array('emp_fecha_nac', $columnas_reporte))? "<th>Fecha Nacimiento</th>":"";
                echo (in_array('Anos_edad', $columnas_reporte))? "<th>Edad</th>":"";
                echo (in_array('emp_lugar_nac', $columnas_reporte))? "<th>Lugar Nacimiento</th>":"";
                echo (in_array('nac_nombre', $columnas_reporte))? "<th>Nacionalidad</th>":"";
                echo (in_array('estado_empleado', $columnas_reporte))? "<th>Estado</th>":"";
                echo (in_array('pro_nombre', $columnas_reporte))? "<th>Profesión</th>":"";
                echo (in_array('emr_nombre', $columnas_reporte))? "<th>Empresa</th>":"";
                echo (in_array('suc_nombre', $columnas_reporte))? "<th>Sucursal/Plantel</th>":"";
                echo (in_array('nia_nombre', $columnas_reporte))? "<th>Nivel Área</th>":"";
                echo (in_array('are_nombre', $columnas_reporte))? "<th>Departamento</th>":"";
                echo (in_array('area_padre_padre', $columnas_reporte))? "<th>Gerencia</th>":"";
                echo (in_array('area_padre', $columnas_reporte))? "<th>Dirección</th>":"";
                echo (in_array('pto_nombre', $columnas_reporte))? "<th>Puesto</th>":"";
                echo (in_array('plz_nombre', $columnas_reporte))? "<th>Plaza / Cargo Funcional</th>":"";
                echo (in_array('ubp_nombre', $columnas_reporte))? "<th>Ubicación</th>":"";
                echo (in_array('plz_ubicacion_especifica', $columnas_reporte))? "<th>Ubicación especifica</th>":"";
                echo (in_array('plaza_padre', $columnas_reporte))? "<th>Plaza / Cargo Funcional dependencia</th>":"";
                echo (in_array('emp_salario', $columnas_reporte))? "<th>Salario</th>":"";
                echo (in_array('emp_salario_hora', $columnas_reporte))? "<th>Salario Hora</th>":"";
                echo (in_array('emp_salario_hora_nocturna', $columnas_reporte))? "<th>Horas Extras Fijas</th>":"";
                echo (in_array('emp_metodo_pago', $columnas_reporte))? "<th>Forma Pago Salario</th>":"";
                echo (in_array('emp_fecha_ult_vacacion', $columnas_reporte))? "<th>Último Pago Vacación</th>":"";
                echo (in_array('emp_fecha_ult_liquidacion', $columnas_reporte))? "<th>Última Liquidación</th>":"";
                echo (in_array('emp_fecha_ult_aguinaldo', $columnas_reporte))? "<th>Último Aguinaldo</th>":"";
                echo (in_array('emp_fecha_antiguedad', $columnas_reporte))? "<th>Fecha Antigüedad</th>":"";
                echo (in_array('emp_url_foto', $columnas_reporte))? "<th>¿Posee Foto?</th>":"";
                echo (in_array('tpl_nombre', $columnas_reporte))? "<th>Tipo Planilla</th>":"";
                echo (in_array('seguro_empleado', $columnas_reporte))? "<th>Seguros</th>":"";
                if ($docs_especificos) {
                    foreach ($tipos as $key => $val) {
                        echo (in_array('documentos_empleado_' . $val['tde_id'], $columnas_reporte)) ? "<th>" . $val['tde_nombre'] . "</th>" : "";
                    }
                } else {
                    echo (in_array('documentos_empleado', $columnas_reporte))? "<th>Documentos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>":"";
                }
                echo (in_array('telefonos_empleado', $columnas_reporte))? "<th>Teléfonos&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</th>":"";
                echo (in_array('afp_nombre', $columnas_reporte))? "<th>NUP</th>":"";
                echo (in_array('emp_afp', $columnas_reporte))? "<th>Seguros</th>":"";
                echo (in_array('emp_seguro', $columnas_reporte))? "<th>Número ISSS</th>":"";
                echo (in_array('ban_nombre', $columnas_reporte))? "<th>Banco</th>":"";
                echo (in_array('emp_numero_cuenta', $columnas_reporte))? "<th>Cta Bancaria</th>":"";
                echo (in_array('tic_nombre', $columnas_reporte))? "<th>Tipo Contrato</th>":"";
                echo (in_array('emp_fecha_contrato', $columnas_reporte))? "<th>Fecha&nbsp;Contratación</th>":"";
                echo (in_array('zon_nombre', $columnas_reporte))? '<th>Zona Residencia</th>':'';
                echo (in_array('tiv_nombre', $columnas_reporte))? '<th>Tipo Vivienda</th>':'';
                echo (in_array('tps_nombre', $columnas_reporte))? '<th>Tipo Salario</th>':'';
                echo (in_array('fnr_nombre', $columnas_reporte))? '<th>Fuente Reclutamiento</th>':'';
                echo (in_array('reingreso_empleado', $columnas_reporte))? '<th>Reingreso</th>':'';
                echo (in_array('emp_organigrama', $columnas_reporte))? '<th>Organigrama</th>':'';
                echo (in_array('emp_fecha_mod', $columnas_reporte))? '<th>Última Actualización</th>':'';
                echo (in_array('numero_hijos', $columnas_reporte))? '<th>Número Hijos</th>':'';
                ?>
            </tr>
        </thead>
        <tbody>
            <?php 
            $cant_mujeres=0;
            $cant_hombre=0;
            $cant_na=0;
            foreach ($consulta as $fila) {
                $id_empleado=$fila["emp_id"];
                $fecha_nac = ($fila["emp_fecha_nac"])? date("d-m-Y",strtotime(@$fila['emp_fecha_nac'])):"";
                $area_dept = @$fila["area_hija"];
                $area_dir  = @$fila["area_padre"];
                $area_ger = @$fila["area_padre_padre"];
                if ($fila['nia_area_hija'] == 1){ //direccion
                    $area_dir = $area_dept;
                    $area_dept = $area_ger = "";
                } elseif ($fila['nia_area_hija'] == 2) { // gerencia
                    $area_ger = $area_dept;
                    $area_dir = @$fila["area_padre"];
                    $area_dept = "";
                }
                $ultima_vacacion = ($fila["emp_fecha_ult_vacacion"] != "") ? formatear_fecha('d-m-Y', $fila["emp_fecha_ult_vacacion"]) : "";
                $ultima_liquidacion = ($fila["emp_fecha_ult_liquidacion"] != "") ? formatear_fecha('d-m-Y', $fila["emp_fecha_ult_liquidacion"]) : "";
                $ultimo_aguinaldo = ($fila["emp_fecha_ult_aguinaldo"] != "") ? formatear_fecha('d-m-Y', $fila["emp_fecha_ult_aguinaldo"]) : "";
                $fecha_antiguedad = ($fila["emp_fecha_antiguedad"] != "") ? formatear_fecha('d-m-Y', $fila["emp_fecha_antiguedad"]) : "";
                $posee_foto = ($fila["emp_url_foto"] != "") ? 'Sí' : 'No';
                if ($fila["emp_metodo_pago"] == 1) {
                    $forma_pago_salario = 'Transferencia Bancaria';
                } elseif ($fila["emp_metodo_pago"] == 2) {
                    $forma_pago_salario = 'cheque';
                } else {
                    $forma_pago_salario = 'Efectivo';
                }
                echo '<tr>';
                echo (in_array('emp_id', $columnas_reporte))? '<td>'.@$fila['emp_id'].'</td>':'';
                echo (in_array('emp_codigo', $columnas_reporte))? '<td class="text">'.@$fila['emp_codigo'].'</td>':'';
                echo (in_array('emp_codigo_referencia', $columnas_reporte))? '<td class="text">'.@$fila['emp_codigo_referencia'].'</td>':'';
                echo (in_array('emp_nombre', $columnas_reporte))? '<td>'.@$fila["emp_nombre"].'</td>':'';
                echo (in_array('emp_apellido', $columnas_reporte))? '<td>'.@$fila["emp_apellido"].'</td>':'';
                echo (in_array('esc_nombre', $columnas_reporte))? '<td>'.@$fila["esc_nombre"].'</td>':'';
                echo (in_array('gen_nombre', $columnas_reporte))? '<td>'.@$fila["gen_nombre"].'</td>':'';
                echo (in_array('emp_direccion', $columnas_reporte))? '<td>'.@$fila["emp_direccion"].'</td>':'';
                echo (in_array('cxp_correo', $columnas_reporte))? '<td>'.@$fila["correo_empleado"].'</td>':'';
                echo (in_array('emp_fecha_nac', $columnas_reporte))? '<td>&nbsp;'.$fecha_nac.'</td>':'';
                echo (in_array('Anos_edad', $columnas_reporte))? '<td>'.@$fila["Anos_edad"].'</td>':'';
                echo (in_array('emp_lugar_nac', $columnas_reporte))? '<td>'.@$fila["emp_lugar_nac"].'</td>':'';
                echo (in_array('nac_nombre', $columnas_reporte))? '<td>'.@$fila["pai_nacionalidad"].'</td>':'';
                echo (in_array('estado_empleado', $columnas_reporte))? '<td>'.@$fila["estado_empleado"].'</td>':'';
                echo (in_array('pro_nombre', $columnas_reporte))? '<td>'.@$fila["pro_nombre"].'</td>':'';
                echo (in_array('emr_nombre', $columnas_reporte))? '<td>'.@$fila["emr_nombre"].'</td>':'';
                echo (in_array('suc_nombre', $columnas_reporte))? '<td>'.@$fila["suc_nombre"].'</td>':'';
                echo (in_array('nia_nombre', $columnas_reporte))? '<td>'.@$fila["nia_nombre"].'</td>':'';
                echo (in_array('are_nombre', $columnas_reporte))? '<td>'.$area_dept.'</td>':'';
                echo (in_array('area_padre', $columnas_reporte))? '<td>'.$area_ger.'</td>':'';
                echo (in_array('area_padre_padre', $columnas_reporte))? '<td>'.$area_dir.'</td>':'';
                echo (in_array('pto_nombre', $columnas_reporte))? '<td>'.@$fila["pto_nombre"].'</td>':'';
                echo (in_array('plz_nombre', $columnas_reporte))? '<td>'.@$fila["nombre_plaza"].'</td>':'';
                echo (in_array('ubp_nombre', $columnas_reporte))? '<td>'.@$fila["ubp_nombre"].'</td>':'';
                echo (in_array('plz_ubicacion_especifica', $columnas_reporte))? '<td>'.@$fila["plz_ubicacion_especifica"].'</td>':'';
                echo (in_array('plaza_padre', $columnas_reporte))? '<td>'.@$fila["plaza_padre"].'</td>':'';
                echo (in_array('emp_salario', $columnas_reporte))? '<td>'.@$fila["emp_salario"].'</td>':'';
                echo (in_array('emp_salario_hora', $columnas_reporte))? '<td>'.@$fila["emp_salario_hora"].'</td>':'';
                echo (in_array('emp_salario_hora_nocturna', $columnas_reporte))? '<td>'.@$fila["emp_salario_hora_nocturna"].'</td>':"";
                echo (in_array('emp_metodo_pago', $columnas_reporte))? '<td>'.$forma_pago_salario.'</td>':"";
                echo (in_array('emp_fecha_ult_vacacion', $columnas_reporte))? '<td>'.$ultima_vacacion.'</td>':"";
                echo (in_array('emp_fecha_ult_liquidacion', $columnas_reporte))? '<td>'.$ultima_liquidacion.'</td>':"";
                echo (in_array('emp_fecha_ult_aguinaldo', $columnas_reporte))? '<td>'.$ultimo_aguinaldo.'</td>':"";
                echo (in_array('emp_fecha_antiguedad', $columnas_reporte))? '<td>'.$fecha_antiguedad.'</td>':"";
                echo (in_array('emp_url_foto', $columnas_reporte))? '<td>'.$posee_foto.'</td>':"";
                echo (in_array('tpl_nombre', $columnas_reporte))? '<td>'.@$fila["tpl_nombre"].'</td>':'';
                echo (in_array('seguro_empleado', $columnas_reporte))? '<td>'.@$fila["seguro_empleado"].'</td>':'';
                if ($docs_especificos) {
                    $valores = array();
                    $docs = explode('&&', $fila["param_docs_empleado"]);
                    foreach ($docs as $k => $v) {
                        $x = explode('##', $v);
                        $valores[$x[0]] = $x[1];
                    }
                    foreach ($tipos as $key => $val) {
                        echo (in_array('documentos_empleado_' . $val['tde_id'], $columnas_reporte)) ? '<td>' . $valores[$val['tde_id']] . '</td>' : "";
                    }
                } else {
                    echo (in_array('documentos_empleado', $columnas_reporte)) ? '<td>'.str_replace(',', '<br />', @$fila["documentos_empleado"]).'</td>' : '';
                }
                echo (in_array('telefonos_empleado', $columnas_reporte))? '<td>'.str_replace(',', '<br />', @$fila["telefonos_empleado"]).'</td>':'';
                echo (in_array('afp_nombre', $columnas_reporte))? '<td>'.@$fila["afp_nombre"].'</td>':'';
                echo (in_array('emp_afp', $columnas_reporte))? '<td class="text">'.@$fila["emp_afp"].'</td>':'';
                echo (in_array('emp_seguro', $columnas_reporte))? '<td class="text">'.@$fila["emp_seguro"].'</td>':'';
                echo (in_array('ban_nombre', $columnas_reporte))? '<td>'.@$fila["ban_nombre"].'</td>':'';
                echo (in_array('emp_numero_cuenta', $columnas_reporte))? '<td class="text">'.@$fila["emp_numero_cuenta"].'</td>':'';
                echo (in_array('tic_nombre', $columnas_reporte))? '<td>'.@$fila["tic_nombre"].'</td>':'';
                echo (in_array('emp_fecha_contrato', $columnas_reporte))? '<td>'.date("d-m-Y",strtotime(@$fila['emp_fecha_contrato'])).'</td>':'';
                echo (in_array('zon_nombre', $columnas_reporte))? '<td>'.@$fila["zon_nombre"].'</td>':'';
                echo (in_array('tiv_nombre', $columnas_reporte))? '<td>'.@$fila["tiv_nombre"].'</td>':'';
                echo (in_array('tps_nombre', $columnas_reporte))? '<td>'.@$fila["tps_nombre"].'</td>':'';
                echo (in_array('fnr_nombre', $columnas_reporte))? '<td>'.@$fila["fnr_nombre"].'</td>':'';
                echo (in_array('reingreso_empleado', $columnas_reporte))? '<td>'.@$fila["reingreso_empleado"].'</td>':'';
                echo (in_array('emp_organigrama', $columnas_reporte))? '<td>'.@$fila["org_nombre"].'</td>':'';
                echo (in_array('emp_fecha_mod', $columnas_reporte))? '<td>'.formatear_fecha("d-m-Y h:i A", @$fila['emp_fecha_mod']).'</td>':''; 
                echo (in_array('numero_hijos', $columnas_reporte))? '<td>'.@$fila["numero_hijos"].'</td>':'';
                echo '</tr>'; 
                if(strtolower($fila['gen_nombre'])=='femenino'){
                    $cant_mujeres++;
                }elseif(strtolower($fila['gen_nombre'])=='masculino'){
                    $cant_hombre++;
                }else{
                    $cant_na++;
                }
            }
            if(count($consulta)<=0) {   ?>
                <tr>
                    <td colspan="<?php echo count($columnas_reporte); ?>" style="text-align:center;">Sin registros</td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
<?php } else {  ?>
    <table>
        <tr>
            <td>
                <h2>SIN COLUMNAS PARA MOSTRAR</h2><br />
                <h4>Verificar que se haya seleccionado al menos una columna</h4>
            </td>
        </tr>
    </table>
<?php } 

if(isset($filtro) && $filtro=='emp_id_gen'){
    ?>
    <br><br><br>
    <table class="responsive dynamicTable display table table-bordered dataTable" cellpadding='2' border='1' >
        <thead>
            <tr>
                <th colspan="2"><b>Totales</b></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><b>Masculino</b></td>
                <td><?php echo $cant_hombre; ?></td>
            </tr>
            <tr>
                <td><b>Femenino</b></td>
                <td><?php echo $cant_mujeres; ?></td>
            </tr>
            <tr>
                <td><b>N/A</b></td>
                <td><?php echo $cant_na; ?></td>
            </tr>
        </tbody>
    </table>
    <?php
}   ?>