<?php
/**
 * @author Elman Ortiz
 * @copyright 2017
 */
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>
<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="8" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de traslados, promociones y niveles
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if($tipo_reporte == 'pdf'):?>
<style type="text/css">
td { font-family: courier; font-size: 9px; }
</style>
<?php endif;?>

<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'):?>
<table border="0" width="100%">
  <tr>    
    <td><?php echo $tipo_promociontext;?></td>
    <td><?php echo $plazatext;?></td>
    <td><?php echo $fecha_initext;?></td>
    <td><?php echo $fecha_fintext;?></td>    
  </tr>
</table>
<?php endif;?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered"  aria-describedby="table_2_info">
    <thead >
        <tr nobr="true" >
            <th width="9%">Tipo</th>
            <th width="7%">Código Empleada/o</th>
            <th width="10%">Nombre</th>
            <th width="10%">Apellido</th>
            <th width="7%">Empresa</th>
            <th width="9%">Fecha Promoción</th>
            <th width="8%">Plaza / Cargo Funcional Anterior</th>
            <th width="8%">Nuevo Plaza / Cargo Funcional</th>
            <th width="8%">Salario Anterior</th>
            <th width="8%">Nuevo Salario</th>
            <th width="8%">Área Anterior</th>
            <th width="8%">Nueva Área</th>
        </tr>
    </thead>
    <tbody>
        <?php
        if(count($reporte) > 0){
            $idemp_inicial = $reporte[0]['emp_id'];
            for ($i=0; $i < count($reporte); $i++) {
                $sueldo_anterior = $reporte[$i]['pps_salario'];
                $plaza_anterior = $reporte[$i]['plz_nombre'];
                if (trim($reporte[$i]['datos_anteriores']) != "") {
                    $datos_extra = explode('##', $reporte[$i]['datos_anteriores']);
                    $sueldo_anterior = $datos_extra[0];
                    $plaza_anterior = $datos_extra[1];
                }
                if($idemp_inicial == $reporte[$i]['emp_id']){
                    $control = ($i==0) ? 0 : $i-1;
                }else{
                    //Reiniciar el id con el cual se identifica si es el mismo empleado
                    $idemp_inicial = $reporte[$i]['emp_id'];
                    $control = $i;
                }
                ?>
                <tr nobr="true">
                    <td width="9%"><?php echo $reporte[$i]['tipo_promocion']?></td>
                    <td width="7%"><?php echo $reporte[$i]['emp_codigo']?></td>
                    <td width="10%"><?php echo $reporte[$i]['emp_nombre']?></td>
                    <td width="10%"><?php echo $reporte[$i]['emp_apellido']?></td>
                    <td width="7%"><?php echo $reporte[$i]['emr_nombre']?></td>
                    <td width="9%">
                        <?php if ($tipo_reporte == ''): ?>                            
                            <span style="visibility: hidden; display: none;"><?php echo formatear_fecha('Ymd',$reporte[$i]['pps_fecha_efectiva']); ?></span>
                        <?php endif ?>
                        <span><?php echo formatear_fecha('d-m-Y',$reporte[$i]['pps_fecha_efectiva']); ?></span>
                    </td>
                    <td width="8%"><?php echo $plaza_anterior;//$reporte[$control]['plz_nombre']?></td><!--Nombre de la plaza anterior-->
                    <td width="8%"><?php echo $reporte[$i]['plz_nombre']?></td>
                    <td width="8%" style="text-align: right;"><?php echo $sueldo_anterior;//$reporte[$control]['pps_salario']?></td><!--Nombre de la plaza anterior-->                      
                    <td width="8%" style="text-align: right;"><?php echo $reporte[$i]['pps_salario']?></td>
                    <td width="8%"><?php echo $reporte[$i]['area_anterior']?></td>
                    <td width="8%"><?php echo $reporte[$i]['are_nombre']?></td> 
                </tr>
                <?php
            }
        }else{
            if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){
                ?>
                <tr nobr="true">
                    <td colspan="12" align="center">No se encontraron registros</td>
                </tr>
                <?php
            }
        } ?>
    </tbody> 
</table>