<?php
/**
 * @author Elman Ortiz
 * @copyright 2017
 */

if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}

if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="8" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de empleados por tipo de vivienda
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>

<?php if($tipo_reporte == 'pdf'):?>
<style type="text/css">
td { font-family: courier; font-size: 9px; }
</style>
<?php endif;?>

<?php if($tipo_reporte == 'pdf' OR $tipo_reporte == 'excel'):?>
<table border="0" width="100%">
  <tr>    
    <td><?php echo $tipoconstrucciontext;?></td>
    <td><?php echo $departamentotext;?></td>
    <td><?php echo $municipiotext;?></td>
  </tr>
</table>
<?php endif;?>

<table border="1px" id="tblListado" class="dynamicTable responsive display table table-bordered" aria-describedby="table_2_info">
    <thead >
        <tr nobr="true" >
            <th width="10%">Código Empleada/o</th>
            <th width="20%">Nombres</th>
            <th width="20%">Apellidos</th>
            <th width="10%">Tipo Vivienda</th>
            <th width="10%">Departamento</th>
            <th width="10%">Municipio</th>
            <th width="10%">Dirección</th>
            <th width="10%">Teléfono</th>
        </tr>
    </thead>
    <tbody>
        <?php if(count($reporte) > 0){?>
            <?php foreach ($reporte as $key => $rep) { ?>
                <tr nobr="true">
                    <td width="10%"><?php echo $rep['emp_codigo']?></td>
                    <td width="20%"><?php echo $rep['emp_nombre']?></td>
                    <td width="20%"><?php echo $rep['emp_apellido']?></td>
                    <td width="10%"><?php echo $rep['tcv_nombre']?></td>
                    <td width="10%"><?php echo $rep['dep_nombre']?></td>
                    <td width="10%"><?php echo $rep['mun_nombre']?></td>                    
                    <td width="10%"><?php echo $rep['emp_direccion']?></td>                    
                    <td width="10%"><?php echo $rep['emp_telefono']?></td>                    
                </tr>
            <?php }?>
        <?php }else{?>
            <?php if($tipo_reporte == 'pdf' || $tipo_reporte == 'excel'){?>
                <tr nobr="true">
                    <td colspan="8" align="center">No se encontraron registros</td>
                </tr>
            <?php }?>
        <?php }?>
    </tbody> 
</table>