<script type="text/javascript">
	var urlj=url_base_proyecto;
	jQuery(document).ready(function($) {
		$("#tipo_documento").select2();
		// gSateliteWhite.jsDatePicker();
		$(".vencfechas").datepicker({
			showButtonPanel: true,
			changeMonth: true,
			changeYear: true,
			dateFormat: 'dd-mm-yy',
			monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
			dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
			nextText: "Siguiente",
			prevText: "Anterior",
			closeText: 'Cerrar',
			currentText: 'Hoy'
		});
		$(".vencfechas").mask('99-99-9999');

		/*Validación*/
		$("#formulario").validate({
			rules: {
				fecha_desde: {required: true},
				fecha_hasta: {required: true},
				tipo_documento: {required: true}
			},
			messages : {
				fecha_desde : {required : "Campo requerido."},
				fecha_hasta : {required : "Campo requerido."},
				tipo_documento : {required : "Campo requerido."},
			},
			ignore: ".select2-container",
			errorPlacement: function (error, element) {
				var nombre=$(element).attr("id");
				$('#'+nombre+'_error').html(error);
			},
			submitHandler: function(form) {
				wait.start();
				var desde = $('#fecha_desde').attr('value');
				var hasta = $('#fecha_hasta').attr('value');
				var documento = $('#tipo_documento').attr('value');
				var url = urlj + 'expediente_personal/reportes/obtener_documentos';
				$.ajax({
					url: url,
					type: 'POST',
					dataType: 'JSON',
					data: {
						desde: desde,
						hasta: hasta,
						documento: documento
					},
					success: function(json){
						$('#resultados').html(json.html);
						$('#excel').attr('disabled', false);
						$('#pdf').attr('disabled', false);					
						wait.close();
					}
				});				
			}
		});

		$('.reporte').click(function(event) {
			event.preventDefault();
			var tipo=$(this).attr('id');
			$("#tipo").val(tipo);
			$("#export_print").submit();
		});
	});
</script>
<div class="row-fluid">
	<div class="span12">
		<div class="box hover">
			<div class="title">
				<h4>Reporte para verificar fecha de vencimiento de documentos</h4>
			</div>
			<div class="content">
				<form id="formulario" class="form-horizontal" action="<?php echo base_url('expediente_personal/reportes/imprimir_fecha_vencimiento');?>" method="post">
					<div class="form-row row-fluid">
						<div class="span12">
							<div class="row-fluid">
								<label class="form-label span3">Período desde <b style="color:red">*</b></label>
								<div class="span8 controls">
									<input type="text" id="fecha_desde" name="fecha_desde" class="vencfechas">
									<div id="fecha_desde_error"></div>
								</div>
							</div>
							<div class="row-fluid">
								<label class="form-label span3">Período hasta <b style="color:red">*</b></label>
								<div class="span8 controls">
									<input type="text" id="fecha_hasta" name="fecha_hasta" class="vencfechas">
									<div id="fecha_hasta_error"></div>
								</div>
							</div>
							<div class="row-fluid">
								<label class="form-label span3">Tipo de documento:<b style="color:red">*</b></label>
								<div class="span8 controls">
									<select placeholder="Seleccione un tipo de documento" class="span8 nostyle" id="tipo_documento" name="tipo_documento">
										<option value=""></option>
										<option value="0">Todos</option>
										<?php foreach ($documentos as $k) { ?>
											<option value="<?php echo $k['tde_id']?>"><?php echo $k['tde_nombre']?></option>
										<?php } ?>
									</select>
									<div id="tipo_documento_error"></div>
								</div>
							</div>
							<div class="row-fluid">
								<div class="form-actions">
									<div class="span6" style="text-align: left;">
										<button class="btn btn-info" type="submit">
											<span class="icon16 icomoon-icon-search-3 white"></span>
											<strong> Consultar</strong>
										</button>
									</div>
									<div class="span6" style="text-align: right;">
										<button class="btn btn-info reporte"  type="button" disabled id="excel">
											<span class="icon16 icomoon-icon-file-excel white"></span>
											<strong> Exportar a Excel</strong>
										</button>
										<button style="float: right; margin: 0 5px 0" class="btn btn-info reporte" type="button" disabled id="pdf">
											<span class="icon16 icomoon-icon-file-pdf white"></span>
											<strong> Exportar a PDF</strong>
										</button>
									</div>
								</div>
							</div>
						</div>
					</div>
				</form>
				<div id="resultados">
				</div>
			</div>
		</div>
	</div>
</div>