<?php
$p = ($tipo_reporte == 'pdf') ? true : false;
$smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>Reporte de capacitaciones recibidas</h4><?php echo $periodo ?>
                </td>
            </tr>
        </table>
    </div>
    <br>
<?php
}
if ($tipo_reporte != '') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        .tabla td {
            font-size: 8pt;
        }

        .tabla th {
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 8pt;
        }
    </style>
<?php }
?>
<table class="<?= ($p) ? 'tabla' : 'responsive table table-bordered'; ?>" id="tbl_facturas" name="tbl_facturas" border="<?= ($tipo_reporte != '') ? 1 : 0; ?>" style="font-size:12px;" cellpadding="1">
    <thead>
        <tr>
            <th width="15%">Empleada/o</th>
            <th width="15%">Unidad Organizativa</th>
            <th width="12%">Nombre </th>
            <th width="12%">Institucion</th>
            <th width="10%">Fecha inicio</th>
            <th width="10%">Fecha fin</th>
            <th width="8%">Horas de duracion</th>
            <th width="10%">Costo</th>
            <th width="8%">Estado</th>
        </tr>
    </thead>
    <tbody id="tbl_contenedor">

        <?php if (count($capacitaciones_grid) > 0) { ?>
            <?php foreach ($capacitaciones_grid as $key => $capa) { ?>
                <tr>
                    <td <?=($p)?'width="15%"':'';?> style="text-align: center;" >
                        <?php echo $capa['emp_codigo'].' - '.$capa['emp_nombre'].' '.$capa['emp_apellido']; ?>
                    </td>
                    <td <?=($p)?'width="15%"':''; ?> style="text-align: center;" >
                        <?php echo $capa['are_nombre'] ?>
                    </td>
                    <td  <?=($p)?'width="12%"':'';?> style="text-align: center;" >
                       <?php echo $capa['cpe_nombre']; ?>
                    </td>
                    <td  <?=($p)?'width="12%"':'';?> style="text-align: center;" >
                        <?php echo $capa['icp_nombre']; ?>
                    </td>
                    <td  <?=($p)?'width="10%"':'';?> style="text-align: center;" >
                        <?php echo formatear_fecha('d-m-Y', $capa['cpe_fecha_inicio']); ?>
                    </td>
                    <td  <?=($p)?'width="10%"':'';?> style="text-align: center;" >
                        <?php echo formatear_fecha('d-m-Y', $capa['cpe_fecha_fin']); ?>
                    </td>
                    <td  <?=($p)?'width="8%"':'';?> style="text-align: center;" >
                        <?php echo $capa['cpe_duracion']; ?>
                    </td>
                    <td <?=($p)?'width="10%"':'';?> style="text-align: center;">
                        <?php 
                            $suma = $capa['cpe_costo_empresa'] + $capa['cpe_costo_insaforp'] + $capa['cpe_costo_proveedor'];
                            echo "$".number_format($suma, 2);
                        ?>
                    </td>
                    <td  <?=($p)?'width="8%"':'';?> style="text-align: center;" >
                        <?php echo $capa['ese_nombre']; ?>
                    </td>
                </tr>
            <?php } ?>
        <?php } else { ?>
            <tr>
                <td colspan="10">
                    <center>Sin registros</center>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>