<?php
$p = ($tipo_reporte == 'pdf') ? true : false;
$smb = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>Reporte de la ultima actualizacion de perfil</h4><?php echo $periodo ?>
                </td>
            </tr>
        </table>
    </div>
    <br>
<?php
}
if ($tipo_reporte != '') {
?>
    <style type="text/css">
        .tabla {
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }

        .tabla td {
            font-size: 8pt;
        }

        .tabla th {
            vertical-align: middle;
            text-align: center;
            font-weight: bold;
            font-size: 8pt;
        }
    </style>
<?php }
?>
<table class="<?= ($p) ? 'tabla' : 'responsive table table-bordered'; ?>" id="tbl_facturas" name="tbl_facturas" border="<?= ($tipo_reporte != '') ? 1 : 0; ?>" style="font-size:12px;" cellpadding="1">
    <thead>
        <tr>
            <th width="15%">Código</th>
            <th width="35%">Nombre</th>
            <th width="15%">Fecha Actualización </th>
            <th width="35%">Realizado por</th>
        </tr>
    </thead>
    <tbody id="tbl_contenedor">

        <?php if (count($actualizaciones) > 0) { ?>
            <?php foreach ($actualizaciones as $key => $act) { ?>
                <tr>
                    <td <?=($p)?'width="15%"':'';?> style="text-align: center;" >
                        <?php echo $act['emp_codigo']; ?>
                    </td>
                    <td <?=($p)?'width="35%"':''; ?> style="text-align: center;" >
                        <?php echo $act['emp_nombre'].' '.$act['emp_apellido']; ?>
                    </td>
                    <td  <?=($p)?'width="15%"':'';?> style="text-align: center;" >
                       <?php echo formatear_fecha('d-m-Y', $act['emp_fecha_mod']);?>
                    </td>
                    <td  <?=($p)?'width="35%"':'';?> style="text-align: center;" >
                        <?php echo $act['nombre_empleado_modifica']; ?>
                    </td>
                </tr>
            <?php } ?>
        <?php } else { ?>
            <tr>
                <td colspan="4">
                    <center>Sin registros</center>
                </td>
            </tr>
        <?php } ?>
    </tbody>
</table>