<div class="row-fluid">
	<div class="span12">
		<form action="<?= base_url('expediente_personal/reportes/constancia_personalizada');?>" target="_blank" method="POST" id="constancia_form">
			<div class="form-row row-fluid">
				<div class="span12">
					<div class="row-fluid">
						<label class="form-label span3">Empleada/o: <b style="color:red">*</b></label>
						<div class="span8 controls" id="contenedor_empleado">
							<select name="empleado" id="empleado" class="nostyle" placeholder="Seleccione">
								<option value=""></option>
								<?php echo $empleados; ?>
							</select>
						</div>
						<div id="empleado_error"></div>
					</div>
				</div>
			</div>
			<div class="form-row row-fluid">
				<div class="span12">
					<div class="row-fluid">
						<label class="form-label span3">Tipo de Constancia:<b style="color:red">*</b></label>
						<div class="span8 controls">
							<select name="constancia" id="constancia" class="nostyle" placeholder="Seleccione">
								<option value=""></option>
								<?php echo $constancias; ?>
							</select>
						</div>
						<div id="constancia_error"></div>
					</div>
				</div>
			</div>
			<div class="form-row row-fluid" id="dirigido" style="display:none;">
				<div class="span12">
					<div class="row-fluid">
						<label class="form-label span3">Dirigido a:</label>
						<div class="span8 controls">
							<input type="text" name="persona_dirigido" id="persona_dirigido"/>
						</div>
						<div id="tipo_error"></div>
					</div>
				</div>
			</div>
			<div class="form-row row-fluid" id="anio" style="display:none;">
				<div class="span12">
					<div class="row-fluid">
						<label class="form-label span3">Año:</label>
						<div class="span8 controls">
							<select id="year" name="year" class="nostyle" placeholder="Seleccione">
								<option value=""></option>
								<?php echo $anios; ?>
							</select>
						</div>
					</div>
				</div>
			</div>
			<div class="form-actions" style="text-align:center">
				<button  id="imprimir" type="submit" class="btn btn-success icomoon-icon-checkmark white">
					<span> Generar Constancia</span>
				</button>
				<div>
					<br>
					<span>Campos con asterisco en <font color='FE2E2E'>rojo</font> son requeridos</span>
				</div>
			</div>
		</form>
	</div>
</div>
<script type="text/javascript">
	$(document).ready(function() {
		$("select").select2();


		$('body').on('change', '#empleado', function(event) {
			event.preventDefault();
			texto = $("#empleado option:selected").text();
			existe = texto.indexOf("(Empleada/o Inactivo)");
			$("#contenedor_empleado .select2-choice").removeAttr('style');
			if (existe != -1) {
				$("#contenedor_empleado .select2-choice").attr('style', 'color: #800707');
			}
		});


		$("#constancia").change(function() {
			var cons = $(this).val();
			//DIRIGIDO A: en constancias de salario
			if (cons == 6 /* || ver==1 || ver==2 */) {
				$("#dirigido").slideDown();
			} else {
				$("#dirigido").hide();
			}
			//SELECT AÑO en constancia de ingresos, deducciones y renta anual
			if (cons == 4) {
				$("#anio").slideDown();
			} else {
				$("#anio").hide();
			}
		});


		$('#constancia_form').validate({
			ignore: null, 
			ignore: 'input[type="hidden"]',
			rules: {
				empleado: {required: true},
				constancia: {required: true}
			} ,
			errorPlacement: function (error, element) {
				var nombre = $(element).attr("id");
				$("#" + nombre + "_error").html(error);
				crear_alerta('error','Campos Requeridos', 'Favor verifique los campos obligatorios');
			},
			submitHandler: function(form){
				texto = $("#empleado option:selected").text();
				inactivo = texto.indexOf("(Empleada/o Inactivo)");
				tipo_cons = $("#constancia").val();
				emp_activo = (inactivo != -1) ? false : true;
				if (!(emp_activo) && tipo_cons != 2) {
					crear_alerta('error','Empleada/o Inactivo','Constancia solo para empleados activos.');
					return false;
				} else {
					if (tipo_cons == 2 && emp_activo) {
						crear_alerta('error', 'Empleada/o Activo','Constancia solo para empleados inactivos.');
						return false;
					} else {
						form.submit();
					}
				}
			}
		}); 
	});
</script>