<?php
if ($tipo > 0) {
    $p = true;
} else {
    $p = false;
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=listado_empleados.xls");
    header("Pragma: no-cache");
    header("Expires: 0");
    ?>
    <meta charset="utf-8" />
    <div class="head">
        <table border="1">
            <tr>
                <td align="center" colspan="6" >
                    <h4><?= mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8'); ?> <br />
                        Reporte de empleados
                    </h4>
                </td>
            </tr>
        </table>
    </div>
    <?php
}
?>
<table cellpadding="2" cellspacing="0" border="1" class="table" width="100%">
    <thead>
        <tr>
            <th <?= ($p) ? 'width="5%"' : ''; ?>><b>#</b></th>
            <th <?= ($p) ? 'width="9%"' : ''; ?>><b>Código</b></th>
            <th <?= ($p) ? 'width="26%"' : ''; ?>><b>Nombres</b></th>   
            <th <?= ($p) ? 'width="26%"' : ''; ?>><b>Apellidos</b></th>
            <th <?= ($p) ? 'width="26%"' : ''; ?>><b>Plaza / Cargo Funcional</b></th>
            <th <?= ($p) ? 'width="8%"' : ''; ?>><b>Estado</b></th>
        </tr>
    </thead>
    <tbody>
        <?php
        if (count($total_empleados) > 0) {
            $num = 1;
            foreach ($total_empleados as $k => $emp) {
                ?>
                <tr nobr="true">
                    <td <?= ($p) ? 'width="5%"' : ''; ?>><?= $num ?></td>
                    <td <?= ($p) ? 'width="9%"' : ''; ?>><?= $emp['emp_codigo'] ?></td>
                    <td <?= ($p) ? 'width="26%"' : ''; ?>><?= $emp['emp_nombre'] ?></td>
                    <td <?= ($p) ? 'width="26%"' : ''; ?>><?= $emp['emp_apellido'] ?></td>
                    <td <?= ($p) ? 'width="26%"' : ''; ?>><?= $emp['plz_nombre'] ?></td>
                    <td <?= ($p) ? 'width="8%"' : ''; ?>><?= ($emp['emp_estado'] > 0) ? 'Activo' : 'Inactivo'; ?></td>
                </tr>
                <?php 
                $num++;
            }
        } else {
            ?>
            <tr>
                <td colspan="6" style="font-weight: bold; text-align: center;">No se encontraron registros</td>
            </tr>
            <?php
        } ?>
    </tbody>
</table>
