<?php
// REFERNCIA DE LA LIBRERIA USADA https://summernote.org/
$opciones = "";
$variables = explode(',', $tabla[0]['variables_constancia']);
$son = count($variables);
for ($i = 0; $i < $son; $i++) { 
    $opciones .= ($i == ($son - 1)) ? '"' . trim($variables[$i]) . '"' : '"' . trim($variables[$i]) . '",';
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
    <title>Editar Cuerpo Constancia</title>
    <link rel="stylesheet" type="text/css" href="<?= base_url('scripts/summer/bootstrap-3.4.1/css/bootstrap.min.css') ?>">
    <script src="<?= base_url('scripts/summer/jquery-3.5.1.min.js') ?>"></script>
    <script type="text/javascript" src="<?= base_url('scripts/summer/bootstrap-3.4.1/js/bootstrap.min.js') ?>"></script>
    <link href="<?= base_url('scripts/summer/summernote.min.css') ?>" rel="stylesheet">
    <script src="<?= base_url('scripts/summer/summernote.min.js') ?>"></script>
    <script src="<?= base_url('scripts/summer/lang/summernote-es-ES.js') ?>"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#cuerpo_carta').summernote({
                placeholder: 'Ingrese Texto. Las variables comienzan con @',
                lang: 'es-ES', // default: 'en-US'
                hint: {
                    mentions: [<?php echo $opciones; ?>],
                    match: /\B@(\w*)$/,
                    search: function (keyword, callback) {
                        callback($.grep(this.mentions, function (item) {
                            return item.indexOf(keyword) == 0;
                        }));
                    },
                    content: function (item) {
                        return '@' + item;
                    }    
                },
                toolbar: [
                    ['style', ['bold', 'italic', 'underline', 'clear']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['view', ['fullscreen', 'codeview']]
                ],
                focus: true
            });


            $('body').on('click', '#cancelar', function () {
                parent.jQuery("#tipo_constancia").trigger("change");
                parent.jQuery.fancybox.close(); 
            });


            $('body').on('click', '#btn_guardar', function () {
                var id_cons = $("#constancia_id").val();
                var tipo_cons = $("#tipo_constans").val();
                if (!( $('#cuerpo_carta').summernote('isEmpty') ) ) {
                    var markup = $('#cuerpo_carta').summernote('code');
                    var url_func = '<?= $url_base ?>';
                    $.ajax({
                        type: 'POST',
                        url:  url_func + 'expediente_personal/catalogos/editar_constancia/' + tipo_cons,
                        data: {
                            id_cons: id_cons,
                            tipo_cons: tipo_cons,
                            text_cons: markup
                        },
                        beforeSend: function () {
                        },
                        success: function (data) {
                            if (data > 0) {
                                parent.crear_alerta('success','Éxito', 'Se guardó la información correctamente');
                                parent.jQuery("#tipo_constancia").trigger("change");
                                parent.jQuery.fancybox.close(); 
                            } else {
                                parent.crear_alerta('error','Error', 'No fue posible guardar la información');
                            }
                        }
                    });
                } else {
                    parent.jQuery("#tipo_constancia").trigger("change");
                    parent.jQuery.fancybox.close(); 
                }
            });

        });
    </script>
</head>
<body>
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4><span style="font-weight: bold;">Tipo de Constancia:</span>&nbsp;<span><?= $tabla[0]['tpo_nombre'] ?></span></h4>
                </div>
                <div class="content">
                    <div class="row-fluid">
                        <div class="span12">
                            <div class="form-row row-fluid">
                                <div class="span12">
                                    <div class="row-fluid">
                                        <div id="cuerpo_carta"><?php echo $tabla[0]['fre_configuraciones_formato']; ?></div>
                                        <input type="hidden" id="constancia_id" value="<?= $tabla[0]['fre_id'] ?>">
                                        <input type="hidden" id="tipo_constans" value="<?= $tabla[0]['tpo_id'] ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-actions" style="text-align: center;">
                            <button id="btn_guardar" class="btn btn-success" type="button">
                                <span class="glyphicon glyphicon-ok" aria-hidden="true"></span><span> Guardar Cambios</span>
                            </button>
                            <button id="cancelar" class="btn btn-danger" type="button">
                                <span class="glyphicon glyphicon-remove" aria-hidden="true"></span><span> Cancelar</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>