<script type="text/javascript">
    $(document).ready(function() {
        $("select").select2();

        $("#tipo_constancia").change(function() {
            var tipo = $(this).val();
            if (tipo != "") {
                var boton = '<a href="'+urlj+'expediente_personal/catalogos/editar_constancia/'+tipo+'" class="btn btn-primary abre_modal"><span class="icomoon-icon-pencil-5"> Editar</span></a>';
                $.ajax({
                    type: 'post',
                    dataType: 'json',
                    url: urlj+'expediente_personal/catalogos/cuerpo_constancia',
                    data: {
                        tipo_cons: tipo
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        if (data.error > 0) {
                            $('#ver_carta').html("");
                            crear_alerta('error', 'No existe la constancia', 'Comuníquese con Servicio Técnico');
                        } else {
                            $('#ver_carta').html(data.valor);
                            $("#btn_editar").html(boton);
                        }
                        wait.close();
                    }
                });
            } else {
                $('#ver_carta').html("");
                $("#btn_editar").html("");
            }
        });
    });

    $(".abre_modal").fancybox({
        width: '100%',
        openEffect  : 'elastic',
        closeEffect : 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        closeBtn: false,
        helpers: {
            overlay: {closeClick: false}
        }
    });
</script>

<div class="row-fluid">
    <div class="span12">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Tipo de Constancia</span>
                </h4>
            </div>
            <div class="content">
                <div class="row-fluid">
                    <div class="span12">
                        <div class="form-row row-fluid">
                            <div class="span10">
                                <div class="row-fluid">
                                    <label class="form-label span3" >Tipo de Constancia:</label>
                                    <div class="span7 controls">
                                        <select class="nostyle" placeholder="Seleccione" id="tipo_constancia">
                                            <option value=""></option>
                                            <?php echo $constancias; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="span2">
                                <div class="row-fluid" id="btn_editar">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="box">
            <div class="title">
                <h4>
                    <span>&nbsp;</span>
                </h4>
            </div>
            <div class="content">
                <div class="row-fluid">
                    <div class="span12">
                        <div class="form-row row-fluid">
                            <div class="span12">
                                <div id="ver_carta"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>