<meta charset="utf-8" />
<?php 
foreach($css_files as $file): ?>
    <link type="text/css" rel="stylesheet" href="<?php echo $file; ?>" />
<?php endforeach; ?>
<?php foreach($js_files as $file): ?>
    <script src="<?php echo $file; ?>"></script>
<?php endforeach; ?>
<style type='text/css'>
body
{
    font-family: Arial;
    font-size: 14px;
}
a {
    color: blue;
    text-decoration: none;
    font-size: 14px;
}
a:hover
{
    text-decoration: underline;
}
</style>
<div style='height:20px;'></div>  
<div>
    <?php echo $output; ?>
    <input type="hidden" id="dispo">
</div>

<script type="text/javascript">
    $("#field-acn_porcentaje").addClass( "soloDecimales" );
    $('#field-acn_porcentaje').attr('extras', '.');
    $("#field-acn_porcentaje").numeric();
    $("#field-acn_cantidad_acciones").numeric();
    $("#field-acn_valor_nominal").numeric();
    $("#field-acn_valor_contable").numeric();
    // $("#field-acn_documento_dui").mask('99999999-9');
    // $("#field-acn_documento_nit").mask('9999-999999-999-9');
    $("#agreg").attr('href',window.gSateliteWhite.baseUrl('estructura_organizativa/procesos/guardar_registro_accionistas'));
    $(document).ready(function(){
        var pathArray = window.location.pathname.split('/');
        var add  = (pathArray.length - 1); 
        var edit = (pathArray.length - 2); 
        var vista = 0;
        var dispo = 0;
        if (pathArray[add] == 'add') {
            vista = 1;
            $("#field-acn_documento_nit").parent().parent().parent().append('<div id="notificacion"></div>');
        } else if (pathArray[edit] == 'edit') {
            console.log('editar');
            vista = 2;
            $("#field-acn_documento_nit").parent().parent().parent().append('<div id="notificacion"></div><br />');
        }

        if (vista > 0) {
            calcular_disponible(vista);
        }

        $('#field-acn_porcentaje').blur(function () {
            var porcentaje = $('#field-acn_porcentaje').val();
            var disponible = $('#dispo').val();
            if (vista == 1) {
                if (parseFloat(porcentaje) > parseFloat(disponible)) {
                    crear_alerta("error","Atención","Porcentaje no debe ser mayor a "+disponible+"%");                    
                    $("#field-acn_porcentaje").val('');
                }
            }
            if (vista == 2) {
                var actual = $("#actual").val();
                var total = parseFloat(actual) + parseFloat(disponible);
                console.log(total);
                if (parseFloat(porcentaje) > parseFloat(total)) {
                    if (disponible > 0) {
                    crear_alerta("error","Atención","Nuevo porcentaje no debe ser mayor a "+total+"%");
                    } else {
                        crear_alerta("error","Verifique","No existe porcentaje disponible");
                    }                    
                    $("#field-acn_porcentaje").val('');
                }
            }
        });

        $('#save-button').click(function () {
            setTimeout(function() {
                calcular_disponible(vista);
                if (vista == 2) {
                    $("#actual").val($('#field-acn_porcentaje').val());
                    console.log('exito');
                }
            }, 500);
        });
    });//END  DOCUMENT.READY

    function calcular_disponible(vista) {
        $("#notificacion").html('');
        $.ajax({
            type: 'POST',
            url: window.gSateliteWhite.baseUrl('estructura_organizativa/procesos/get_porcentaje_disponible'), 
            dataType: 'json',
            data:{
                vista:vista   
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                console.log(data);
                if (vista == 1) {$("#notificacion").append('<span id="disponible"><b>Porcentaje disponible: '+data.disponible.toFixed(2)+'%</b></span>');}
                if (vista == 2) {$("#notificacion").append('<span id="disponible"><b>Porcentaje adicional disponible: '+data.disponible.toFixed(2)+'%</b></span>');}
                $('#dispo').val(data.disponible);
                wait.close();
            }
        });
    }
</script>