<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla {
            border: 1px solid black;
        }

        .num {
            mso-number-format: General;
        }

        .text {
            mso-number-format: "\@";
            /*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de categoría salarial
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
?>

    <table class="">
        <tr>
            <td colspan="4"></td>
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Categoría :</b></td>
            <td style="text-align: left;"><?php echo $nivel_nombre; ?></td>
            <td style="width: 10%; text-align: left;"><b>Área:</b></td>
            <td style="text-align: left;"><?php echo $area_nombre; ?></td>
        </tr>
        <tr>
            <td colspan="4"></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla">
        <thead>
            <tr>
                <th>Código plaza / cargo funcional</th>
                <th>Nombre de la plaza / cargo funcional</th>
                <th>Empleada/o</th>
                <th>Nivel</th>
                <th>Punto mínimo</th>
                <th>Punto máximo</th>
                <th>Salario mínimo</th>
                <th>Salario máximo</th>
                <th>Salario medio</th>
                <th>Salario actual</th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i      = 1;
        foreach ($reporte as $row) :
        ?>
            <tr class="dato">
                <td><?php echo $row['plz_codigo']; ?></td>
                <td><?php echo $row['plz_nombre']; ?></td>
                <td><?php echo $row['emp_codigo'] . $row['emp_nombre'] . " " . $row['emp_apellido']; ?></td>
                <td><?php echo $row['cts_nivel']; ?></td>
                <td><?php echo number_format($row['cts_punto_minimo'], 2); ?></td>
                <td><?php echo number_format($row['cts_punto_maximo'], 2); ?></td>
                <td><?php echo number_format($row['cts_salario_minimo'], 2); ?></td>
                <td><?php echo number_format($row['cts_salario_maximo'], 2); ?></td>
                <td><?php echo number_format($row['cts_salario_medio'], 2); ?></td>
                <td><?php echo number_format($row['emp_salario'], 2); ?></td>
            </tr>
        <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
        ?>
        </tbody>
    </table>
<?php } ?>