<?php if ($reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
$pdf = ($reporte == 'pdf') ? true : false;
if ($reporte == 'pdf') {
?>
    <style type="text/css">
        .tabla {
            font-weight: normal !important;
            border: 1px solid black;
        }

        .tabla th {
            border: 1px solid black;
            vertical-align: middle;
            text-align: center;
            background-color: #BCBBBB;
            font-size: 9px;
        }

        .tabla td {
            border: 1px solid black;
            vertical-align: middle;
        }
    </style>
<?php
}
if ($reporte == 'excel') {
?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="4">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Miembros de Junta Directiva
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php
}
?>
<table id="datagried" class="responsive display table table-bordered tabla" cellpadding="2" <?php echo ($reporte == 'excel') ? 'border="1"' : ""; ?>>
    <thead>
        <tr>
            <th <?= ($pdf) ? 'width="17%"' : ""; ?>><b>Nombre</b></th>
            <th <?= ($pdf) ? 'width="12%"' : ""; ?>><b>Cargo</b></th>
            <th <?= ($pdf) ? 'width="12%"' : ""; ?>><b>Institución</b></th>
            <th <?= ($pdf) ? 'width="21%"' : ""; ?>><b>Período</b></th>
            <th <?= ($pdf) ? 'width="12%"' : ""; ?>><b>Dirección</b></th>
            <th <?= ($pdf) ? 'width="8%"' : ""; ?>><b>Teléfono</b></th>
            <th <?= ($pdf) ? 'width="12%"' : ""; ?>><b>Correo Electrónico</b></th>
            <th <?= ($pdf) ? 'width="6%"' : ""; ?>><b>Estado</b></th>
        </tr>
    </thead>
    <tbody id="consulta_table">
        <?php
        if (count($accionistas) > 0) {
            foreach ($accionistas as $key => $acc) {
                $periodo = ($acc['mij_periodo_inicio'] != "") ? "Desde " . formatear_fecha('d-m-Y', $acc['mij_periodo_inicio']) . " " : "";
                $periodo .= ($acc['mij_periodo_fin'] != "") ? "Hasta " . formatear_fecha('d-m-Y', $acc['mij_periodo_fin']) : "";
        ?>
                <tr>
                    <td <?= ($pdf) ? 'width="17%"' : ""; ?>><?php echo $acc['mij_nombre']; ?></td>
                    <td <?= ($pdf) ? 'width="12%"' : ""; ?>><?php echo $acc['pto_nombre']; ?></td>
                    <td <?= ($pdf) ? 'width="12%"' : ""; ?>><?php echo $acc['itt_nombre']; ?></td>
                    <td <?= ($pdf) ? 'width="21%"' : ""; ?>><?php echo $periodo; ?></td>
                    <td <?= ($pdf) ? 'width="12%"' : ""; ?>><?php echo $acc['mij_direccion_contacto']; ?></td>
                    <td <?= ($pdf) ? 'width="8%"' : ""; ?>><?php echo $acc['mij_telefono_contacto']; ?></td>
                    <td <?= ($pdf) ? 'width="12%"' : ""; ?>><?php echo $acc['mij_correo_contacto']; ?></td>
                    <td <?= ($pdf) ? 'width="6%"' : ""; ?>><?php echo ($acc['mij_estado'] > 0) ? "Activo" : "Inactivo"; ?></td>
                </tr>
            <?php
            }
        } else {
            if ($reporte != '') {
            ?>
                <tr>
                    <td colspan="9" style="text-align: center;"><b>No se encontraron registros</b></td>
                </tr>
        <?php
            }
        }
        ?>
    </tbody>
</table>