<script type="text/javascript">
    function goFullscreen(id) {
        // Get the element that we want to take into fullscreen mode
        var element = document.getElementById(id);
        // These function will not exist in the browsers that don't support fullscreen mode yet, 
        // so we'll have to check to see if they're available before calling them.
        if (element.mozRequestFullScreen) {
            // This is how to go into fullscren mode in Firefox
            // Note the "moz" prefix, which is short for Mozilla.
            element.mozRequestFullScreen();
        } else if (element.webkitRequestFullScreen) {
            // This is how to go into fullscreen mode in Chrome and Safari
            // Both of those browsers are based on the Webkit project, hence the same prefix.
            element.webkitRequestFullScreen();
        } else if (element.msRequestFullscreen) {
            element.msRequestFullscreen();
        } else {
            element.requestFullscreen();
        }
    }
    jQuery(document).ready(function($) {
        $(".toolt").tooltip();
        setTimeout(function() {
            $(".title_heading:first").html("<?php echo $titulo_personal; ?>");
        }, 1000);
    });
</script>
<div class="row-fluid">
    <div class="span12">
        <!-- Filtros -->
        <div class="box" style="display: none;">
            <div class="title">
                <h4>
                    <span>Filtros </span>
                </h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="content">
                <div id="div_areas">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="form-label span3">Niveles del área:</label>
                                <div class="span9 controls labels-info">
                                    <select id="slc_area" name="slc_area" class="nostyle areas dinamic" placeholder="Seleccione" style="width:100%">
                                        <option value=""></option>
                                        <?php
                                        if (count($areas) > 0) {
                                            foreach ($areas as $area) {
                                                $seleccionado = "";
                                                if ($area['nia_id'] == $tipo_estructura) {
                                                    $seleccionado = "selected";
                                                }
                                                echo '<option value="' . $area['nia_id'] . '"' . $seleccionado . '>' . $area['nia_nombre'] . '</option>';
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <button type="button" id="btnConsultar" class="btn btn-success">Consultar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="reporte" class="horizontal" id="rpt-ordenes" method="POST">
    <input type="hidden" name="filtro_area" id="filtro_area" value="<?php echo ($tipo_estructura > 0) ? $tipo_estructura : ''; ?>">
</form>


<?php // IFRAME QUE CONTENDRA EL DIAGRAMA 
if ($tipo_estructura == "") { ?>
    <button onclick="goFullscreen('iframe_org'); return false" class="btn btn-info toolt" title="Ver pantalla Completa"><span class="icon16 icomoon-icon-full-screen white"></span></button>
    <a href="<?php echo base_url("estructura_organizativa/consultas/ver_organigrama2/0/si"); ?>" target="_blank" class="btn btn-info toolt" title="Imprimir"><span class="icon16 entypo-icon-printer white"></span></a>
    <div id="iframe_div_diagrama">
        <iframe id="iframe_org" style="border:0px;" src="<?php echo base_url("estructura_organizativa/consultas/ver_organigrama2"); ?>" width="100%" height="600"></iframe>
    <?php } else {  ?>
        <button onclick="goFullscreen('iframe_org'); return false" class="btn btn-info toolt" title="Ver pantalla Completa"><span class="icon16 icomoon-icon-full-screen white"></span></button>
        <a href="<?php echo base_url("estructura_organizativa/consultas/filtro_ver_organigrama2") . "/" . $tipo_estructura . "/si"; ?>" target="_blank" class="btn btn-info toolt" title="Imprimir"><span class="icon16 entypo-icon-printer white"></span></a>
        <div id="iframe_div_diagrama">
            <iframe id="iframe_org" style="border:0px;" src="<?php echo base_url("estructura_organizativa/consultas/filtro_ver_organigrama2") . "/" . $tipo_estructura; ?>" width="100%" height="600"></iframe>
        <?php } ?>

        </div>

        <script type="text/javascript">
            function imprSelec(muestra) {
                var ficha = document.getElementById(muestra);
                var ventimp = window.open(' ', 'popimpr');
                ventimp.document.write(ficha.innerHTML);
                ventimp.document.close();
                ventimp.print();
                ventimp.close();
            }
        </script>

        <script type="text/javascript" src="<?= base_url() ?>js/estructura_organizativa/consultas/consulta_organigrama2.js"></script>