<?php if (isset($excel)) {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
} ?>
<style type="text/css">
    .tabla {
        font-weight: normal !important;
        border: 1px solid black;
        /*width: 100% !important;*/
    }

    .tabla th {
        border: 1px solid black;
        vertical-align: middle;
        text-align: center;
        background-color: #BCBBBB;
        font-size: 9px;

    }

    .tabla td {
        border: 1px solid black;
        vertical-align: middle;
        text-align: center;
    }
</style>
<?php if ($excel == 1) { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="4">
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                        Reporte de Accionistas
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>
<table class="tabla" cellpadding="2">
    <thead>
        <tr>
            <th><b>Accionista</b></th>
            <th><b>Porcentaje de participación</b></th>
            <th><b>Cantidad acciones</b></th>
            <th><b>Valor contable</b></th>
            <th><b>Valor nominal</b></th>
            <th><b>DUI</b></th>
            <th><b>NIT</b></th>
            <th><b>Fecha de registro</b></th>
            <th><b>Estado</b></th>
        </tr>
    </thead>
    <tbody id="consulta_table">
        <?php
        $porcentaje_total = 0;
        $cant_acciones_total = 0;
        $val_contable_total = 0;
        $val_nominal_total = 0;
        ?>
        <?php
        foreach ($accionistas as $acc) {
        ?>
            <tr>
                <td><?php echo $acc['acn_nombre']; ?></td>
                <td><?php echo $acc['acn_porcentaje']; ?>%</td>
                <td><?php echo $acc['acn_cantidad_acciones']; ?></td>
                <td><?php echo $acc['acn_valor_contable']; ?></td>
                <td><?php echo $acc['acn_valor_nominal']; ?></td>
                <td><?php echo $acc['acn_documento_dui']; ?></td>
                <td><?php echo $acc['acn_documento_nit']; ?></td>
                <td><?php echo date('d-m-Y', strtotime($acc['acn_fecha_creacion'])); ?></td>
                <td><?php if ($acc['acn_estado'] > 0) {
                        echo "Activo";
                    } else {
                        echo "Inactivo";
                    }  ?></td>
            </tr>
            <?php
            $porcentaje_total += $acc['acn_porcentaje'];
            $cant_acciones_total += $acc['acn_cantidad_acciones'];
            $val_contable_total += $acc['acn_valor_contable'];
            $val_nominal_total += $acc['acn_valor_nominal'];
            ?>
        <?php
        }
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td>TOTAL</td>
            <td><?php echo $porcentaje_total; ?>%</td>
            <td><?php echo $cant_acciones_total; ?></td>
            <td><?php echo $val_contable_total; ?></td>
            <td><?php echo $val_nominal_total; ?></td>
            <td colspan="4"></td>
        </tr>
    </tfoot>
</table>