<?php
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("content-disposition: attachment;filename=exportar_data.xls");
header("Pragma: no-cache");
header("Expires: 0");
?>
<table border="1">
    <thead>
    <tr>
        <td>Código Entrevista</td>
        <td>Encuesta</td>
        <td>Fecha Entrevista</td>
        <td>Grupo</td>
        <td>Cod. Pregunta</td>
        <td>Pregunta</td>
        <td>Tipo Pregunta</td>
        <td>Cod. Respuesta</td>
        <td>Respuesta</td>
        <td>Respuesta Especifique</td>
    </tr>
    </thead>
    <tbody>
    <?php
    if (count($encuestas) > 0) {

        foreach ($encuestas as $enc) {
            $tipo_pregunta = "";
            switch ($enc['pre_tipo']) {
                case 1:
                    $tipo_pregunta = "Texto";
                    break;
                case 2:
                    $tipo_pregunta = "Lista desplegable";
                    break;
                case 3:
                    $tipo_pregunta = "Selección Múltiple";
                    break;
                case 4:
                    $tipo_pregunta = "Falso/Verdadero";
                    break;
                case 5:
                    $tipo_pregunta = "Numérico Entero";
                    break;
                case 6:
                    $tipo_pregunta = "Número Decimal";
                    break;
                case 7:
                    $tipo_pregunta = "Fecha";
                    break;
                case 8:
                    $tipo_pregunta = "Hora";
                    break;
                case 9:
                    $tipo_pregunta = "Tabla dinámica";
                    break;
                case 16:
                    $tipo_pregunta = 'Tabla Dinamica Indexable';
                    break;
            }


            //Si no son preguntas del tipo multiple o tabla dinamica
            if ($enc['pre_tipo'] != 9 && $enc['pre_tipo'] != 10 && $enc['pre_tipo'] != 16) {
                //Se buscan las respuestas cuando la pregunta fue tipo Selector
                if ($enc['pre_tipo'] == 2) {
                    //Se filtran las opciones
                    $pre_id = $enc['pre_id'];
                    $opciones_pre = array_filter($opr_data, function ($value) use ($pre_id) {
                        return $value['opr_id_pre'] == $pre_id;
                    });

                    $res = 0;

                    foreach ($opciones_pre as $opc) {
                        $filtro_resp = array('pre_id' => $enc['pre_id'], 'ecl_id' => $enc['ecl_id'], 'opr_id' => $opc['opr_id']);

                        $respuesta_pregunta = array_filter($rec_data, function ($value) use ($filtro_resp) {
                            return ($value['rec_id_ecl'] == $filtro_resp['ecl_id']
                                && $value['rec_id_pre'] == $filtro_resp['pre_id']
                                && $value['rec_id_opr'] == $filtro_resp['opr_id']);
                        });

                        //var_dump($respuesta_pregunta);
                        if (count($respuesta_pregunta) > 0) {
                            $res++;
                            foreach ($respuesta_pregunta as $rec) {
                                if ($opc['opr_aplica_especifique'] == 1) {
                                    $filtro_espc = array('rec_id' => $rec['rec_id'], 'opr_id' => $opc['opr_id']);
                                    $especifique_res = array_filter($oxp_data, function ($value) use ($filtro_espc) {
                                        return ($value['oxp_id_opr'] == $filtro_espc['opr_id'] && $value['oxp_id_rec'] == $filtro_espc['rec_id']);
                                    });

                                    $especifique_res = (count($especifique_res) > 0) ? array_pop(array_reverse($especifique_res)) : null;
                                }
                                ?>
                                <tr>
                                    <td><?php echo $enc['ecl_id']; ?></td>
                                    <td><?php echo $enc['enc_nombre']; ?></td>
                                    <td><?php echo $enc['ecl_fecha']; ?></td>
                                    <td><?php echo $enc['suc_nombre']; ?></td>
                                    <td><?php echo $enc['pre_id']; ?></td>
                                    <td><?php echo $enc['pre_nombre']; ?></td>
                                    <td><?php echo $tipo_pregunta; ?></td>
                                    <td><?php echo $rec['rec_id']; ?></td>
                                    <td><?php echo $opc['opr_nombre']; ?></td>
                                    <td><?php echo ($especifique_res != null) ? $especifique_res['oxp_valor_referencia'] : ''; ?></td>
                                </tr>
                            <?php }
                        }
                    }

                    if ($res == 0) { ?>
                        <tr>
                            <td><?php echo $enc['ecl_id']; ?></td>
                            <td><?php echo $enc['enc_nombre']; ?></td>
                            <td><?php echo $enc['ecl_fecha']; ?></td>
                            <td><?php echo $enc['suc_nombre']; ?></td>
                            <td><?php echo $enc['pre_id']; ?></td>
                            <td><?php echo $enc['pre_nombre']; ?></td>
                            <td><?php echo $tipo_pregunta; ?></td>
                            <td><?php echo ''; ?></td>
                            <td><?php echo ''; ?></td>
                            <td><?php echo ''; ?></td>
                        </tr>
                    <?php }
                }
                else if ($enc['pre_tipo'] == 3) {
                    //Se filtran las opciones
                    $pre_id = $enc['pre_id'];
                    $opciones_pre = array_filter($opr_data, function ($value) use ($pre_id) {
                        return $value['opr_id_pre'] == $pre_id;
                    });

                    $res = 0;
                    foreach ($opciones_pre as $opc) {
                        $filtro_resp = array('pre_id' => $enc['pre_id'], 'ecl_id' => $enc['ecl_id'], 'opr_id' => $opc['opr_id']);

                        $respuesta_pregunta = array_filter($rec_data, function ($value) use ($filtro_resp) {
                            return ($value['rec_id_ecl'] == $filtro_resp['ecl_id']
                                && $value['rec_id_pre'] == $filtro_resp['pre_id']);
                        });

                        //var_dump($respuesta_pregunta);
                        if (count($respuesta_pregunta) > 0) {

                            foreach ($respuesta_pregunta as $rec) {

                                $filter_oxp = array('rec_id' => $rec['rec_id'], 'opr_id' => $opc['opr_id']);
                                //Se buscan las opciones seleccionadas
                                $oxp_res = array_filter($oxp_data, function ($value) use ($filter_oxp) {
                                    return ($value['oxp_id_rec'] == $filter_oxp['rec_id'] && $value['oxp_id_opr'] == $filter_oxp['opr_id']);
                                });
                                //var_dump($oxp_res);
                                foreach ($oxp_res as $oxp) {
                                    $res++;
                                    ?>
                                    <tr>
                                        <td><?php echo $enc['ecl_id']; ?></td>
                                        <td><?php echo $enc['enc_nombre']; ?></td>
                                        <td><?php echo $enc['ecl_fecha']; ?></td>
                                        <td><?php echo $enc['suc_nombre']; ?></td>
                                        <td><?php echo $enc['pre_id']; ?></td>
                                        <td><?php echo $enc['pre_nombre']; ?></td>
                                        <td><?php echo $tipo_pregunta; ?></td>
                                        <td><?php echo $oxp['oxp_id']; ?></td>
                                        <td><?php echo $opc['opr_nombre']; ?></td>
                                        <td><?php echo $oxp['oxp_valor_referencia']; ?></td>
                                    </tr>
                                <?php }
                            }
                        }
                    }

                    if ($res == 0) { ?>
                        <tr>
                            <td><?php echo $enc['ecl_id']; ?></td>
                            <td><?php echo $enc['enc_nombre']; ?></td>
                            <td><?php echo $enc['ecl_fecha']; ?></td>
                            <td><?php echo $enc['suc_nombre']; ?></td>
                            <td><?php echo $enc['pre_id']; ?></td>
                            <td><?php echo $enc['pre_nombre']; ?></td>
                            <td><?php echo $tipo_pregunta; ?></td>
                            <td><?php echo ''; ?></td>
                            <td><?php echo ''; ?></td>
                            <td><?php echo ''; ?></td>
                        </tr>
                    <?php }
                } 
                else {

                    $filtro_resp = array('pre_id' => $enc['pre_id'], 'ecl_id' => $enc['ecl_id']);
                    $respuesta_pregunta = array_filter($rec_data, function ($value) use ($filtro_resp) {
                        return ($value['rec_id_ecl'] == $filtro_resp['ecl_id'] && $value['rec_id_pre'] == $filtro_resp['pre_id']);
                    });

                    $respuesta = (count($respuesta_pregunta) > 0) ? array_pop(array_reverse($respuesta_pregunta)) : null;

                    if ($respuesta != null) {
                        ?>
                        <tr>
                            <td><?php echo $enc['ecl_id']; ?></td>
                            <td><?php echo $enc['enc_nombre']; ?></td>
                            <td><?php echo $enc['ecl_fecha']; ?></td>
                            <td><?php echo $enc['suc_nombre']; ?></td>
                            <td><?php echo $enc['pre_id']; ?></td>
                            <td><?php echo $enc['pre_nombre']; ?></td>
                            <td><?php echo $tipo_pregunta; ?></td>
                            <td><?php echo $respuesta['rec_id']; ?></td>
                            <td><?php echo $respuesta['rec_respuesta']; ?></td>
                            <td><?php echo ''; ?></td>
                        </tr>
                    <?php }
                }
            } else {
                //Se filtran las opciones
                $pre_id = $enc['pre_id'];
                $opciones_pre = array_filter($opr_data, function ($value) use ($pre_id) {
                    return $value['opr_id_pre'] == $pre_id;
                });
                $tipo_pregunta = "Tabla Dinámica";
                if ($enc['pre_tipo'] == 16) {
                    $tipo_pregunta = "Tabla Dinámica Indexable";
                }

                foreach ($opciones_pre as $opc) {
                    switch ($opc['opr_tipo_campo_dinamico']) {
                        case 1:
                            $tipo_pregunta .= " - Texto";
                            break;
                        case 2:
                            $tipo_pregunta .= " - Lista desplegable";
                            break;
                        case 3:
                            $tipo_pregunta .= " - Selección Múltiple";
                            break;
                        case 4:
                            $tipo_pregunta .= " - Falso/Verdadero";
                            break;
                        case 5:
                            $tipo_pregunta .= " - Numérico Entero";
                            break;
                        case 6:
                            $tipo_pregunta .= " - Número Decimal";
                            break;
                        case 7:
                            $tipo_pregunta .= " - Fecha";
                            break;
                        case 8:
                            $tipo_pregunta .= " - Hora";
                            break;
                        case 9:
                            $tipo_pregunta = " - Tabla dinámica";
                            break;
                    }

                    if ($opc['opr_tipo_campo_dinamico'] == 2) {
                        $res = 0;
                        $filtro_resp = array('pre_id' => $enc['pre_id'], 'ecl_id' => $enc['ecl_id'], 'opr_id' => $opc['opr_id']);

                        $respuesta_pregunta = array_filter($rec_data, function ($value) use ($filtro_resp) {
                            return ($value['rec_id_ecl'] == $filtro_resp['ecl_id']
                                && $value['rec_id_pre'] == $filtro_resp['pre_id']
                                && $value['rec_id_opr'] == $filtro_resp['opr_id']);
                        });

                        if (count($respuesta_pregunta) > 0) {
                            $res++;
                            foreach ($respuesta_pregunta as $rec) {

                                $especifique_res = null;
                                //if ($opc['opr_aplica_especifique'] == 1) {
                                $filtro_espc = array('rec_id' => $rec['rec_id'], 'opr_id' => $opc['opr_id']);
                                $especifique_res = array_filter($oxp_data, function ($value) use ($filtro_espc) {
                                    return ($value['oxp_id_opr'] == $filtro_espc['opr_id'] && $value['oxp_id_rec'] == $filtro_espc['rec_id']);
                                });

                                $especifique_res = (count($especifique_res) > 0) ? array_pop(array_reverse($especifique_res)) : null;
                                $otd = null;
                                if($especifique_res != null){
                                    $filtro_otd = array('otd_id' => $especifique_res['oxp_id_otd'], 'opr_id' => $opc['opr_id']);
                                    $otd = array_filter($otd_data, function ($value) use ($filtro_otd) {
                                        return ($value['otd_id'] == $filtro_otd['otd_id'] && $value['otd_id_opr'] == $filtro_otd['opr_id']);
                                    });
                                }

                                $otd = (count($otd) > 0) ? array_pop(array_reverse($otd)) : null;
                                //}
                                ?>
                                <tr>
                                    <td><?php echo $enc['ecl_id']; ?></td>
                                    <td><?php echo $enc['enc_nombre']; ?></td>
                                    <td><?php echo $enc['ecl_fecha']; ?></td>
                                    <td><?php echo $enc['suc_nombre']; ?></td>
                                    <td><?php echo $opc['opr_id']; ?></td>
                                    <td><?php echo $opc['opr_nombre']; ?></td>
                                    <td><?php echo $tipo_pregunta; ?></td>
                                    <td><?php echo $rec['rec_id']; ?></td>
                                    <td><?php echo ($otd != null) ? $otd['otd_nombre'] : ''; ?></td>
                                    <td><?php echo ($especifique_res != null) ? $especifique_res['oxp_valor_referencia'] : ''; ?></td>
                                </tr>
                            <?php }
                        } else { ?>
                            <tr>
                                <td><?php echo $enc['ecl_id']; ?></td>
                                <td><?php echo $enc['enc_nombre']; ?></td>
                                <td><?php echo $enc['ecl_fecha']; ?></td>
                                <td><?php echo $enc['suc_nombre']; ?></td>
                                <td><?php echo $opc['opr_id']; ?></td>
                                <td><?php echo $opc['opr_nombre']; ?></td>
                                <td><?php echo $tipo_pregunta; ?></td>
                                <td><?php echo ''; ?></td>
                                <td><?php echo ''; ?></td>
                                <td><?php echo ''; ?></td>
                            </tr>
                        <?php }

                    } else if ($opc['opr_tipo_campo_dinamico'] == 3) {

                    } else {
                        $filtro_resp = array('pre_id' => $enc['pre_id'], 'ecl_id' => $enc['ecl_id'], 'opr_id' => $opc['opr_id']);

                        $respuesta_pregunta = array_filter($rec_data, function ($value) use ($filtro_resp) {
                            return ($value['rec_id_ecl'] == $filtro_resp['ecl_id']
                                && $value['rec_id_pre'] == $filtro_resp['pre_id']
                                && $value['rec_id_opr'] == $filtro_resp['opr_id']);
                        });

                        if (count($respuesta_pregunta) > 0) {
                            //$res++;
                            foreach ($respuesta_pregunta as $rec) { ?>
                                <tr>
                                    <td><?php echo $enc['ecl_id']; ?></td>
                                    <td><?php echo $enc['enc_nombre']; ?></td>
                                    <td><?php echo $enc['ecl_fecha']; ?></td>
                                    <td><?php echo $enc['suc_nombre']; ?></td>
                                    <td><?php echo $opc['opr_id']; ?></td>
                                    <td><?php echo $opc['opr_nombre']; ?></td>
                                    <td><?php echo $tipo_pregunta; ?></td>
                                    <td><?php echo $rec['rec_id']; ?></td>
                                    <td><?php echo $rec['rec_respuesta']; ?></td>
                                    <td><?php echo ''; ?></td>
                                </tr>
                            <?php }
                        } else { ?>
                            <tr>
                                <td><?php echo $enc['ecl_id']; ?></td>
                                <td><?php echo $enc['enc_nombre']; ?></td>
                                <td><?php echo $enc['ecl_fecha']; ?></td>
                                <td><?php echo $enc['suc_nombre']; ?></td>
                                <td><?php echo $enc['opr_id']; ?></td>
                                <td><?php echo $opc['opr_nombre']; ?></td>
                                <td><?php echo $tipo_pregunta; ?></td>
                                <td><?php echo $rec['rec_id']; ?></td>
                                <td><?php echo $rec['rec_respuesta']; ?></td>
                                <td><?php echo ''; ?></td>
                            </tr>
                        <?php }
                    }
                }
            }

            ?>

        <?php }
    }
    ?>
    </tbody>
</table>