<?php
if ($tipo_reporte == 'excel') {
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header("content-disposition: attachment;filename=" . $filename . ".xls");
    header("Pragma: no-cache");
    header("Expires: 0");
}
?>

<?php if ($tipo_reporte != '') { ?>
    <style type="text/css">
        .tabla{
            font-weight: normal !important;
            /*width: 100% !important;*/
        }

        .tabla th{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla td{
            border:1px solid black;
            vertical-align: middle;
            text-align: center;
        }

        .tabla{
            border:1px solid black;
        }

        .num {
            mso-number-format:General;
        }
        .text{
            mso-number-format:"\@";/*force text*/
        }
    </style>
<?php } ?>

<?php if ($tipo_reporte == 'excel') { ?>
    <meta charset="utf-8" />
    <div class="head">
        <table>
            <tr>
                <td align="center" colspan="7" >
                    <h4>
                        <?php
                        echo mb_strtoupper($this->gsatelite->get_parametro('SYS_EMPRESA'), 'UTF-8');
                        ?> <br />
                      Reporte de cumplimiento por consultor
                    </h4>
                </td>
            </tr>
        </table>
    </div>
<?php } ?>



<?php
//Si la variable tipo reporte existe se declara la tabla
if ($tipo_reporte != '') {
    ?>
    
    <table class="">
        <tr><td colspan="2"></td></tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Proyecto:</b></td>
            <td style="text-align: left;"><?php echo $nombre_proyecto; ?></td>            
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Sprint:</b></td>
            <td style="text-align: left;"><?php echo $nombre_sprint; ?></td>            
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Fechas:</b></td>
            <td style="text-align: left;"><?php $fecha = ($fecha_ini_2 !=null && $fecha_ini_1 != NULL)?formatear_fecha('d-m-Y',$fecha_ini_1)." y ".formatear_fecha('d-m-Y',$fecha_ini_2):"Sin fecha";
            echo $fecha;?></td>            
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Consultor:</b></td>
            <td style="text-align: left;"><?php echo $nombre_consultor; ?></td>            
        </tr>
        <tr>
            <td style="width: 10%; text-align: left;"><b>Etapa:</b></td>
            <td style="text-align: left;"><?php echo $nombre_etapa; ?></td>            
        </tr>
        <tr>
            <td></td>
            <td></td>
        </tr>
    </table>
    <div></div>
    <table class="tabla" width="100%">
        <thead>
            <tr>
                <th width="40%"><b>Consultor</b></th>
                <th width="8%"><b>Fecha inicio</b></th>
                <th width="8%"><b>Incidencias</b></th>
                <th width="8%"><b>Horas Planeadas</b></th>
                <th width="8%"><b>Horas asignadas</b></th>
                <th width="8%"><b>Horas efectivas</b></th>
                <th width="10%"><b>Cumplimiento Planificado</b></th>
                <th width="10%"><b>Cumplimiento asignado</b></th>
            </tr>
        </thead>
        <tbody>
        <?php } ?>

        <?php
        $i      = 1;
        foreach ($reporte as $row):
        ?>
            <tr class="dato">
                <td width="40%"><?php echo $row['CONSULTOR']; ?></td>
                <td width="8%"><?php echo formatear_fecha('d-m-Y',$row['FECHA_INICIO']); ?></td>
                <td width="8%"><?php echo $row['INCIDENCIAS']; ?></td>
                <td width="8%"><?php echo number_format($row['HORAS_ESTIM'],2); ?></td>
                <td width="8%"><?php echo $row['HORAS']; ?></td>
                <td width="8%"><?php echo ($row['HORAS_EFECTIVAS']); ?></td>
                <td width="10%"><?php echo number_format($row['CUMPLIMIENTO_2'],2); ?></td>
                <td width="10%"><?php echo number_format($row['HORAS_ASIG'],2); ?></td>
            </tr>
            <?php
            $i++;
        endforeach;
        ?>
        <?php
        //Si la variable tipo reporte existe se declara la tabla
        if ($tipo_reporte != '') {
            ?>
        </tbody> 
    </table>
<?php } ?>

