<meta charset="utf-8" />
<?php foreach ($css_files as $file) : ?>
    <link type="text/css" rel="stylesheet" href="<?php echo $file; ?>" />
<?php endforeach; ?>
<?php foreach ($js_files as $file) : ?>
    <script src="<?php echo $file; ?>"></script>
<?php endforeach; ?>
<style type='text/css'>
    body {
        font-family: Arial;
        font-size: 14px;
    }

    a {
        color: blue;
        text-decoration: none;
        font-size: 14px;
    }

    a:hover {
        text-decoration: underline;
    }
</style>

<!-- Filtros -->
<?php if (end($url) == 'add' || prev($url) == 'edit' || end($url) == 'read' || prev($url) == 'read') { ?>
<?php } else { ?>
    <form method="POST">
        <div class="box">
            <div class="title">
                <h4>
                    <span>Filtro</span>
                </h4>
                <a href="#" class="minimize" style="display: none;">Minimize</a>
            </div>
            <div class="content">
                <div class="form-row row-fluid">
                    <div class="span5">
                        <div class="row-fluid">
                            <label class="span3">Tipo de Lista:</label>
                            <div class="span7 controls labels-info">
                                <select id="slcTipo" name="slcTipo" class="nostyle" placeholder="Seleccione" style="width: 100%;">
                                    <option value=""></option>
                                    <?= $tipo_lista ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="span5">
                        <div class="row-fluid">
                            <div class="span7 controls">
                                <button type="submit" id="btnConsultar" class="btn btn-success">Consultar</button>
                                <br>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php } ?>

<div>
    <?php echo $output; ?>
</div>
<script type="text/javascript">
    jQuery(document).ready(function($) {
        precio_inicial = $("#field-lip_precio").val();
        um_inicial = $("#field-lip_id_mep").val();

        verificar_ultima_entrada();
        $("#field-lip_ultimo_prec_compra, #field-lip_variacion_utilidad").attr('readonly', true);
        $("#slcTipo").select2();
        $("#field-lip_desde,#field-lip_hasta,#field-lip_precio").numeric();
        $("#field-lip_precio").numeric();
        $("#field-lip_descuento_min").numeric();
        $("#field-lip_descuento_max").numeric();
        $(".row-fluid .gradient .title h4:first").append('( <?php echo $registro_art->art_codigo . ' - ' . $registro_art->art_nombre; ?> )')
        $(".container-fluid .span8:first").append('<a title="Regresar" class="btn btn-large regre" href="<?php echo base_url(); ?>cotizaciones/mantenimientos/articulo"><span class="icon16 icomoon-icon-undo-2">Regresar</span></a>');
        $(".regre").css({
            'width': '75px'
        });

        $(".btn-success").click(function(event) {
            setTimeout(function() {
                $("#report-error").html($("#report-error").html().replace('numÃ©ricos', 'númericos'));
                $("#report-error").html($("#report-error").html().replace('numÃ©ricos', 'númericos'));
                $("#report-error").html($("#report-error").html().replace('numÃ©ricos', 'númericos'));
            }, 300);

        });

        $("#field-lip_descuento_min").keyup(function(event) {
            $(this).val(minmax($(this).val(), 0, 100));
        });
        $("#field-lip_descuento_max").keyup(function(event) {
            $(this).val(minmax($(this).val(), 0, 100));
        });

        $("#field-lip_id_mep").change(function(event) {
            var precio = precio_inicial;
            var precio_um = 0;
            if (um_inicial != $("#field-lip_id_mep").val()) {
                url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_conversion');
                $.ajax({
                    url: url_ajax,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        id_unidad: parseInt($("#field-lip_id_mep").val()),
                        id_articulo: parseInt($("#field-lip_id_art").val())
                    },
                    error: function(xhr, status, error) {
                        exportarError(xhr.responseText);
                    },
                    success: function(json) {
                        precio_um = json[0]['cva_conversion'];
                        precio = precio / precio_um;
                        $("#field-lip_precio").val(precio.toFixed(2));
                    }
                });
            } else {
                $("#field-lip_precio").val(precio_inicial);
            }
            verificar_ultima_entrada();
        });

        $("#field-lip_precio").keyup(function(event) {
            verificar_ultima_entrada();
        });

    });

    function obtener_precio_por_um() {
        precio_conversion = 0;

        return precio_conversion;
    }

    function minmax(value, min, max) {
        if (parseInt(value) < min)
            return 0;
        else if (parseInt(value) > max)
            return 100;
        else return value;
    }



    function verificar_ultima_entrada() {
        id_articulo = <?php echo $id_articulo; ?>;
        precio_lista = $("#field-lip_precio").val();
        unidad_medida = $("#field-lip_id_mep").val();
        if (unidad_medida > 0 && precio_lista > 0) {
            url_ajax = window.satelite.base_url('facturacion/entradas/get_valor_ultima_entrada');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    precio_lista: precio_lista,
                    id_articulo: id_articulo,
                    unidad_medida: unidad_medida
                },
                beforeSend: function() {
                    //wait.start();
                },
                error: function(xhr, status, error) {
                    exportarError(xhr.responseText);
                    //wait.close();
                },
                success: function(json) {
                    $("#field-lip_ultimo_prec_compra").val(json.ultima_compra);
                    $("#field-lip_variacion_utilidad").val(json.utilidad);
                    //wait.close();
                }
            });
        }
    }
</script>