<?php
if (isset($cliente_slctd) && count($cliente_slctd) > 0) {
    $id = $cliente_slctd[0]['cli_id'];
    $name = $cliente_slctd[0]['cli_codigo'] . " - ";
    $name .= ($cliente_slctd[0]['cli_personeria'] > 1) ? $cliente_slctd[0]['cli_apellido'] : $cliente_slctd[0]['cli_nombre'] . " " . $cliente_slctd[0]['cli_apellido'];
} else {
    $id = $name = "";
}
?>
<form class="form-horizontal" method="post" id="form_cliente" name="form_cliente">
    <div class="row-fluid">
        <div class="span12">
            <!-- Filtros -->
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Filtros: </span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content" id="idfiltro_enviar">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Segmento:</label>
                                    <div class="span7 controls labels-info">
                                        <select id="slcSegmentos" name="slcSegmentos" class="nostyle">
                                            <option value=""></option>
                                            <?php echo $segmentos; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Cliente:</label>
                                    <div class="span7 controls labels-info">
                                        <input type="hidden" id="txt_cliente" name="txt_cliente" data-nombre="<?= $name ?>" value="<?= $id ?>" class="list" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Documento:</label>
                                    <div class="span7 controls labels-info">
                                        <input type="text" id="txt_documento" name="txt_documento" value="<?php echo $documento_filtro; ?>" />
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Vendedor:</label>
                                    <div class="span7 controls labels-info">
                                        <select id="slcVendedor" name="slcVendedor" class="nostyle">
                                            <option value=""></option>
                                            <?php echo $vendedores; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Clasificación:</label>
                                    <div class="span7 controls labels-info">
                                        <select id="slcClasific" name="slcClasific" class="nostyle">
                                            <option value=""></option>
                                            <?php echo $clasificaciones; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4">Zona Geográfica:</label>
                                    <div class="span7 controls labels-info">
                                        <select id="slcZona" name="slcZona" class="nostyle">
                                            <option value=""></option>
                                            <?php echo $zonas; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php if ($new_filtros) { ?>
                                <div class="span6">
                                    <div class="row-fluid">
                                        <label class="span4">Departamento:</label>
                                        <div class="span7 controls labels-info">
                                            <select id="slc_dep" name="slc_dep" class="nostyle">
                                                <option value=""></option>
                                                <?php echo $departamento; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="span6">
                                    <div class="row-fluid">
                                        <label class="span4">Municipio:</label>
                                        <div class="span7 controls labels-info">
                                            <select id="slc_muni" name="slc_muni" class="nostyle">
                                                <option value=""></option>
                                                <?php echo $municipios; ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="span12">
                            <div class="row-fluid">
                                <div class="span7 controls">
                                    <button type="bubmit" id="btnConsultar" class="btn btn-success">Consultar</button>
                                    <br>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript">
    $(document).ready(function() {
        $('select').select2({
            placeholder: 'Seleccione'
        });

        $('#slcSegmentos').change(function() {
            //El idcac es el id del segmento
            var idcac = $('#slcSegmentos').val();
            //alert(idcac);
            $.ajax({
                dataType: 'text',
                type: 'POST',
                url: urlj + 'cotizaciones/mantenimientos/clientes_x_segmento',
                data: {
                    idcac: idcac
                },
                beforeSend: function() {
                    wait.start();
                },
                success: function(data) {
                    $('#txt_cliente').html(data);
                    $('select').select2({
                        placeholder: 'Seleccione'
                    });
                    wait.close();
                }
            });
        });

        $("#slc_dep").change(function() {
            if ($(this).val() != "") {
                departamento = $("#slc_dep").val();
                $.ajax({
                    dataType: 'json',
                    type: 'post',
                    data: {
                        departamento: departamento
                    },
                    url: urlj + 'cotizaciones/mantenimientos/get_municipio',
                    success: function(data) {
                        $("#slc_muni").select2('destroy');
                        $("#slc_muni").html(data);
                        $("#slc_muni option[value='0']").text('');
                        $("#slc_muni option[value='0']").val('');
                        $("#slc_muni").select2({
                            placeholder: 'Seleccione'
                        });

                    }
                });
            }
        });

        $("#txt_cliente").select2({
            placeholder: 'Buscar clientes',
            minimumInputLength: 3,
            ajax: {
                url: urlj + 'cotizaciones/cotizaciones/get_clientes',
                dataType: 'json',
                type: 'POST',
                delay: 250,
                data: function(cliente) {
                    return {
                        cliente: cliente
                    };
                },
                results: function(data) {
                    var myResults = [];
                    $.each(data, function(index, item) {
                        myResults.push({
                            'id': item.cliente,
                            'text': item.cliente_nombre,
                        });
                    });
                    return {
                        results: myResults
                    };
                }
            },
            initSelection: function(element, callback) {
                var idElemento = element[0].id;
                var valor = $("#" + idElemento).val();
                if (valor !== "") {
                    var texto = $("#" + idElemento).data('nombre');
                    callback({
                        id: valor,
                        text: texto
                    });
                }
            }
        });

    });
</script>