<meta charset="utf-8" />
<style type='text/css'>
    body {
        font-family: Arial;
        font-size: 14px;
    }

    a {
        color: blue;
        text-decoration: none;
        font-size: 14px;
    }

    a:hover {
        text-decoration: underline;
    }
</style>
<form id="frm-presupuesto" method="POST">
    <div class="row-fluid">
        <div class="span12">
            <div class="box">
                <div class="title">
                    <h4><span>Detalles de la cotización</span></h4>
                    <input type="hidden" name="cotizacion" id="cotizacion" value="<?= $cot_id ?>">
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span4 form-label">Código Cotización:</label>
                                    <div class="span7 controls">
                                        <input type="text" id="txtOrden" name="txtOrden" readonly="readonly" value="<?php echo $cotizacion['cot_codigo']; ?>" />
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3 form-label">Cliente:</label>
                                    <div class="span7 controls">
                                        <?php
                                        $nombre_cliente = $cotizacion['cli_codigo'] . " - ";
                                        $nombre_cliente .= ($cotizacion['cli_personeria'] == 1) ? $cotizacion['cli_nombre'] . ' ' . $cotizacion['cli_apellido'] : $cotizacion['cli_apellido'];
                                        ?>
                                        <input type="text" id="txtCliente" readonly="readonly" value="<?php echo $nombre_cliente; ?>" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3 form-label">Producto:</label>
                                    <div class="span7 controls">
                                        <input type="hidden" id="art_id" value="<?php echo $producto['art_id']; ?>">
                                        <input type="text" id="txtProductoOrden" readonly="readonly" value="<?php echo $producto['art_codigo'] . ' - ' . $producto['art_nombre']; ?>" />
                                    </div>
                                </div>
                            </div>
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3 form-label">Cantidad:</label>
                                    <div class="span7 controls">
                                        <input type="text" id="txtCantidadProd" name="txtCantidadProd" readonly="readonly" value="<?php echo number_format($producto['axc_cantidad'], $decimales, '.', ','); ?>" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span6">
                                <div class="row-fluid">
                                    <label class="span3 form-label">Presentación:</label>
                                    <div class="span7 controls">
                                        <input type="hidden" id="cva_defecto" value="<?php echo $producto['cva_id']; ?>">
                                        <input type="text" id="txtMedidaProducto" readonly="readonly" value="<?php echo $producto['mep_nombre']; ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Materia Prima -->
            <div class="box">
                <div class="title">
                    <h4><span>Materia Prima</span></h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span4 form-label">Proveedor:</label>
                                <div class="span7 controls">
                                    <select id="slcProveedor" class="nostyle">
                                        <?php echo $proveedores; ?>
                                    </select>
                                    <br />
                                    <div id="slcProveedor_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span4 form-label">Materia Prima:</label>
                                <div class="span7 controls">
                                    <select id="slcMateriaPrima" class="nostyle">
                                        <?php echo $materia_prima; ?>
                                    </select>
                                    <br />
                                    <div id="slcMateriaPrima_error" class="div-error"></div>
                                    <input type="hidden" id="hdnProducto" value="">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span4 form-label">Unidad Medida:</label>
                                <div class="span7 controls">
                                    <select id="slcMedida" class="nostyle">
                                        <option></option>
                                    </select>
                                    <br />
                                    <div id="slcMedida_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span4 form-label">Tipo de Precio:</label>
                                <div class="span7 controls">
                                    <select id="slcTipoPrecio" class="nostyle">
                                        <option></option>
                                        <option value="1">Costo Promedio</option>
                                        <option value="2">Última compra</option>
                                        <option value="3">Última Producción</option>
                                    </select>
                                    <br />
                                    <div id="slcTipoPrecio_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span4 form-label">Precio:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtPrecio" class="soloDecimales" maxlength="19" />
                                    <br />
                                    <div id="txtPrecio_error" class="div-error"></div>
                                    <input type="hidden" id="precio_temp" value="0">
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span4 form-label">Cantidad:</label>
                                <div class="span7 controls">
                                    <input type="hidden" id="cantidaddecimales" value="<?php echo $decimalescantidad['receta_producto']; ?>" />
                                    <input type="text" id="txtCantidad" class="soloDecimales" decimales="6" maxlength="" />
                                    <br />
                                    <div id="txtCantidad_error" class="div-error"></div>
                                    <input type="hidden" id="decimales" class="soloDecimales" value="<?php echo $decimales; ?>" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <button type="button" class="btn btn-primary" id="btnAgregarMateria"><span class="entypo-icon-add"> Agregar Materia Prima</span></button>
                            <?php if ($permite_actualizar > 0 && count($materia_prima_prod) > 0) { ?>
                                <button type="button" class="btn btn-info" id="actualizar_precios"><span class="entypo-icon-retweet"> Actualizar Precios</span></button>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="form-row row-fluid">
                        <div class="span12" style="width: 99%;">
                            <table class="simpleTable responsive table table-bordered contenedor" id="tblMateriaPrima">
                                <thead id="thMateriaPrima">
                                    <th>C&oacute;digo</th>
                                    <th>Materia Prima</th>
                                    <th>UM.</th>
                                    <th style="width:18%;">Proveedor</th>
                                    <th>Cantidad</th>
                                    <th>Precio</th>
                                    <th>Subtotal</th>
                                    <th>
                                        <div>Aplica est.&nbsp;&nbsp;<input type="checkbox" id="allMat" value="1" class="nostyle" style="width: auto;"></div>
                                    </th>
                                    <th>Acciones</th>
                                </thead>
                                <tbody id="tbMateriaPrima">
                                    <?php
                                    $totalMateriaPrima = 0;
                                    if (count($materia_prima_prod) > 0) :
                                        $i = 0;
                                        foreach ($materia_prima_prod as $axr) :
                                            $detalle_id       = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? $axr['axr_id'] : 0;
                                            $materia_prima_id = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? $axr['axr_id_art_materia'] : $axr['mpa_id_art_materia'];
                                            if (isset($axr['mpa_id']) && ($axr['mpa_id'] != null)) {
                                                $conversion_id = $axr['cva_id'];
                                            } elseif (isset($axr['axr_id_art_materia']) && ($axr['axr_id_art_materia'] != null)) {
                                                $conversion_id = $axr['axr_id_cva'];
                                            }
                                            $materia_prima_cod    = $axr['art_codigo'];
                                            $materia_prima_nombre = $axr['art_nombre'];
                                            $medida_nombre        = $axr['mep_nombre'];
                                            $proveedor_id         = $axr['prv_id'];
                                            $nombre_proveedor     = $axr['prv_nombre'];
                                            $nombre_proveedor    .= ($axr['prv_tipo_pers'] == 1) ? ' ' . $axr['prv_apellido'] : "";
                                            $selected_proveedor   = ($axr['prv_nombre'] != '') ? 'selected=selected' : "";
                                            $cantidadMateria      = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? $axr['axr_cantidad'] : ($axr['mpa_cantidad'] * $producto['axc_cantidad']);
                                            // $precio1              = ($axr['axr_precio']  != '' && $axr['axr_precio'] > 0) ? $axr['axr_precio'] : $axr['mpa_precio'];
                                            // $precio2              = ($axr['tipos_precio'] != '' && $axr['tipos_precio'] > 0) ? $axr['tipos_precio'] : $axr['mpa_precio'];
                                            // $precioMateria        = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? $precio1 : $precio2;
                                            $precioMateria        = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? $axr['axr_precio'] : $axr['tipos_precio'];

                                            $subtotalMateriaPrima    = $cantidadMateria * $precioMateria;

                                            $totalMateriaPrima += $subtotalMateriaPrima;

                                            $checkeado = (isset($axr['axr_id']) && $axr['axr_id'] != null) ? $axr['axr_estimacion_porcentaje'] : $axr['mpa_estimacion_porcentaje'];
                                            $checkear = ($checkeado == 1) ? 'checked' : '';
                                    ?>
                                            <tr id="trMp_<?php echo $materia_prima_id; ?>" class="trMateriaPrima" data-id="<?php echo $i; ?>">
                                                <td style="width:6%">
                                                    <input type="hidden" name="hdnDetalleMateria[]" class="tables-input" value="<?php echo $detalle_id; ?>" />
                                                    <input type="text" class="text tables-input select-text" value="<?php echo $materia_prima_cod; ?>" readonly="readonly" />
                                                </td>
                                                <td style="width:20%; font-size:11px;color:#777;font-weight:bold;">
                                                    <?php echo $materia_prima_nombre; ?>
                                                    <!-- <input type="text" class="text tables-input select-text" value="<?php echo $materia_prima_nombre; ?>" readonly="readonly"/> -->
                                                    <select id="slcMateriaPrima_'<?php echo $i; ?>" data-id="<?php echo $i; ?> " name="materiaPrima[]" style="display:none;" class="materiaPrima select-edit">
                                                        <option selected="selected" value="<?php echo $materia_prima_id; ?>"><?php echo $materia_prima_nombre; ?></option>
                                                    </select>
                                                    <input type="hidden" class="id_materia" id="id_materia_<?= $i ?>" value="<?= $materia_prima_id ?>" data-id="<?= $i ?>">
                                                </td>
                                                <td style="width:5%">
                                                    <input type="text" class="text tables-input select-text" value="<?php echo $medida_nombre; ?>" readonly="readonly" />
                                                    <select id="slcMedida_<?php echo $i; ?>" data-id="<?php echo $i; ?> " name="conversionesMateria[]" style="display:none;" class="conversionMateria select-edit">
                                                        <option selected="selected" value="<?php echo $conversion_id; ?>"><?php echo $medida_nombre; ?></option>
                                                    </select>
                                                </td>
                                                <td style="width:15%">
                                                    <label class="text tables-input select-text"><?php echo $nombre_proveedor; ?></label>
                                                    <select id="slcProveedor_<?php echo $i; ?>" data-id="<?php echo $i; ?>" name="proveedoresMateria[]" style="display:none;" class="proveedorMateria select-edit">
                                                        <option <?php echo $selected_proveedor; ?> value="<?php echo $proveedor_id; ?>"><?php echo $nombre_proveedor; ?></option>
                                                    </select>
                                                </td>
                                                <td style="width:7%">
                                                    <input type="text" id="txtCantidad_<?php echo $i; ?>" name="cantidadesMateria[] " class="text tables-input-show tables-input soloDecimales cantidadMateria edit" value="<?php echo number_format($cantidadMateria, $decimales, '.', ','); ?>" readonly="readonly" decimales="<?php echo $decimales; ?>" />
                                                </td>
                                                <td style="width:7%">
                                                    <input type="text" id="txtPrecio_<?php echo $i; ?>" name="preciosMateria[]" class="text tables-input-show tables-input soloDecimales precioMateria edit" value="<?php echo number_format($precioMateria, $decimales, '.', ','); ?>" readonly="readonly" decimales="<?php echo $decimales; ?>" />
                                                </td>
                                                <td style="width:8%">
                                                    <input type="text" id="txtSubtotal_<?php echo $i; ?>" names="subtotalesMateria[]" class="text tables-input-show tables-input subtotalMateria" extras="." value="<?php echo number_format($subtotalMateriaPrima, $decimales, '.', ','); ?>" readonly="readonly" />
                                                </td>
                                                <td style="width:8%;text-align: center;">
                                                    <input type="checkbox" id="chkEstMateria_<?php echo $i; ?>" data-subtotal="txtSubtotal_<?php echo $i; ?>" class="nostyle aplicar_estimacion est_materia" <?= $checkear ?> />
                                                    <input type="hidden" name="chkEstMateria[]" value="<?= $checkeado ?>" />
                                                </td>
                                                <td style="width:8%">
                                                    <button type="button" class="btn btn-primary btn-mini editar_fila btnEditMateriaPrima" data-edit="<?php echo $i; ?> " style="float:left; height:30px;width:50px;"> Editar</button>
                                                    <button type="button" class="btn btn-primary btn-mini materiaPrima guardar_fila" data-edit="<?php echo $i; ?>" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>
                                                    <button type="button" class="btn btn-danger btn-mini btnDelMateriaPrima" style="float:left; margin-left:5%; height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>
                                                </td>
                                            </tr>
                                    <?php
                                            $i++;
                                        endforeach;
                                    endif;
                                    ?>
                                </tbody>
                                <tfoot id="tfMateriaPrima">
                                    <tr>
                                        <td colspan="6">Total:</td>
                                        <td>
                                            <input type="text" id="txtTotalMateria" name="txtTotalMateria" value="<?php echo number_format($totalMateriaPrima, $decimales, '.', ','); ?>" readonly="readonly" style="margin: 0px;" />
                                        </td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!--/Materia Prima -->

            <!-- Mano de Obra-->
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Mano de Obra</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Mano de obra:</label>
                                <div class="span7 controls">
                                    <select id="slcManoObra" class="nostyle">
                                        <option></option>
                                        <?php
                                        if (count($mano_obra) > 0) :
                                            foreach ($mano_obra as $mob) :
                                        ?>
                                                <option data-etapas="<?php echo $mob['mob_calculo_etapa']; ?>" data-codigo="<?php echo $mob['mob_codigo']; ?>" data-precio="<?php echo $mob['mob_precio']; ?>" value="<?php echo $mob['mob_id'] ?>"><?php echo $mob['mob_nombre']; ?></option>
                                        <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </select>
                                    <br />
                                    <div id="slcManoObra_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6" style="margin-bottom: 5px;">
                            <div class="row-fluid">
                                <label class="span3 form-label">Responsable:</label>
                                <div class="span7 controls" id="dvResponsable">
                                    <input type="hidden" id="slcResponsable" class="nostyle buscarResponsable" />
                                    <br />
                                    <div id="slcResponsable_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Precio:</label>
                                <div class="span7 controls">
                                    <input type="hidden" id="decimales" readonly="readonly" value="<?php echo $decimales; ?>" />
                                    <input type="text" id="txtPrecioMob" class="soloDecimales" maxlength="19" />
                                    <br />
                                    <div id="txtPrecioMob_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Cantidad:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtCantidadMob" class="soloDecimales" maxlength="" />
                                    <br />
                                    <div id="txtCantidadMob_error" class="div-error"></div>
                                </div>
                                <div style="display:none">
                                    <select name="emp_default[]" id="emp_default" placeholder="Seleccione" class="nostyle">
                                        <?php echo $emp_default; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span7 controls">
                                <button type="button" class="btn btn-info" id="btnAgregarMob">Agregar</button>
                            </div>
                        </div>
                        <div class="span12" style="width: 99%;">
                            <table class="simpleTable responsive table table-bordered contenedor" id="tblManoObra">
                                <thead id="thManoObra">
                                    <th>C&oacute;digo</th>
                                    <th>Mano de Obra</th>
                                    <th style="width:15%;">Responsable</th>
                                    <th>Cantidad</th>
                                    <th>Precio</th>
                                    <th>Subtotal</th>
                                    <th>
                                        <div>Aplica est.&nbsp;&nbsp;<input type="checkbox" id="allObr" value="1" class="nostyle" style="width: auto;"></div>
                                    </th>
                                    <th>Acciones</th>
                                </thead>
                                <tbody id="tbManoObra">
                                    <?php
                                    $totalMob = 0;
                                    if (count($mano_obra_prod) > 0) :
                                        $i = 0;
                                        $j = null;
                                        foreach ($mano_obra_prod as $mxa) :
                                            $detalle_id = (isset($mxa['mxa_id']) && $mxa['mxa_id'] != null) ? $mxa['mxa_id'] : 0;
                                            $empleado_id = $mxa['emp_id'];
                                            $nombre_empleado = $mxa['emp_codigo'] . ' - ' . $mxa['emp_nombre'] . ' ' . $mxa['emp_apellido'];

                                            $mano_obra_id = $mxa['mob_id'];
                                            $mano_obra_cod = $mxa['mob_codigo'];
                                            $mano_obra_nombre = $mxa['mob_nombre'];
                                            $horas_etapa = ($mxa['mob_calculo_etapa'] > 0) ? 1 : $producto['axc_cantidad'];
                                            $cantidadMob = (isset($mxa['mxa_id']) && $mxa['mxa_id'] != null) ? $mxa['mxa_cantidad'] : ($mxa['moa_cantidad'] * $horas_etapa);
                                            $precioMob = (isset($mxa['mxa_id']) && $mxa['mxa_id'] != null) ? $mxa['mxa_precio'] : $mxa['mob_precio'];
                                            $subtotalMob = ($precioMob * $cantidadMob);
                                            $totalMob += $subtotalMob;

                                            $checkeado = (isset($mxa['mxa_id']) && $mxa['mxa_id'] != null) ? $mxa['mxa_estimacion_porcentaje'] : $mxa['moa_estimacion_porcentaje'];
                                            $checkear = ($checkeado == 1) ? 'checked' : '';
                                            $j = $mxa['mob_id'] . '_' . $mxa['emp_id'];

                                            $empleados = $this->gsatelite->get_dropdown('emp_empleado', '{emp_codigo} - {emp_nombre}' . ' ' . '{emp_apellido}', '', array('emp_estado' => 1), $empleado_id, '', 'emp_id', true);
                                    ?>
                                            <tr id="trMob_<?php echo $j; ?>" class="trManoObra" data-id="<?php echo $i; ?>">
                                                <td style="width:10%">
                                                    <input type="hidden" name="hdnDetalleMob[]" class="tables-input" value="<?php echo $detalle_id; ?>" />
                                                    <input type="text" class="text tables-input select-text" value="<?php echo $mano_obra_cod; ?>" readonly="readonly" />
                                                </td>
                                                <td style="width:23%">
                                                    <input type="text" class="text tables-input select-text" value="<?php echo $mano_obra_nombre; ?>" readonly="readonly" />
                                                    <select id="slcManoObra_<?php echo $i; ?>" data-id="<?php echo $i; ?>" name="manoObra[]" style="display:none;" class="manoObra select-edit">
                                                        <option selected="selected" value="<?php echo $mano_obra_id; ?>"><?php echo $mano_obra_nombre; ?></option>
                                                    </select>
                                                </td>
                                                <td style="width:23%">
                                                    <label class="text tables-input select-text<?php echo $i; ?>"><?php echo $nombre_empleado; ?></label>
                                                    <input type="hidden" id="slcResponsable_<?php echo $i; ?>" name="responsanblesMob[]" class="nostyle select-edit buscarResponsable resp_edit" value="<?php echo $empleado_id; ?>" />
                                                    <select name="empleados_edit[]" id="empleado_edit_<?php echo $i; ?>" placeholder="Seleccione" class="nostyle slc_edit" style="width:90%;">
                                                        <?php echo $empleados; ?>
                                                    </select>
                                                </td>
                                                <td style="width:10%">
                                                    <input type="text" id="txtCantidadMob_<?php echo $i; ?>" name="cantidadesMob[]" class="text tables-input-show tables-input soloDecimales cantidadMob edit" value="<?php echo number_format($cantidadMob, $decimales, '.', ''); ?>" readonly="readonly" />
                                                </td>
                                                <td style="width:10%">
                                                    <input type="text" id="txtPrecioMob_<?php echo $i; ?>" name="preciosMob[]" class="text tables-input-show tables-input soloDecimales precioMob edit" value="<?php echo number_format($precioMob, $decimales, '.', ','); ?>" readonly="readonly" />
                                                </td>
                                                <td style="width:10%">
                                                    <input type="text" id="txtSubtotalMob_<?php echo $i; ?>" names="subtotalesMob[]" class="text tables-input-show tables-input subtotalMob" extras="." value="<?php echo number_format($subtotalMob, $decimales, '.', ','); ?>" readonly="readonly" />
                                                </td>
                                                <td style="width:10%;text-align: center;">
                                                    <input type="checkbox" id="chkEstMob_<?php echo $i; ?>" data-subtotal="txtSubtotalMob_<?php echo $i; ?>" class="nostyle aplicar_estimacion est_mano" <?= $checkear ?> />
                                                    <input type="hidden" name="chkEstMob[]" value="<?= $checkeado ?>" />
                                                </td>
                                                <td style="width:14%">
                                                    <button type="button" class="btn btn-primary btn-mini editar_fila ManoObra" data-edit="<?php echo $i; ?>" style="float:left; height:30px;width:50px;"> Editar</button>
                                                    <button type="button" class="btn btn-primary btn-mini ManoObra guardar_fila" data-edit="<?php echo $i; ?>" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>
                                                    <button type="button" class="btn btn-danger btn-mini btnDelManoObra" style="float:left;height:30px;width:50px;margin-left:5%;">Eliminar</button>
                                                </td>
                                            </tr>
                                    <?php
                                            $i++;
                                        endforeach;
                                    endif;
                                    ?>
                                </tbody>
                                <tfoot id="tfManoObra">
                                    <tr>
                                        <td colspan="5">Total:</td>
                                        <td>
                                            <input type="text" id="txtTotalManoObra" name="txtTotalManoObra" value="<?php echo number_format($totalMob, $decimales, '.', ','); ?>" readonly="readonly" style="margin: 0px;" />
                                        </td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!--/ Mano de Obra-->
            <!-- Gastos Indirectos -->
            <div class="box">
                <div class="title">
                    <h4>
                        <span>Gastos Indirectos de Fabricación</span>
                    </h4>
                    <a href="#" class="minimize" style="display: none;">Minimize</a>
                </div>
                <div class="content">
                    <div class="form-row row-fluid">
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Estimación de gastos:</label>
                                <div class="span7 controls">
                                    <select id="slcEstimacion" class="nostyle">
                                        <option></option>
                                        <?php
                                        if (count($estimaciones) > 0) :
                                            foreach ($estimaciones as $esm) :
                                                $valort = ($esm['esm_tipo_calculo'] > 0) ? 'Monto' : 'Porcentaje';
                                        ?>
                                                <option data-etapas="<?php echo $esm['esm_calculo_etapa']; ?>" data-codigo="<?php echo $esm['esm_codigo']; ?>" data-valort="<?php echo $valort; ?>" data-valor="<?php echo $esm['esm_tipo_calculo']; ?>" data-monto="<?php echo $esm['esm_monto']; ?>" value="<?php echo $esm['esm_id'] ?>"><?php echo $esm['esm_nombre']; ?></option>
                                        <?php
                                            endforeach;
                                        endif;
                                        ?>
                                    </select>
                                    <br />
                                    <div id="slcEstimacion_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Valor:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtPrecioGasto" class="soloDecimales" maxlength="19" />
                                    <br />
                                    <div id="txtPrecioGasto_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Cantidad:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtCantidadGasto" class="soloDecimales" value="1" />
                                    <br />
                                    <div id="txtCantidadGasto_error" class="div-error"></div>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="span7 controls">
                                <button type="button" class="btn btn-info" id="btnAgregarGasto">Agregar</button>
                            </div>
                        </div>
                        <div class="span12" style="width: 99%;">
                            <table class="simpleTable responsive table table-bordered contenedor" id="tblGastos">
                                <thead id="thManoObra">
                                    <th>C&oacute;digo</th>
                                    <th>Estimación</th>
                                    <th>Tipo de cálculo</th>
                                    <th>Cantidad</th>
                                    <th>valor</th>
                                    <th>Subtotal ($)</th>
                                    <th>Acciones</th>
                                </thead>
                                <tbody id="tbGastos">
                                    <?php
                                    $totalGasto = 0;
                                    if (count($gastos_indirectos) > 0) :
                                        $i = 0;
                                        foreach ($gastos_indirectos as $exa) :
                                            $estimacion_id = $exa['esm_id'];
                                            $detalle_id = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_id'] : 0;
                                            $codigo_estimacion = $exa['esm_codigo'];
                                            $nombre_estimacion = $exa['esm_nombre'];

                                            $gastos_indirectos = ($exa['esm_tipo_calculo'] == 0) ? 'Porcentaje' : 'Monto';
                                            $gastos_indirectos_n = $exa['esm_tipo_calculo'];


                                            if (isset($exa['exa_id']) && $exa['exa_id'] != null) {
                                                $precio_gasto = $exa['exa_precio'];
                                            } else {
                                                $precio_gasto = ($exa['esm_calculo_etapa'] > 0) ? $exa['esm_monto'] : $exa['esr_precio'];
                                            }


                                            $subtotalGasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_monto_calculo'] : $exa['esr_monto_calculo'];

                                            if ($gastos_indirectos_n == 1) {
                                                $horas_etapa = ($exa['esm_calculo_etapa'] > 0) ? 1 : $producto['axc_cantidad'];
                                                $cantidad_gasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_cantidad'] : ($exa['esr_cantidad'] * $horas_etapa);

                                                $subtotalGasto = ($cantidad_gasto * $precio_gasto);
                                            } else {
                                                $cantidad_gasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_cantidad'] : ($exa['esr_cantidad']);
                                                $subtotalGasto = (isset($exa['exa_id']) && $exa['exa_id'] != null) ? $exa['exa_monto_calculo'] : $exa['esr_monto_calculo'];
                                            }
                                            $totalGasto += $subtotalGasto;
                                    ?>
                                            <tr id="trGst_<?php echo $estimacion_id; ?>" class="trGastosInd" data-id="<?php echo $i; ?>">
                                                <td>
                                                    <input type="hidden" name="hdnDetalleGst[]" class="tables-input" value="<?php echo $detalle_id; ?>" />
                                                    <input type="text" class="text tables-input select-text" value="<?php echo $codigo_estimacion; ?>" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <input type="text" class="text tables-input select-text" value="<?php echo $nombre_estimacion; ?>" readonly="readonly" />
                                                    <select id="slcEstimacion_<?php echo $i; ?>" data-id="<?php echo $i; ?>" name="estimacionesGasto[]" style="display:none;" class="estimacionGasto select-edit">
                                                        <option selected="selected" value="<?php echo $estimacion_id; ?>"><?php echo $exa['esm_nombre']; ?></option>
                                                    </select>
                                                </td>
                                                <td>
                                                    <input type="text" id="txtTipoCalculo_<?php echo $i; ?>" name="TiposCalculos[]" class="text tables-input-show tables-input otros_gastos edit" data-valor="<?php echo $gastos_indirectos_n; ?>" data-correlativo="<?php echo $i; ?>" value="<?php echo $gastos_indirectos; ?>" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <input type="text" id="txtCantidadGasto_<?php echo $i; ?>" name="cantidadesGasto[]" class="text tables-input-show tables-input soloNumeros cantidadGasto edit" value="<?php echo number_format($cantidad_gasto, $decimales, '.', ''); ?>" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <input type="text" id="txtPrecioGasto_<?php echo $i; ?>" name="preciosGasto[]" class="text tables-input-show tables-input soloDecimales precioGasto edit" value="<?php echo number_format($precio_gasto, $decimales, '.', ','); ?>" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <input type="text" id="txtSubtotalGasto_<?php echo $i; ?>" name="subtotalesGasto[]" class="text tables-input-show tables-input subtotalGasto" extras="." value="<?php echo number_format($subtotalGasto, $decimales, '.', ','); ?>" readonly="readonly" />
                                                </td>
                                                <td>
                                                    <!--<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditGastoPrima" data-edit="<?php echo $i; ?>" style="float:left; height:30px;width:50px;"> Editar</button>-->
                                                    <button type="button" class="btn btn-primary btn-mini gastoPrima guardar_fila" data-edit="<?php echo $i; ?>" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>
                                                    <button type="button" class="btn btn-danger btn-mini btnDelGasto" style="float:left;height:30px;width:50px;margin-left:5%;">Eliminar</button>
                                                </td>
                                            </tr>
                                    <?php
                                            $i++;
                                        endforeach;
                                    endif;
                                    $totalCosto = $totalMateriaPrima + $totalMob + $totalGasto;
                                    ?>
                                </tbody>
                                <tfoot id="tfGastos">
                                    <tr>
                                        <td colspan="5">Total:</td>
                                        <td>
                                            <input type="text" id="txtTotalGastos" name="txtTotalGastos" value="<?php echo number_format($totalGasto, $decimales, '.', ','); ?>" readonly="readonly" style="margin: 0px;" />
                                        </td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <!--  <div class="span6">
                            <div class="row-fluid">
                                <label class="span3 form-label">Total Costo:</label>
                                <div class="span7 controls">
                                    <input type="text" id="txtTotalCostos" name="txtTotalCostos" value="<?php //echo number_format($totalCosto, 2); 
                                                                                                        ?>" readonly="readonly"/>
                                </div>
                            </div>
                        </div>
                        <div class="span12">
                            <div class="row-fluid">
                                <label class="span3 form-label">Observación:</label>
                                <div class="span7 controls">
                                    <textarea id="txtObservacion" name="txtObservacion" maxlength="1000"></textarea>
                                </div>
                            </div>
                        </div> -->
                        <div class="clear"></div>
                        <div class="form-row row-fluid">
                            <div class="span9">
                                <div class="row-fluid">
                                    <?php
                                    $cantidad = $producto['axc_cantidad'];
                                    if (count($acs)) {
                                        foreach ($acs as $costo) {
                                            $porcn             = $costo['acs_porcentaje_marg'];
                                            $margen            = $costo['acs_margen'];
                                            $prec              = $costo['acs_precio'];
                                            $obs               = $costo['acs_observacion'];
                                            $precio_unitario   = $prec / $cantidad;
                                        }
                                    } else {
                                        $porcn              = "";
                                        $margen             = "";
                                        $prec               = "";
                                        $obs                = "";
                                        $precio_unitario    = $prec;
                                    }
                                    ?>

                                    <table width="100%">
                                        <tr>
                                            <td width="20%">Costo Total:</td>
                                            <td width="80%"><input class="span8 " id="txtTotalCostos" name="txtTotalCostos" type="text" style="width:20%; height:8px; margin-bottom:1%;" readonly value="<?php echo number_format($totalCosto, $decimales); ?>" /></td>
                                        </tr>
                                        <tr>
                                            <td width="20%">Costo unitario ($):</td>
                                            <td width="80%"><input class="span8 " value="<?php echo number_format(($totalCosto / $producto['axc_cantidad']), $decimales); ?>" id="txt_total_unitario" name="txt_total_unitario" type="text" style="width:20%; height:8px; margin-bottom:1%;" readonly /></td>
                                        </tr>
                                        <tr>
                                            <td width="20%">Margen (%):</td>
                                            <td width="80%"><input class="span8 soloDecimales" extras="." value="<?php if ($porcn > 0) {
                                                                                                                        echo number_format($porcn, $decimales);
                                                                                                                    } ?>" id="porcentaje" name="porcentaje" type="text" style="width:20%; height:8px; margin-bottom:1%;" /></td>
                                        </tr>
                                        <tr>
                                            <td width="20%">Margen ($):</td>
                                            <td width="80%"><input class="span8 " value="<?php if ($margen > 0) {
                                                                                                echo number_format($margen, $decimales);
                                                                                            } ?>" id="margen" name="margen" type="text" style="width:20%; height:8px; margin-bottom:1%;" readonly /></td>
                                        </tr>
                                        <tr>
                                            <td width="20%">Precio ($):</td>
                                            <td width="80%"><input class="span8 " value="<?php if ($prec > 0) {
                                                                                                echo number_format($prec, $decimales);
                                                                                            } ?>" id="pre_esm" name="pre_esm" type="text" style="width:20%; height:8px; margin-bottom:1%;" readonly /></td>
                                        </tr>
                                        <tr>
                                            <td width="20%">Precio unitario ($):</td>
                                            <td width="80%"><input class="span8 " value="<?php if ($precio_unitario > 0) {
                                                                                                echo number_format($precio_unitario, $decimales);
                                                                                            } ?>" id="txt_precio_unitario" name="txt_precio_unitario" type="text" style="width:20%; height:8px; margin-bottom:1%;" readonly /></td>
                                        </tr>
                                        <tr>
                                            <td width="20%"></td>
                                            <td width="80%"></td>
                                        </tr>
                                    </table>

                                    <br><br>

                                    Observaciones:<textarea id="observacion" name="observacion"><?php if (trim($obs) != '') {
                                                                                                    echo $obs;
                                                                                                } ?></textarea><input type="hidden" name="axc" id="axc" value="<?php echo $axc; ?>"><input type="hidden" name="id_cot" value="<?php echo $id_cot; ?>"><br><br>
                                </div>
                            </div>
                        </div>
                        <div class="form-actions span12 center">
                            <button class="btn btn-success icomoon-icon-checkmark white" name="btnCrear" type="submit" value="1"> Guardar</button>
                            <button class="btn btn-success icomoon-icon-checkmark white" name="btnCrear" type="submit" value="2"> Guardar y volver a la lista</button>
                            <a href="<?php echo base_url('cotizaciones/cotizaciones/presupuesto_cotizacion/' . $cot_id); //. $orden['ord_id']); 
                                        ?>" class="btn btn-danger btn-cancelar" id=""><span class="icon16 icomoon-icon-cancel-2 white"></span>Cancelar</a>
                            <div align="left">
                                <br>
                                Campos con asterisco en <font color='FE2E2E'>rojo</font> son requeridos
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script type="text/javascript" src="<?= base_url() ?>js/cotizaciones/procesos/frmPresupuestoCot.js"></script>