<?php

/*************************************************************************************************************************************/
/*                                                        Configuraciones                                                            */
/*************************************************************************************************************************************/

$empresa        = $this->gsatelite->get_parametro('SYS_EMPRESA');
$dir_empresa    = $this->gsatelite->get_parametro('SYS_DIR');
$tel_empresa    = $this->gsatelite->get_parametro('SYS_TEL');
$tipo_fuente    = $this->gsatelite->get_parametro('SYS_FUENTE_TITULO');
$eje_ventas     = ($consulta[0]['ven_nombre'] != "" && $consulta[0]['ven_apellidos'] != "") ? $consulta[0]['ven_nombre'] . ' ' . $consulta[0]['ven_apellidos'] : $this->gsatelite->get_parametro('COT_GERENTE_ADMINISTRATIVO');
// Altura del texto
$alt_txt_titulo = 35;
// Declaracion de variables globals
$neto           = 0;
$decimales      = (isset($decimales) && $decimales > 0) ? $decimales : 2;
$tamanio_letra  = 10;
// Configurar banner y verificar si existe el archivo
// $ruta_imagen = "/media/imagenes/sistema/banner_logos_arca.png";
// $imagen = base_url("/media/imagenes/sistema/banner_logos_arca.png");
$imagen = base_url("/media/imagenes/sistema/" . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . ".png");
if (!isset($imagen) && !file_exists($imagen)) {
    $imagen = "";
}
// Calculo de dias
$f1     = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['cot_fecha_pres']));
$f2     = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['cot_fecha_entrega']));
$dias   = ($consulta[0]['cot_fecha_pres'] != "" && $consulta[0]['cot_fecha_entrega'] != "") ? $f1->diff($f2) : '';
/*************************************************************************************************************************************/
?>
<!-- Configuraciones CSS -->
<style type="text/css">
    .fuente_titulo {
        font-family: <?php echo $tipo_fuente; ?>;
    }
</style>
<!-- Tabla principal -->
<table border="0">
    <tr>
        <td width="5%"></td> <!-- Espacio para colocar el contendo a la izquierda -->
        <td width="95%" height="<?= $alt_txt_titulo ?>px"></td> <!-- Espacio para colocar el contenido hacia abajo -->
    </tr>
    <tr>
        <td></td>
        <td>
            <table border="0" cellpadding="0" height="250px">
                <thead>
                    <tr nobr="true">
                        <th style="text-align: center;font-size: 14px;font-weight: bold;" class="fuente_titulo">
                            <h1><?= $empresa ?> </h1>
                        </th>
                    </tr>
                    <!-- Espaciador -->
                    <tr>
                        <th></th>
                    </tr>
                    <tr>
                        <th style="text-align: center;font-size: 15px;">
                            Cotización
                        </th>
                    </tr>
                    <tr>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <td width="15%">Señores(as): </td>
                                    <td width="65%" style="border-bottom: 1px solid black"><b><?php echo $consulta[0]['nombre']; ?></b></td>
                                    <td width="20%">

                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <td width="15%">Atención: </td>
                                    <td width="65%" style="border-bottom: 1px solid black"><?= $consulta[0]['cot_dirigido'] ?></td>
                                    <td width="20%">&nbsp;Fecha: <?= formatear_fecha('d-m-Y', $consulta[0]['cot_fecha']) ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <!-- Espaciador -->
                    <tr>
                        <td></td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <td style="text-align: justify;">De conformidad a su solicitud, presento a Usted(es) el detalle de la cotización, esperamos que sea de su completo agrado</td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <!-- Espaciador -->
                    <tr>
                        <td></td>
                    </tr>
                    <!-- ********************************************************************************************************************* -->
                    <!-- *                                              Detalle de los productos                                               -->
                    <!-- ********************************************************************************************************************* -->
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="1" cellspacing="0.5">
                                <thead>
                                    <tr style="text-align: center;background-color: #0e33ed;color: #ffffff;font-weight: bold;">
                                        <th width="13%">Cantidad</th>
                                        <th width="37%">Descripción</th>
                                        <th width="20%">Marca</th>
                                        <th width="15%">Valor</th>
                                        <th width="15%">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($detalle_productos as $detalle) {
                                        // Totallidad
                                        $total = $detalle["axc_cantidad"] * $detalle["axc_precio"];
                                        $neto  += $total;
                                    ?>
                                        <tr style="text-align: center;font-weight: bold;">
                                            <td><?= number_format($detalle["axc_cantidad"], 0) ?></td>
                                            <td><?= $detalle['axc_descripcion'] ?></td>
                                            <td><?= $detalle['mrp_nombre'] ?></td>
                                            <td style="text-align: right;"><?= $simbolo . number_format($detalle["axc_precio"], $decimales, ".", "") ?></td>
                                            <td style="text-align: right;"><?= $simbolo . number_format($total, $decimales, ".", "") ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="4" style="text-align: right;font-weight: bold;">TOTAL&nbsp;</td>
                                        <td style="text-align: right;font-weight: bold;"><?= $simbolo . number_format($neto, $decimales, ".", "") ?></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </td>
                    </tr>
                    <!-- ********************************************************************************************************************* -->
                    <!-- *                                              FIN Detalle de los productos                                           -->
                    <!-- ********************************************************************************************************************* -->

                    <!-- Espaciador -->
                    <tr>
                        <td></td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td><b>OBSERVACIONES:</b></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td><b>FORMA DE PAGO:</b> <?= $consulta[0]['tpg_nombre'] ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td><b>LOS PRECIOS INCLUYEN IVA Y ESTÁN COTIZADOS EN DÓLARES</b></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td width="30%"><b>VIGENCIA DE OFERTA:</b></td>
                                    <td width="70%"><?= ($consulta[0]['cot_validez_oferta'] > 0) ? $consulta[0]['cot_validez_oferta'] . ' DÍAS CALENDARIO' : '' ?> </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td width="30%"><b>LUGAR DE ENTREGA:</b></td>
                                    <td width="70%"><?= ($consulta[0]['cot_lugar_entrega'] != "") ? $consulta[0]['cot_lugar_entrega'] : 'A DEFINIR CON EL CLIENTE' ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td width="30%"><b>TIEMPO DE ENTREGA:</b></td>
                                    <td width="70%"><?= ($dias != "") ? $dias->format('%a días') . ' hábiles posteriores a la recepción de la Orden de Compra.' : '' ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td width="30%"><b>CONDICIONES:</b></td>
                                    <td width="70%"><?= $consulta[0]['cot_condicion'] ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>

                    <!-- Espaciador -->
                    <tr>
                        <td></td>
                    </tr>

                    <!-- Parrafo -->
                    <tr>
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table>
                                <tr>
                                    <td>
                                        <table>
                                            <tr>
                                                <td>Gracias por darnos la oportunidad de ofrecerle este presupuesto. Para nosotros será un placer
                                                    poder atender su pedido y esperamos que sea de su completa satisfacción.
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <!-- Separador -->
                    <tr>
                        <td height="40px"></td>
                    </tr>
                    <tr>
                        <td>
                            <table border="0" cellspacing="2">
                                <tr style="text-align: center;">
                                    <td width="10%"></td>
                                    <!-- Para firmar Gerente -->
                                    <td width="35%" style="border-bottom: 1px solid black"></td>
                                    <td width="10%"></td>
                                    <!-- Firma para cliente -->
                                    <td width="35%" style="border-bottom: 1px solid black"></td>
                                    <td width="10%"></td>
                                </tr>
                                <tr>
                                    <td width="10%"></td>
                                    <td width="35%" style="text-align: center;"><?= $eje_ventas ?></td>
                                    <td width="10%"></td>
                                    <td width="35%" style="font-size: 8px; text-align: center;">AUTORIZADO POR CLIENTE</td>
                                    <td width="10%"></td>
                                </tr>
                                <tr>
                                    <td width="10%"></td>
                                    <td width="35%" style=""><?= $consulta[0]['plz_nombre'] ?></td>
                                    <td width="10%"></td>
                                    <td width="25%" style=""></td>
                                    <td width="10%"></td>
                                </tr>
                                <tr>
                                    <td width="10%"></td>
                                    <td width="35%" style="text-align: center;"><a href="mailto:<?= $consulta[0]['ven_email'] ?>"><?= $consulta[0]['ven_email'] ?></a></td>
                                    <td width="10%"></td>
                                    <td width="35%" style=""></td>
                                    <td width="10%"></td>
                                </tr>
                                <tr>
                                    <td width="10%"></td>
                                    <td width="35%" style="text-align: center;"><?= $consulta[0]['ven_telefono'] ?></td>
                                    <td width="10%"></td>
                                    <td width="35%" style=""></td>
                                    <td width="10%"></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                    </tr>
                    <tr>
                        <td>
                            <table>
                                <tr>
                                    <td style="font-size: 9px; text-align: center;">Dirección: <?= $dir_empresa ?></td>
                                </tr>
                                <tr>
                                    <td style="font-size: 9px; text-align: center;">Teléfono. <?= $tel_empresa ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <!-- Espciador -->
                    <tr>
                        <td></td>
                    </tr>
                    <!-- banner -->
                    <tr>
                        <td style="text-align: center;">
                            <?php if ($imagen != "") { ?>
                                <img src="<?= $imagen ?>" width="auto" height="50px">
                            <?php } ?>
                        </td>
                    </tr>
                </tfoot>
            </table>
        </td>
    </tr>
</table>