<?php
/*                                      FORMATO DE COTIZACION DE ESPUMAR                                               */

/***********************************************************************************************************************/
/*                                        configuraciones                                                              */
/***********************************************************************************************************************/
$ruta_imagen = base_url() . ("media/imagenes/sistema/");
$dias        = array("Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sábado");
$meses       = array("Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre");

/***********************************************************************************************************************/
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <style type="text/css">
        .label {
            background: white;
            font-weight: bold;
        }

        #content {
            padding-bottom: 500px;
            border-style: solid
        }

        /* debe ser el mismo alto que el footer */
        table {
            font-size: 9px;
        }
    </style>
</head>

<body>
    <table cellpadding="3" border="0">
        <thead>
            <tr>
                <th colspan="3" bgcolor="#FFFFFF" style="text-align:left;font-weight:bold;border-bottom:1" border="0">
                    <?= ('<img src="' . $ruta_imagen . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . '.png" width="550px" height="90px"> ') ?>
                    <?php //encabezado_cot_espumar 
                    ?>
                </th>
            </tr>
            <tr>
                <th colspan="3"></th>
            </tr>
            <tr>
                <th width="35%">
                    <b>Cotizacion No.:</b>
                    <span style="text-align:left;font-size: 9px;">
                        <u><?php echo $consulta[0]['cot_codigo']; ?></u>
                    </span>
                </th>
                <th width="35%">
                    <b>Fecha:</b>
                    <span style="text-align:left;font-size: 9px;">
                        <u><?php echo formatear_fecha('d/m/Y', $consulta[0]['cot_fecha_pres']); ?></u>
                    </span>
                </th>
                <th width="30%">
                    <b>Hora:</b>
                    <span style="text-align:left;border-bottom:0.1px solid black;"></span>
                </th>
            </tr>
            <tr>
                <th width="70%" colspan="2">
                    <b>Cliente: </b>
                    <span style="text-align:left;border-bottom:0.1px solid black;">
                        <u><?= trim($consulta[0]['nombre']) ?></u>
                    </span>
                </th>
                <th width="30%">
                    <b>Código: </b>
                    <span style="border-bottom:0.1px solid black;">
                        <u><?= trim($consulta[0]['cli_codigo']) ?></u>
                    </span>
                </th>
            </tr>
            <tr>
                <th>
                    <b>Depto.: </b>
                    <span style="text-align:left;font-weight:bold;">

                    </span>
                </th>
                <th>
                    <b>Municipio:</b>
                    <span style="text-align:left;font-weight:bold;">

                    </span>
                </th>
                <th>
                    <b>C/F __</b>
                    <b>F __</b>
                    <b>N/R __</b>
                    <b>N/D __</b>
                    <b>N/C __</b>
                </th>
            </tr>
            <tr>
                <th>
                    <b>Condiciones: </b>
                    <span>
                        <u><?= $consulta[0]['tpg_nombre'] ?></u>
                    </span>
                </th>
                <th>
                    <b>Tel.:</b>
                </th>
                <th>
                    <b>F. Despacho: </b>
                    <span style="text-align:left;font-size: 9px;">
                        <u><?php echo formatear_fecha('d/m/Y', $consulta[0]['cot_fecha_entrega']); ?></u></span>
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td colspan="3"></td>
            </tr>
            <tr>
                <!-- El Atributo height ayuda a bajar el apartado de datos del vendedor y clientes hasta el pie de pagina -->
                <td width="100%" colspan="3" height="370px">
                    <table border="1">
                        <!-- Titulo -->
                        <thead>
                            <tr style="text-align: center;font-weight: bold;">
                                <th width="15%">CANTIDAD</th>
                                <th width="40%">DESCRIPCIÓN</th>
                                <th width="15%">CÓDIGO DE ARTICULO</th>
                                <th width="15%">PRECIO <br>UNITARIO</th>
                                <th width="15%">TOTAL</th>
                            </tr>
                        </thead>
                        <!-- Detalle de los productos -->
                        <tbody>
                            <?php foreach ($detalle_productos as $fila) { ?>
                                <?php
                                $cantidad       = $fila['axc_cantidad'];
                                $descripcion    = $fila['axc_descripcion'];
                                $precio_uni     = $fila['axc_precio'];
                                $cod_articulo   = $fila['art_codigo'];
                                $total          = $fila['axc_total'];
                                ?>
                                <tr style="text-align: center;" nobr="true">
                                    <td><?= number_format($cantidad, 2, '.', '') ?></td>
                                    <td><?= $descripcion ?></td>
                                    <td><?= $cod_articulo ?></td>
                                    <td><?= $simbolo ?><?= number_format($precio_uni, $decimales) ?></td>
                                    <td><?= $simbolo ?><?= number_format($total, $decimales) ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </td>
            </tr>
            <!-- Espaciador -->
            <tr>
                <td colspan="3"></td>
            </tr>
        </tbody>
        <!-- Pie de Pagina para datos del vendedor -->
        <tfoot>
            <tr>
                <td colspan="2">
                    <b>Nombre de Vendedor:</b>
                    <span style="border: 5px solid red;"><u>
                            <?= trim($consulta[0]['ven_nombre'] . " " . $consulta[0]['ven_apellidos']) ?></u>
                    </span>
                </td>
                <td>
                    <b>Código:</b>
                    <span style="border-bottom: 1px solid black">
                        <u><?= trim($consulta[0]['ven_codigo']) ?></u>
                    </span>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <b>Nombre del Cliente:</b>
                    <span>
                        _____________________________________________________
                    </span>
                </td>
                <td>
                    <b>Firma:</b>
                    ___________________________
                </td>
            </tr>
            <tr>
                <td width="19%">
                    <b>Observaciones:</b>
                </td>
                <td width="79%" style="border-bottom: 1px solid black">
                    <?= trim($consulta[0]['cot_comentario']) ?>

                </td>
            </tr>
            <tr>
                <td width="1%"></td>
                <td height="19" width="97%" colspan="2" style="font-weight:bold;border-bottom: 1px solid black;">

                </td>
                <td width="2%"></td>
            </tr>
        </tfoot>
    </table>
</body>

</html>