<?php
/*************************************************************************************************************************************/
/*                                                        Configuraciones                                                            */
/*************************************************************************************************************************************/
$empresa     = $this->gsatelite->get_parametro('SYS_EMPRESA');
$dir_empresa = $this->gsatelite->get_parametro('SYS_DIR');
$tel_empresa = $this->gsatelite->get_parametro('SYS_TEL');
$tipo_fuente = $this->gsatelite->get_parametro('SYS_FUENTE_TITULO');
$eje_ventas  = ($consulta[0]['ven_nombre'] != "" && $consulta[0]['ven_apellidos'] != "") ? $consulta[0]['ven_nombre'] . ' ' . $consulta[0]['ven_apellidos'] : $this->gsatelite->get_parametro('COT_GERENTE_ADMINISTRATIVO');
// Altura del texto
$alt_txt_titulo = 15;
// Declaracion de variables globals
$neto          = 0;
$decimales     = (isset($decimales) && $decimales > 0) ? $decimales : 2;
$tamanio_letra = 8;
$mes = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
// Configurar banner y verificar si existe el archivo
$imagen = base_url("/media/imagenes/sistema/" . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . ".png");
$par_bancos = $this->gsatelite->get_parametro_emp('SYS_ABONO_CUENTA_COTIZACION', "");
$sucursal = $this->gsatelite->get_tabla('suc_sucursal', array('suc_direccion IS NOT NULL' => null));
$this->db->join('ban_banco', 'ban_id = cub_id_ban');
$tbl_bank = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_estado' => 1, 'ban_estado' => 1));
if (!isset($imagen) && !file_exists($imagen)) {
    $imagen = "";
}
// Calculo de dias
$f1 = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['cot_fecha_pres']));
$f2 = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['cot_fecha_entrega']));
$dias = ($consulta[0]['cot_fecha_pres'] != "" && $consulta[0]['cot_fecha_entrega'] != "") ? $f1->diff($f2) : '';
$simbolo = $this->gsatelite->get_parametro('SYS_SIMBOLO_MONEDA', ' ');
$cot_total = explode(".", $consulta[0]['cot_total']);
for ($i = 0; $i < 2; $i++) {
    $num  = $cot_total[1];
    $total_decimales = strlen($num);
    if ($total_decimales == 1) {
        $num .= 0;
    }
}
$valor_letras = $this->enletras->ValorEnLetrasV2($cot_total[0]);
$valor_letras .= " con " . $num . "/100 USD";
/*************************************************************************************************************************************/
?>
<!-- Configuraciones CSS -->
<style type="text/css">
    .fuente_titulo {
        /* font-family: <?php echo $tipo_fuente; ?>; */
        font-size: "sans-serif";
    }
    .Section1 {
        font-weight: bold;
    }
    .bl {
        border-left: solid 1px black;
    }
    .br {
        border-right: solid 1px black;
    }
    .bt {
        border-top: 1px solid black;
    }
    .s-border {
        border: solid 1px black;
    }
    .n-border {
        border: none;
    }
    .up {
            border-top: solid 1px black;
        }
    .lf {
        border-left: solid 1px black;
    }
    .rg {
        border-right: solid 1px black;
    }
    .dw {
        border-bottom: solid 1px black;
    }
    .base_color{
        background-color: #66ADD9;
        color: #FEFEFE;
    }
    .bold{
        font-weight: bold;
    }
    .bolder{
        font-weight: bolder;
    }
    .normal{
        font-weight: normal;
    }
    .font8{
        font-size: 8px;
    }

    .font9{
        font-size: 9px;
    }

    .font10{
        font-size: 10px;
    }
    .font12{
        font-size: 12px;
    }

    .font14{
        font-size: 14px;
    }

    .font16{
        font-size: 16px;
    }
    .font18{
        font-size: 18px;
    }

    .aleft{
        text-align: left;
    }
    .aright{
        text-align: right;
    }
    .acenter{
        text-align: center;
    }
</style>

<table class="bolder font9" border="0" cellpadding="2">
    <tr>
        <td class="n-border font10" colspan="2" rowspan="2" width="72%">COTIZACIÓN DE EQUIPO Y CONSUMIBLES</td>
        <td class="n-border" width="3%"></td>
        <td class="dw rg lf up base_color" align="center">FECHA</td>
    </tr>
    <tr>
        <td class="n-border" width="3%"></td>
        <td class="dw rg lf up normal" align="center"><?= formatear_fecha('Y-m-d', $consulta[0]['cot_fecha']) ?></td>
    </tr>
    <tr>
        <td class="dw rg lf up base_color aright" width="15%">CLIENTE:</td>
        <td class="dw rg lf up normal" width="57%"><?= ($consulta[0]['cli_personeria'] == 2) ? $consulta[0]['cli_nombre'] : $consulta[0]['cli_nombre'] . ' ' . $consulta[0]['cli_apellido']; ?></td>
        <td class="n-border" width="3%"></td>
        <td class="dw rg lf up base_color"  align="center">COTIZACIÓN</td>
    </tr>
    <tr>
        <td class="dw rg lf up base_color aright" width="15%">ATENCIÓN:</td>
        <td class="dw rg lf up normal" width="57%"><?=trim($consulta[0]['cot_dirigido'])?></td>
        <td class="n-border" width="3%"></td>
        <td class="dw rg lf up normal"  align="center"><?= $consulta[0]['cot_codigo']; ?></td>
    </tr>
</table>
<br><br><br>
<table border="0" cellpadding="2"  width="100%">
    <thead>
        <tr>
            <th width="5%" class="dw rg lf up base_color acenter font9 bolder">Item</th>
            <th width="10%" class="dw rg lf up base_color acenter font9 bolder" >Cantidad</th>
            <th width="47%" class="dw rg lf up base_color acenter font9 bolder" >No. de parte / Descripción</th>
            <th width="19%" class="dw rg lf up base_color acenter font9 bolder" >Precio Unitario <br>(US$)</th>
            <th width="19%" class="dw rg lf up base_color acenter font9 bolder" >Precio Total <br>(US$)</th>
        </tr>
    </thead>
    <tbody>
        <?php $i = 0; foreach ($detalle_productos as $detalle) {
            $i++;
            // Totallidad
            $total = $detalle["axc_cantidad"] * $detalle["axc_precio"];
            $neto  += $total;
            $prodNombre = ($detalle['art_tipo'] > 0) ? '' : 'P.N. ';
            $art_codigo = ($detalle['art_tipo'] > 0) ? '' : $detalle['art_codigo'] . '<br>';
            $prodNombre .= (trim($detalle['axc_descripcion']) != '') ? $art_codigo . nl2br($detalle['axc_descripcion']) : $art_codigo . $detalle['art_nombre'];
            ?>
            <tr>
                <td width="5%" class="dw rg lf up acenter"><?= $i ?></td>
                <td width="10%" class="dw rg lf up acenter"><?= number_format($detalle["axc_cantidad"], 0) ?></td>
                <td width="47%" class="dw rg lf up"><?php echo $prodNombre; ?></td>
                <td width="19%" class="dw rg lf up aright"><?= $simbolo . number_format($detalle["axc_precio"], 2, ".", "") ?></td>
                <td width="19%" class="dw rg lf up aright"><?= $simbolo . number_format($total, 2) ?><?= ($detalle["axc_descuento"] > 0) ? '<br><sub>(Descuento ' . number_format($detalle["axc_descuento"], 2) . '%)</sub>' : ''; ?></td>
            </tr>
        <?php } ?>
    </tbody>
    <tfoot>
        <?php if ($consulta[0]['cot_descuento'] > 0): ?>
            <tr>
                <td colspan="4" width="81%" class="aright bolder font9" >Sumas:  </td>
                <td width="19%" class="aright dw rg lf up"><?= $simbolo . number_format(($consulta[0]['cot_subtotal'] + $consulta[0]['cot_descuento']), 2) ?></td>
            </tr>
            <tr>
                <td colspan="4" width="81%"  class="aright bolder font9" >Descuentos:  </td>
                <td width="19%" class="aright dw rg lf up">(<?= $simbolo . number_format($consulta[0]['cot_descuento'], 2) ?>)</td>
            </tr>            
        <?php endif ?>
        <tr>
            <td colspan="4" width="81%" class="aright bolder font9" >Sub-total:  </td>
            <td width="19%" class="aright dw rg lf up"><?= $simbolo . number_format($consulta[0]['cot_subtotal'], 2) ?></td>
        </tr>
        <tr>
            <td colspan="4" width="81%"  class="aright bolder font9" >IVA 13%:  </td>
            <td width="19%" class="aright dw rg lf up"><?= $simbolo . number_format($consulta[0]['cot_impuesto'], 2) ?></td>
        </tr>
        <tr>
            <td colspan="4" width="81%"  class="aright bolder font9">TOTAL US$: </td>
            <td width="19%" class="aright dw rg lf up"><?= $simbolo . number_format($consulta[0]['cot_total'], 2) ?></td>
        </tr>
        <tr>
            <td style="height:20px" colspan="5" width="100%"  class="acenter bolder font9"></td>
        </tr>
        <tr>
            <td style="height:20px" colspan="5" width="100%"  class="acenter bolder font9"><p>TOTAL: <?= $valor_letras ?></p></td>
        </tr>
        <tr>
            <td  colspan="5" width="100%"  class="aleft dw rg lf up bolder font9">NOTA: <?= ($consulta[0]['cot_condicion'] )? nl2br($consulta[0]['cot_condicion']):" " ?></td>
        </tr>
    </tfoot>
</table>
<br><br><br>
<?php if ($consulta[0]['cot_id_cod'] > 0) {
    $cod = $this->gsatelite->get_registro("cod_condicion", array("cod_id" => $consulta[0]['cot_id_cod']));
    $terminosPago = $cod->cod_nombre;
} else {
    $terminosPago = ($consulta[0]['cli_dias_plazo'] != "") ? $consulta[0]['cli_dias_plazo'] . ' días' : '';
} 
if (trim($consulta[0]['cot_fecha_entrega_texto']) != "") {
    $tiempoEntrega = trim($consulta[0]['cot_fecha_entrega_texto']);
} else {
    $tiempoEntrega = ($dias != "") ? $dias->format('%a días') . ' hábiles posteriores a la recepción de la Orden de Compra.' : '';
}
if (trim($consulta[0]['cot_validez_texto']) != "") {
    $ofertaValida = trim($consulta[0]['cot_validez_texto']);
} else {
    $ofertaValida = ($consulta[0]['cot_validez_oferta'] > 0) ? $consulta[0]['cot_validez_oferta'] . ' días calendario' : '';
} ?>
<table border="0" cellpadding="1" style="width:100%">
    <tr nobr="true">
        <td width="100%" colspan="2"></td>
    </tr>
    <tr nobr="true">
        <td width="25%" class="aleft bolder font9"><u>Condiciones comerciales:</u></td>
        <td width="75%"></td>
    </tr>
    <tr nobr="true">
        <td width="25%" class="aleft bolder font9">1) Términos de pago:</td>
        <td width="75%"><?= $terminosPago ?></td>
    </tr>
    <tr nobr="true">
        <td width="25%" class="aleft bolder font9">2) Forma de pago:</td>
        <td width="75%"><?= $consulta[0]['frp_nombre'] ?></td>
    </tr>
    <tr nobr="true">
        <td width="25%" class="aleft bolder font9">3) Tiempo de entrega:</td>
        <td width="75%"><?= $tiempoEntrega ?></td>
    </tr>
    <tr nobr="true">
        <td width="25%" class="aleft bolder font9">4) Validez de precios:</td>
        <td width="75%"><?= $ofertaValida ?></td>
    </tr>
    <tr nobr="true">
        <td colspan="2" style="height:20px" width="100%" class="aleft bolder font9"></td>
    </tr>
    <tr nobr="true">
        <td colspan="2" style="height:15px" width="100%" class="aleft bolder font9">Atentamente,</td>
    </tr>
    <tr nobr="true">
        <td colspan="2" align="center" class="acenter">
            <img align="center" width="100x" src="<?= FCPATH . '/media/logo_per_cotizaciones/firma_instruquimica.jpg' ?>">
        </td>            
    </tr>
    <tr nobr="true">
        <td colspan="2">
            <table border="0" cellpadding="1">

                <tr>
                    <td width="38%" class="aright font9"></td>
                    <td width="10%" class="font9 bolder">Contacto:</td>
                    <td width="50%" class="font9"><?php echo $consulta[0]['ven_nombre'] . " " . $consulta[0]['ven_apellidos']; ?></td>
                </tr>
                <tr>
                    <td width="38%" class="font9"></td>
                    <td width="10%" class="font9 bolder">Correo:</td>
                    <td width="50%" class="font9" style="aleft"><?php echo $consulta[0]['ven_email']?></td>
                </tr>
                
            </table>
        </td>
    </tr>

</table>

<br style="page-break-after: always;">

<table cellpadding="1" style="width: 100%;">

    <tr>
        <td width="100%"><h3 style="text-align: center;">TÉRMINOS Y CONDICIONES</h3>

<p>Los equipos o partes de repuestos vendidos por <b>“INSTRUQUIMICA S.A. DE C.V.”</b> incluyen instalación sin cargo adicional, salvo que se exprese lo contrario en esta cotización. El equipo o partes de repuestos deberán instalarse dentro de los 15 días calendario posteriores a la entrega física en su almacén. En caso de no instalarse dentro del periodo establecido por razones ajenas a nuestra empresa, el equipo o repuestos se considerarán como aceptados de conformidad, la garantía iniciará su vigencia; así como, el plazo establecido para realizar el pago. El <b>“Cliente”</b> es responsable del suministro de energía eléctrica, el sitio de instalación y las condiciones ambientales requeridas por el equipo y que están descritas en la Guía de Preinstalación provista.</p>

<h4>Capacitación y Soporte en Aplicaciones:</h4>
<p>Los equipos vendidos por <b>“INSTRUQUIMICA”</b> incluyen capacitación y soporte en aplicaciones sin cargo adicional, salvo que se exprese lo contrario en esta cotización.</p>

<h4>Aceptación:</h4>
<p>Al momento de la firma de aceptación de esta propuesta, envío de orden de compra o contrato, se asume que acepta y se obliga a cumplir con los términos y condiciones aquí citados.</p>

<h4>Condiciones de Precio:</h4>
<p>La cancelación de la orden de compra tiene penalización del <b>10%</b> del monto de la misma.</p>

<?php // creo que por problemas con un cliente, este termino se eliminó y mejor se suma en el costo del producto). ?>
<!-- <p><b>*EN EL EXTRANJERO:</b> Para transferencias bancarias internacionales el cliente debe agregar <b>$30</b> en concepto de gastos bancarios.</p> -->

<h4>Entrega de Productos y/o Servicios:</h4>
<p>La entrega de los productos fuera del área metropolitana de San Salvador es por compras mínimas de <b>$400.00</b>, de lo contrario el cliente deberá esperar a que se programe visita a la zona.</p>

<p><b>No se aceptan devoluciones de producto de ningún tipo.</b></p>

<p>En caso de que exista retraso en las condiciones de pago acordadas, <b>“INSTRUQUIMICA S.A. DE C.V.”</b> se reserva el derecho de detener cualquier entrega, independientemente de que se trate de pedidos diferentes.</p>

<p>Si las condiciones de instalación, capacitación, desarrollo de método o cualquier condición acordada y confirmada no es cumplida por el <b>“Cliente”</b>, no será motivo para el retraso del pago total de esta oferta.</p>

<p>En caso de compra de servicios de mantenimiento preventivo, calibración, calificación y/o ajuste y al equipo no se le pueda ejecutar el servicio debido a fallas en este, se presentará una nueva cotización por el servicio de reparación. En el caso que el cliente decida no repararlo deberá pagar el diagnóstico por el mismo valor del servicio aprobado previamente.</p>

<h4>Garantía:</h4>
<p>La garantía cubre desperfectos de fábrica y no incluye daños por mal uso, consumibles, daños por variaciones de voltaje, caídas, golpes o cualquier uso diferente al destinado normalmente.</p>

<p>La garantía se pierde si el equipo es manipulado por personal técnico diferente a nuestro Departamento de Soporte Técnico.</p>

<p>Antes de la aceptación de esta propuesta firmada, orden de compra o contrato por parte de <b>“INSTRUQUIMICA S.A. DE C.V.”</b>, el tipo y fechas de pago deben ser negociados, acordados y definidos por escrito en la cotización y aprobados en la confirmación de pedido.</p>
</td>
    </tr>
    
</table>