<?php

/*************************************************************************************************************************************/
/*                                                        Configuraciones                                                            */
/*************************************************************************************************************************************/
$empresa     = $this->gsatelite->get_parametro('SYS_EMPRESA');
$dir_empresa = $this->gsatelite->get_parametro('SYS_DIR');
$tel_empresa = $this->gsatelite->get_parametro('SYS_TEL');
$tipo_fuente = $this->gsatelite->get_parametro('SYS_FUENTE_TITULO');
$eje_ventas  = ($consulta[0]['ven_nombre'] != "" && $consulta[0]['ven_apellidos'] != "") ? $consulta[0]['ven_nombre'] . ' ' . $consulta[0]['ven_apellidos'] : $this->gsatelite->get_parametro('COT_GERENTE_ADMINISTRATIVO');
// Altura del texto
$alt_txt_titulo = 15;
// Declaracion de variables globals
$neto          = 0;
$decimales     = (isset($decimales) && $decimales > 0) ? $decimales : 2;
$tamanio_letra = 8;
$mes = array('Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre');
// Configurar banner y verificar si existe el archivo
$imagen = base_url("/media/imagenes/sistema/" . $this->gsatelite->get_parametro('SYS_LOGOTIPO') . ".png");
$par_bancos = $this->gsatelite->get_parametro_emp('SYS_ABONO_CUENTA_COTIZACION', "");
$sucursal = $this->gsatelite->get_tabla('suc_sucursal', array('suc_direccion IS NOT NULL' => null));
$this->db->join('ban_banco', 'ban_id = cub_id_ban');
$tbl_bank = $this->gsatelite->get_tabla('cub_cuenta_bancaria', array('cub_estado' => 1, 'ban_estado' => 1));
if (!isset($imagen) && !file_exists($imagen)) {
    $imagen = "";
}
// Calculo de dias
$f1 = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['cot_fecha_pres']));
$f2 = new DateTime(formatear_fecha('Y-m-d', $consulta[0]['cot_fecha_entrega']));
$dias = ($consulta[0]['cot_fecha_pres'] != "" && $consulta[0]['cot_fecha_entrega'] != "") ? $f1->diff($f2) : '';
/*************************************************************************************************************************************/
// var_dump($f1, $f2, $dias);die();
?>
<!-- Configuraciones CSS -->
<style type="text/css">
    .fuente_titulo {
        /* font-family: <?php echo $tipo_fuente; ?>; */
        font-size: "sans-serif";
    }

    .Section1 {
        font-weight: bold;
    }

    .bl {
        border-left: solid 1px black;
    }

    .br {
        border-right: solid 1px black;
    }

    .bt {
        border-top: 1px solid black;
    }
</style>

<head>
    <div class="logo"></div>
</head>
<table border="0">
    <tr>
        <td width="5%"></td> <!-- Espacio para colocar el contendo a la izquierda -->
        <td width="90%" height="<?= $alt_txt_titulo ?>px"></td> <!-- Espacio para colocar el contenido hacia abajo -->
        <td width="5%"></td>
    </tr>
    <tr>
        <td></td>
        <td>
            <table border="0" cellpadding="0" height="250px">
                <thead>
                    <tr nobr="true">
                        <td style="text-align: left;">
                            <table border="0" cellpadding="0" width="100%">
                                <tr>
                                    <td width="60%">
                                        <?php if ($imagen != "") { ?>
                                            <img src="<?= $imagen ?>" width="auto" height="60px">
                                        <?php } ?>
                                    </td><?php /* 77A2E4 */ ?>
                                    <td width="40%" style="text-align: right; font-size: 9px; font-weight: bold; color: #385F98;">
                                        <ul style="float: right;">
                                            <li>BLOQUES</li>
                                            <li>ADOQUINES</li>
                                            <li>CASAS</li>
                                            <li>TAPIALES</li>
                                            <li>PREFABRICADOS DE CONCRETO</li>
                                        </ul>
                                    </td>
                                </tr>
                                <hr style="height: 2px; border: none; background-color: #385F98;">
                            </table>
                        </td>
                    </tr>
                    <tr>
                        <th height="15px"></th>
                    </tr>
                </thead>
                <tbody>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0" width="100%">
                                <tr>
                                    <td width="100%" style="text-align: right;"><?= ($mun_empresa != "") ? $mun_empresa : 'San Salvador'; ?>, <?php echo date("d") . ' de ' . $mes[date("n") - 1] . ' de ' . date("Y"); ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr nobr="true"><!-- Espaciador -->
                        <td height="15px"></td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <td width="75%">
                                        <p>
                                            Señor(es):<br>
                                            <b><?php echo strtoupper($consulta[0]['nombre']); ?></b><br>
                                            Presente.
                                        </p>
                                    </td>
                                    <td width="25%" style="text-align: right;">
                                        <p>
                                            N. Cotizacion:<br>
                                            <b><?php echo $consulta[0]['cot_codigo']; ?></b>
                                        </p>
                                    </td>
                                </tr>
                                <tr>
                                    <td width="100%">
                                        <p>
                                            <br>
                                            Tenemos el gusto de cotizarle nuestros productos calidad <b><?php echo $empresa ?></b> para sus proyectos de construcción.
                                        </p>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <!-- Espaciador -->
                    <tr nobr="true">
                        <td height="15px"></td>
                    </tr>
                    <!-- ********************************************************************************************************************* -->
                    <!-- *                                              Detalle de los productos                                               -->
                    <!-- ********************************************************************************************************************* -->
                    <tr nobr="true">
                        <td style="text-align: center; font-size: <?= $tamanio_letra ?>px;">
                            <table border="0" cellpadding="1" cellspacing="0.5" width="100%">
                                <thead>
                                    <tr style="text-align: center;background-color: #77A2E4;color: #000000;font-weight: bold;">
                                        <th width="55%" style="border: solid 1px black;">Descripción</th>
                                        <th width="15%" style="border: solid 1px black;">Cantidad</th>
                                        <th width="15%" style="border: solid 1px black;">Valor</th>
                                        <th width="15%" style="border: solid 1px black;">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($detalle_productos as $detalle) {
                                        // Totallidad
                                        $total = $detalle["axc_cantidad"] * $detalle["axc_precio"];
                                        $neto  += $total;
                                    ?>
                                        <tr nobr="true" style="text-align: center;font-weight: bold;">
                                            <td style="text-align: left; border: solid 1px black;"><?php echo (trim($detalle['axc_descripcion']) != '') ? $detalle['axc_descripcion'] : $detalle['art_nombre']; ?></td>
                                            <td style="text-align: center; border: solid 1px black;"><?= number_format($detalle["axc_cantidad"], 0) ?></td>
                                            <td style="text-align: right; border: solid 1px black;"><?= $simbolo . number_format($detalle["axc_precio"], $decimales, ".", "") ?></td>
                                            <td style="text-align: right; border: solid 1px black;"><?= $simbolo . number_format($total, 2) ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td width="55%"></td>
                                        <td width="30%" colspan="2" class="bl" style="text-align: left; font-weight: bold;">SUBTOTAL US$ DÓLARES </td>
                                        <td class="br" style="text-align: right; font-weight: bold;"><?= $simbolo . number_format($consulta[0]['cot_subtotal'], 2) ?></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td colspan="2" class="bl bt" style="text-align: left; font-weight: bold;">MÁS 13% IVA </td>
                                        <td class="br bt" style="text-align: right; font-weight: bold; border-bottom: 1px solid black"><?= $simbolo . number_format($consulta[0]['cot_impuesto'], 2) ?></td>
                                    </tr>
                                    <tr>
                                        <td></td>
                                        <td colspan="2" class="bl bt" style="text-align: left; font-weight: bold; border-bottom: 1px double black">SUBTOTAL US$ DÓLARES </td>
                                        <td class="br" style="text-align: right; font-weight: bold; border-bottom: 1px double black;"><?= $simbolo . number_format($consulta[0]['cot_subtotal'] + $consulta[0]['cot_impuesto'], 2) ?></td>
                                    </tr>
                                    <!-- <tr>
                                        <td></td>
                                        <td colspan="2" class="bl" style="text-align: left; font-weight: bold; border-bottom: 1px double black; color: green;">MENOS DESCUENTO </td>
                                        <td class="br" style="text-align: right; font-weight: bold; border-bottom: 1px double black; color: green;"><?= $simbolo . number_format($consulta[0]['cot_descuento'], 2) ?></td>
                                    </tr> -->
                                    <tr>
                                        <td></td>
                                        <td colspan="2" class="bl" style="text-align: left; font-weight: bold; border-bottom: 1px double black; color: red;">TOTAL US$ DÓLARES </td>
                                        <td class="br" style="text-align: right;font-weight: bold; border-bottom: 1px double black; color: red;"><?= $simbolo . number_format($consulta[0]['cot_total'], 2) ?></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </td>
                    </tr>
                    <!-- ********************************************************************************************************************* -->
                    <!-- *                                              FIN Detalle de los productos                                           -->
                    <!-- ********************************************************************************************************************* -->
                    <!-- Espaciador -->
                    <tr nobr="true">
                        <td height="15px"></td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0" width="90%">
                                <tr>
                                    <td><b><span>➢</span> FORMA DE PAGO DE SUMINISTRO:</b> <?= $consulta[0]['tpg_nombre'] ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <br>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <td><b>Entrega de material:</b></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <td>
                                        <!-- &#10004; <?php echo (count($sucursal) > 1) ? $sucursal[1]['suc_nombre'] : "Planta Prefasa"; ?>, ubicada en <?php echo (count($sucursal) > 1) ? $sucursal[1]['suc_direccion'] : "carretera a Sonsonate km. 29½"; ?>.
                                            <br> -->
                                        <!-- <br>
                                                &#10004;    Planta Prefasa, ubicada en km 29 1/2 carretera a Sonsonate. Antes de llegar a Ateos.
                                            <br> -->
                                        <br>
                                        <span>➢</span> <?php echo $sucursal[1]['suc_direccion'] ?>
                                        <br>
                                        <br>
                                        <span>➢</span> Favor de avisar con anticipación el día en que se efectuará el retiro, para garantizar la disponibilidad del material.
                                        <br>
                                        <br>
                                        <span>➢</span> El despacho es de lunes a viernes de 6:00 am a 2:00pm.
                                        <br>
                                        <!-- <br>
                                                &#10004;    Después de las 2:00 no se deja entrar ningún transporte.
                                            <br> -->
                                        <br>
                                        <span>➢</span> Sábados de 7:00am a 10:30am.
                                        <br>
                                        <!-- <br>
                                                &#10004;    Favor contratar transporte y personal para cargar el material ya que los precios no incluyen dicho costo.
                                            <br> -->
                                        <br>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <!-- Espaciador -->
                    <tr nobr="true">
                        <td></td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;">
                            <table border="0">
                                <tr>
                                    <?php if ($consulta[0]['cot_aplica_transporte'] == 0) { ?>
                                        <td><b>➢ <?php echo $empresa ?> No cuenta con transporte, favor contratarlo y tambien personal para cargar y recordarles que debe llevar su equipo de protección personal para poder ingresar.</b></td>
                                </tr>
                            </table>
                        </td>
                    <?php } else if ($consulta[0]['cot_aplica_transporte'] == 1) { ?>
                        <td><b>➢ <?php echo $empresa ?> No cuenta con personal para cargar y recordarles que debe llevar su equipo de protección personal para poder ingresar.</b></td>
                    </tr>
            </table>
        </td>
    <?php } ?>
    </tr>
    <!-- Espaciador -->
    <tr nobr="true">
        <td></td>
    </tr>
    <tr nobr="true">
        <td style="font-size: <?= $tamanio_letra ?>px;">
            <table width="90%">
                <tr>
                    <td><b>➢ No se admiten devoluciones o reembolsos de materiales.</b></td>
                </tr>
            </table>
        </td>
    </tr>
    <!-- Espaciador -->
    <tr nobr="true">
        <td></td>
    </tr>
    <tr nobr="true">
        <td style="font-size: <?= $tamanio_letra ?>px;">
            <table width="90%">
                <tr>
                    <td><b><b><span>➢</span> CHEQUES A NOMBRE DE:</b> <?php echo $empresa ?></b></td>
                </tr>
            </table>
        </td>
    </tr>
    <!-- Espaciador -->
    <tr nobr="true">
        <td></td>
    </tr>
    <tr nobr="true">
        <td style="font-size: <?= $tamanio_letra ?>px;">
            <table border="0">
                <tr>
                    <td><b><span>➢</span> ABONO A CUENTA CORRIENTE DE <?php echo mb_strtoupper($empresa, 'UTF-8') ?>:</b></td>
                </tr>
            </table>
        </td>
    </tr>
    <br>
    <tr nobr="true">
        <td style="font-size: <?= $tamanio_letra ?>px;">
            <table border="0">
                <tr>
                    <td style="text-align: justify;">
                        <dd><?php if (trim($par_bancos) != "") { ?>
                                <p><?php echo mb_strtoupper(nl2br($par_bancos), 'UTF-8')  ?></p>
                                <?php } else {
                                if (count($tbl_bank) < 0) { //de momento se dejara el texto quemado
                                    foreach ($tbl_bank as $key => $val) {
                                ?>
                                        <li><span></span><b><?php echo mb_strtoupper($val['ban_nombre'], 'UTF-8') ?>: </b> <?php echo $val['cub_numero'] ?></li>
                                    <?php
                                    }
                                } else {
                                    ?>
                                    <li><span></span><b>Banco DAVIVIENDA:</b> 002-1800665-02</li>
                                    <li><span></span><b>Banco Cuscatlán:</b> 0303-01000007385</li>
                                    <li><span></span><b>Banco Atlántida:</b> 3803013801612</li>
                                    <li><span></span><b>Banco Agricola:</b> 555002662-6</li>
                                    <li><span></span><b>Banco de América Central:</b> 200709962</li>
                                    <br>
                            <?php
                                }
                            } ?>
                        </dd>
                        <br>
                        <!-- <p style="font-weight: bold;">SI EL PAGO ES EN EFECTIVO EL CLIENTE LO HARÁ EN LAS OFICINAS UBICADAS EN: 
                                            <?php echo mb_strtoupper($dir_empresa, 'UTF-8') ?> <?php echo (count($sucursal) > 1) ? "O EN " . $sucursal[1]['suc_nombre'] . " UBICADA EN: " . $sucursal[1]['suc_direccion'] : ""; ?>
                                        </p> -->
                        <P style="font-weight: bold;">SI EL PAGO ES EN EFECTIVO EL CLIENTE DEBERÁ HACERLO EN LAS OFICINAS UBICADAS EN PLAN DE LA LAGUNA O EN PLANTA UBICADA EN CARRETERA A SONSONATE ANTES DE LLEGAR A ATEOS.</P>
                        <br>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <!-- Espaciador -->
    <!-- <tr nobr="true">
                        <td></td>
                    </tr>
                    <tr nobr="true">
                        <td style="font-size: <?= $tamanio_letra ?>px;"><table width="90%">
                    <tr>
                                    <td>Oferta valida por 15 días.</td>
                                </tr>
                            </table>
                        </td>
                    </tr> -->
    <!-- Espaciador -->
    <tr nobr="true">
        <td></td>
    </tr>
    <tr nobr="true">
        <td style="font-size: <?= $tamanio_letra ?>px;">
            <table border="0">
                <tr>
                    <td style="text-align: justify;">Agradeciendo el permitirnos cotizarles y esperando tener el gusto de trabajar con ustedes, me suscribo
                        <br><br>Atentamente
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    </tbody>
    <tfoot>
        <!-- Separador -->
        <tr>
            <td height="40px"></td>
        </tr>
        <tr>
            <td>
                <table border="0" cellspacing="2" width="90%">
                    <tr style="text-align: center;">
                        <td width="10%"></td>
                        <!-- Para firmar Gerente -->
                        <td width="35%" style="border-bottom: 1px solid black"></td>
                        <td width="10%"></td>
                        <!-- Firma para cliente -->
                        <td width="35%" style=""></td>
                        <td width="10%"></td>
                    </tr>
                    <tr>
                        <td width="10%"></td>
                        <td width="35%" style="text-align: center;"><?= $eje_ventas ?></td>
                        <td width="10%"></td>
                        <td width="35%" style="font-size: 8px; text-align: center;"></td><!-- AUTORIZADO POR CLIENTE -->
                        <td width="10%"></td>
                    </tr>
                    <?php if (!empty($consulta[0]['plz_nombre'])) { ?>
                        <tr>
                            <td width="10%"></td>
                            <td width="35%" style="text-align: center;"><?= $consulta[0]['plz_nombre'] ?></td>
                            <td width="10%"></td>
                            <td width="25%" style=""></td>
                            <td width="10%"></td>
                        </tr>
                    <?php } ?>
                    <?php if ($consulta[0]['ven_email'] != '') { ?>
                        <tr>
                            <td width="10%"></td>
                            <td width="35%" style="text-align: center;"><a href="mailto:<?= $consulta[0]['ven_email'] ?>"><?= $consulta[0]['ven_email'] ?></a></td>
                            <td width="10%"></td>
                            <td width="35%" style=""></td>
                            <td width="10%"></td>
                        </tr>
                    <?php } ?>
                    <?php if (!empty($consulta[0]['ven_telefono'])) { ?>
                        <tr>
                            <td width="10%"></td>
                            <td width="35%" style="text-align: center;"><?= $consulta[0]['ven_telefono'] ?></td>
                            <td width="10%"></td>
                            <td width="35%" style=""></td>
                            <td width="10%"></td>
                        </tr>
                    <?php } ?>
                </table>
            </td>
        </tr>
        <!-- Espciador -->
        <tr>
            <td></td>
        </tr>
        <!-- Espciador -->
        <tr>
            <td></td>
        </tr>
        <tr>
            <td>
                <table border="0" cellpadding="0" height="250px">
                    <hr border="2" style="border-color: #77A2E4;">
                    <tr>
                        <td with="50%" style="font-size: 8px; color: #385F98;">
                            <p><b>OFICINA:</b>
                                <br><?= $dir_empresa ?>
                                <br>PBX: <?= $tel_empresa ?>
                            </p>
                        </td>
                        <td with="50%" style="font-size: 8px; color: #385F98;">
                            <p><b><?= $sucursal[1]['suc_nombre'] ?>:</b>
                                <br><?= $sucursal[1]['suc_direccion'] ?>
                                <br>PBX: (503) 2345-6536
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </tfoot>
</table>
</td>
</tr>
</table>